/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.spi.LoggingEvent;

public abstract class PatternConverter {
    public PatternConverter next;
    int min = -1;
    int max = Integer.MAX_VALUE;
    boolean leftAlign = false;
    static String[] SPACES = new String[]{" ", "  ", "    ", "        ", "                ", "                                "};

    protected PatternConverter() {
    }

    protected PatternConverter(FormattingInfo fi2) {
        this.min = fi2.min;
        this.max = fi2.max;
        this.leftAlign = fi2.leftAlign;
    }

    protected abstract String convert(LoggingEvent var1);

    public void format(StringBuffer sbuf, LoggingEvent e10) {
        String s10 = this.convert(e10);
        if (s10 == null) {
            if (0 < this.min) {
                this.spacePad(sbuf, this.min);
            }
            return;
        }
        int len = s10.length();
        if (len > this.max) {
            sbuf.append(s10.substring(len - this.max));
        } else if (len < this.min) {
            if (this.leftAlign) {
                sbuf.append(s10);
                this.spacePad(sbuf, this.min - len);
            } else {
                this.spacePad(sbuf, this.min - len);
                sbuf.append(s10);
            }
        } else {
            sbuf.append(s10);
        }
    }

    public void spacePad(StringBuffer sbuf, int length) {
        while (length >= 32) {
            sbuf.append(SPACES[5]);
            length -= 32;
        }
        int i10 = 4;
        while (i10 >= 0) {
            if ((length & 1 << i10) != 0) {
                sbuf.append(SPACES[i10]);
            }
            --i10;
        }
    }
}

