/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

public class Transform {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String CDATA_PSEUDO_END = "]]&gt;";
    private static final String CDATA_EMBEDED_END = "]]>]]&gt;<![CDATA[";
    private static final int CDATA_END_LEN = "]]>".length();

    public static String escapeTags(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        StringBuffer buf = new StringBuffer(input.length() + 6);
        char ch2 = ' ';
        int len = input.length();
        int i10 = 0;
        while (i10 < len) {
            ch2 = input.charAt(i10);
            if (ch2 == '<') {
                buf.append("&lt;");
            } else if (ch2 == '>') {
                buf.append("&gt;");
            } else {
                buf.append(ch2);
            }
            ++i10;
        }
        return buf.toString();
    }

    public static void appendEscapingCDATA(StringBuffer buf, String str) {
        if (str == null) {
            buf.append("");
            return;
        }
        int end = str.indexOf(CDATA_END);
        if (end < 0) {
            buf.append(str);
            return;
        }
        int start = 0;
        while (end > -1) {
            buf.append(str.substring(start, end));
            buf.append(CDATA_EMBEDED_END);
            start = end + CDATA_END_LEN;
            if (start < str.length()) {
                end = str.indexOf(CDATA_END, start);
                continue;
            }
            return;
        }
        buf.append(str.substring(start));
    }
}

