/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryElement;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryPath;

public class CategoryExplorerModel
extends DefaultTreeModel {
    protected boolean _renderFatal = true;
    protected ActionListener _listener = null;
    protected ActionEvent _event = new ActionEvent(this, 1001, "Nodes Selection changed");

    public CategoryExplorerModel(CategoryNode node) {
        super(node);
    }

    public void addLogRecord(LogRecord lr2) {
        CategoryPath path = new CategoryPath(lr2.getCategory());
        this.addCategory(path);
        CategoryNode node = this.getCategoryNode(path);
        node.addRecord();
        if (this._renderFatal && lr2.isFatal()) {
            TreeNode[] nodes = this.getPathToRoot(node);
            int len = nodes.length;
            int i10 = 1;
            while (i10 < len - 1) {
                CategoryNode parent = (CategoryNode)nodes[i10];
                parent.setHasFatalChildren(true);
                this.nodeChanged(parent);
                ++i10;
            }
            node.setHasFatalRecords(true);
            this.nodeChanged(node);
        }
    }

    public CategoryNode getRootCategoryNode() {
        return (CategoryNode)this.getRoot();
    }

    public CategoryNode getCategoryNode(String category) {
        CategoryPath path = new CategoryPath(category);
        return this.getCategoryNode(path);
    }

    public CategoryNode getCategoryNode(CategoryPath path) {
        CategoryNode root;
        CategoryNode parent = root = (CategoryNode)this.getRoot();
        int i10 = 0;
        while (i10 < path.size()) {
            CategoryElement element = path.categoryElementAt(i10);
            Enumeration<TreeNode> children = parent.children();
            boolean categoryAlreadyExists = false;
            while (children.hasMoreElements()) {
                String pathLC;
                CategoryNode node = (CategoryNode)children.nextElement();
                String title = node.getTitle().toLowerCase();
                if (!title.equals(pathLC = element.getTitle().toLowerCase())) continue;
                categoryAlreadyExists = true;
                parent = node;
                break;
            }
            if (!categoryAlreadyExists) {
                return null;
            }
            ++i10;
        }
        return parent;
    }

    public boolean isCategoryPathActive(CategoryPath path) {
        CategoryNode root;
        CategoryNode parent = root = (CategoryNode)this.getRoot();
        boolean active = false;
        int i10 = 0;
        while (i10 < path.size()) {
            CategoryElement element = path.categoryElementAt(i10);
            Enumeration<TreeNode> children = parent.children();
            boolean categoryAlreadyExists = false;
            active = false;
            while (children.hasMoreElements()) {
                String pathLC;
                CategoryNode node = (CategoryNode)children.nextElement();
                String title = node.getTitle().toLowerCase();
                if (!title.equals(pathLC = element.getTitle().toLowerCase())) continue;
                categoryAlreadyExists = true;
                parent = node;
                if (!parent.isSelected()) break;
                active = true;
                break;
            }
            if (!active || !categoryAlreadyExists) {
                return false;
            }
            ++i10;
        }
        return active;
    }

    public CategoryNode addCategory(CategoryPath path) {
        CategoryNode root;
        CategoryNode parent = root = (CategoryNode)this.getRoot();
        int i10 = 0;
        while (i10 < path.size()) {
            CategoryElement element = path.categoryElementAt(i10);
            Enumeration<TreeNode> children = parent.children();
            boolean categoryAlreadyExists = false;
            while (children.hasMoreElements()) {
                String pathLC;
                CategoryNode node = (CategoryNode)children.nextElement();
                String title = node.getTitle().toLowerCase();
                if (!title.equals(pathLC = element.getTitle().toLowerCase())) continue;
                categoryAlreadyExists = true;
                parent = node;
                break;
            }
            if (!categoryAlreadyExists) {
                CategoryNode newNode = new CategoryNode(element.getTitle());
                this.insertNodeInto(newNode, parent, parent.getChildCount());
                this.refresh(newNode);
                parent = newNode;
            }
            ++i10;
        }
        return parent;
    }

    public void update(CategoryNode node, boolean selected) {
        if (node.isSelected() == selected) {
            return;
        }
        if (selected) {
            this.setParentSelection(node, true);
        } else {
            this.setDescendantSelection(node, false);
        }
    }

    public void setDescendantSelection(CategoryNode node, boolean selected) {
        Enumeration<TreeNode> descendants = node.depthFirstEnumeration();
        while (descendants.hasMoreElements()) {
            CategoryNode current = (CategoryNode)descendants.nextElement();
            if (current.isSelected() == selected) continue;
            current.setSelected(selected);
            this.nodeChanged(current);
        }
        this.notifyActionListeners();
    }

    public void setParentSelection(CategoryNode node, boolean selected) {
        TreeNode[] nodes = this.getPathToRoot(node);
        int len = nodes.length;
        int i10 = 1;
        while (i10 < len) {
            CategoryNode parent = (CategoryNode)nodes[i10];
            if (parent.isSelected() != selected) {
                parent.setSelected(selected);
                this.nodeChanged(parent);
            }
            ++i10;
        }
        this.notifyActionListeners();
    }

    public synchronized void addActionListener(ActionListener l10) {
        this._listener = AWTEventMulticaster.add(this._listener, l10);
    }

    public synchronized void removeActionListener(ActionListener l10) {
        this._listener = AWTEventMulticaster.remove(this._listener, l10);
    }

    public void resetAllNodeCounts() {
        Enumeration<TreeNode> nodes = this.getRootCategoryNode().depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            CategoryNode current = (CategoryNode)nodes.nextElement();
            current.resetNumberOfContainedRecords();
            this.nodeChanged(current);
        }
    }

    public TreePath getTreePathToRoot(CategoryNode node) {
        if (node == null) {
            return null;
        }
        return new TreePath(this.getPathToRoot(node));
    }

    protected void notifyActionListeners() {
        if (this._listener != null) {
            this._listener.actionPerformed(this._event);
        }
    }

    protected void refresh(final CategoryNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CategoryExplorerModel.this.nodeChanged(node);
            }
        });
    }
}

