/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreePath;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNodeEditor;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNodeRenderer;

public class CategoryImmediateEditor
extends DefaultTreeCellEditor {
    private CategoryNodeRenderer renderer;
    protected Icon editingIcon = null;

    public CategoryImmediateEditor(JTree tree, CategoryNodeRenderer renderer, CategoryNodeEditor editor) {
        super(tree, renderer, editor);
        this.renderer = renderer;
        renderer.setIcon(null);
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        ((DefaultTreeCellEditor)this).editingIcon = null;
    }

    public boolean shouldSelectCell(EventObject e10) {
        boolean rv2 = false;
        if (e10 instanceof MouseEvent) {
            MouseEvent me2 = (MouseEvent)e10;
            TreePath path = this.tree.getPathForLocation(me2.getX(), me2.getY());
            CategoryNode node = (CategoryNode)path.getLastPathComponent();
            rv2 = node.isLeaf();
        }
        return rv2;
    }

    public boolean inCheckBoxHitRegion(MouseEvent e10) {
        TreePath path = this.tree.getPathForLocation(e10.getX(), e10.getY());
        if (path == null) {
            return false;
        }
        CategoryNode node = (CategoryNode)path.getLastPathComponent();
        boolean rv2 = false;
        Rectangle bounds = this.tree.getRowBounds(this.lastRow);
        Dimension checkBoxOffset = this.renderer.getCheckBoxOffset();
        bounds.translate(this.offset + checkBoxOffset.width, checkBoxOffset.height);
        rv2 = bounds.contains(e10.getPoint());
        return true;
    }

    protected boolean canEditImmediately(EventObject e10) {
        boolean rv2 = false;
        if (e10 instanceof MouseEvent) {
            MouseEvent me2 = (MouseEvent)e10;
            rv2 = this.inCheckBoxHitRegion(me2);
        }
        return rv2;
    }

    protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.offset = 0;
    }
}

