/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.configure;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

public class MRUFileManager {
    private static final String CONFIG_FILE_NAME = "mru_file_manager";
    private static final int DEFAULT_MAX_SIZE = 3;
    private int _maxSize = 0;
    private LinkedList _mruFileList;

    public MRUFileManager() {
        this.load();
        this.setMaxSize(3);
    }

    public MRUFileManager(int maxSize) {
        this.load();
        this.setMaxSize(maxSize);
    }

    public void save() {
        File file = new File(this.getFilename());
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(this._mruFileList);
            oos.flush();
            oos.close();
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    public int size() {
        return this._mruFileList.size();
    }

    public Object getFile(int index) {
        if (index < this.size()) {
            return this._mruFileList.get(index);
        }
        return null;
    }

    public InputStream getInputStream(int index) throws IOException, FileNotFoundException {
        if (index < this.size()) {
            Object o10 = this.getFile(index);
            if (o10 instanceof File) {
                return this.getInputStream((File)o10);
            }
            return this.getInputStream((URL)o10);
        }
        return null;
    }

    public void set(File file) {
        this.setMRU(file);
    }

    public void set(URL url) {
        this.setMRU(url);
    }

    public String[] getMRUFileList() {
        if (this.size() == 0) {
            return null;
        }
        String[] ss2 = new String[this.size()];
        int i10 = 0;
        while (i10 < this.size()) {
            Object o10 = this.getFile(i10);
            ss2[i10] = o10 instanceof File ? ((File)o10).getAbsolutePath() : o10.toString();
            ++i10;
        }
        return ss2;
    }

    public void moveToTop(int index) {
        this._mruFileList.add(0, this._mruFileList.remove(index));
    }

    public static void createConfigurationDirectory() {
        String home = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        File f10 = new File(home + sep + "lf5");
        if (!f10.exists()) {
            try {
                f10.mkdir();
            }
            catch (SecurityException e10) {
                e10.printStackTrace();
            }
        }
    }

    protected InputStream getInputStream(File file) throws IOException, FileNotFoundException {
        BufferedInputStream reader = new BufferedInputStream(new FileInputStream(file));
        return reader;
    }

    protected InputStream getInputStream(URL url) throws IOException {
        return url.openStream();
    }

    protected void setMRU(Object o10) {
        int index = this._mruFileList.indexOf(o10);
        if (index == -1) {
            this._mruFileList.add(0, o10);
            this.setMaxSize(this._maxSize);
        } else {
            this.moveToTop(index);
        }
    }

    protected void load() {
        MRUFileManager.createConfigurationDirectory();
        File file = new File(this.getFilename());
        if (file.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
                this._mruFileList = (LinkedList)ois.readObject();
                ois.close();
                Iterator it2 = this._mruFileList.iterator();
                while (it2.hasNext()) {
                    Object o10 = it2.next();
                    if (o10 instanceof File || o10 instanceof URL) continue;
                    it2.remove();
                }
            }
            catch (Exception e10) {
                this._mruFileList = new LinkedList();
            }
        } else {
            this._mruFileList = new LinkedList();
        }
    }

    protected String getFilename() {
        String home = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        return home + sep + "lf5" + sep + CONFIG_FILE_NAME;
    }

    protected void setMaxSize(int maxSize) {
        if (maxSize < this._mruFileList.size()) {
            int i10 = 0;
            while (i10 < this._mruFileList.size() - maxSize) {
                this._mruFileList.removeLast();
                ++i10;
            }
        }
        this._maxSize = maxSize;
    }
}

