/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.File;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.net.SocketNode;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;

public class SocketServer {
    static String GENERIC = "generic";
    static String CONFIG_FILE_EXT = ".lcf";
    static Logger cat = Logger.getLogger(class$org$apache$log4j$net$SocketServer == null ? (class$org$apache$log4j$net$SocketServer = SocketServer.class$("org.apache.log4j.net.SocketServer")) : class$org$apache$log4j$net$SocketServer);
    static SocketServer server;
    static int port;
    Hashtable hierarchyMap;
    LoggerRepository genericHierarchy;
    File dir;
    static /* synthetic */ Class class$org$apache$log4j$net$SocketServer;

    public static void main(String[] argv) {
        if (argv.length == 3) {
            SocketServer.init(argv[0], argv[1], argv[2]);
        } else {
            SocketServer.usage("Wrong number of arguments.");
        }
        try {
            cat.info("Listening on port " + port);
            ServerSocket serverSocket = new ServerSocket(port);
            while (true) {
                cat.info("Waiting to accept a new client.");
                Socket socket = serverSocket.accept();
                InetAddress inetAddress = socket.getInetAddress();
                cat.info("Connected to client at " + inetAddress);
                LoggerRepository h10 = (LoggerRepository)SocketServer.server.hierarchyMap.get(inetAddress);
                if (h10 == null) {
                    h10 = server.configureHierarchy(inetAddress);
                }
                cat.info("Starting new socket node.");
                new Thread(new SocketNode(socket, h10)).start();
            }
        }
        catch (Exception e10) {
            e10.printStackTrace();
            return;
        }
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: java " + (class$org$apache$log4j$net$SocketServer == null ? (class$org$apache$log4j$net$SocketServer = SocketServer.class$("org.apache.log4j.net.SocketServer")) : class$org$apache$log4j$net$SocketServer).getName() + " port configFile directory");
        System.exit(1);
    }

    static void init(String portStr, String configFile, String dirStr) {
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e10) {
            e10.printStackTrace();
            SocketServer.usage("Could not interpret port number [" + portStr + "].");
        }
        PropertyConfigurator.configure(configFile);
        File dir = new File(dirStr);
        if (!dir.isDirectory()) {
            SocketServer.usage("[" + dirStr + "] is not a directory.");
        }
        server = new SocketServer(dir);
    }

    public SocketServer(File directory) {
        this.dir = directory;
        this.hierarchyMap = new Hashtable(11);
    }

    LoggerRepository configureHierarchy(InetAddress inetAddress) {
        cat.info("Locating configuration file for " + inetAddress);
        String s10 = inetAddress.toString();
        int i10 = s10.indexOf("/");
        if (i10 == -1) {
            cat.warn("Could not parse the inetAddress [" + inetAddress + "]. Using default hierarchy.");
            return this.genericHierarchy();
        }
        String key = s10.substring(0, i10);
        File configFile = new File(this.dir, key + CONFIG_FILE_EXT);
        if (configFile.exists()) {
            Hierarchy h10 = new Hierarchy(new RootLogger((Level)Priority.DEBUG));
            this.hierarchyMap.put(inetAddress, h10);
            new PropertyConfigurator().doConfigure(configFile.getAbsolutePath(), (LoggerRepository)h10);
            return h10;
        }
        cat.warn("Could not find config file [" + configFile + "].");
        return this.genericHierarchy();
    }

    LoggerRepository genericHierarchy() {
        if (this.genericHierarchy == null) {
            File f10 = new File(this.dir, GENERIC + CONFIG_FILE_EXT);
            if (f10.exists()) {
                this.genericHierarchy = new Hierarchy(new RootLogger((Level)Priority.DEBUG));
                new PropertyConfigurator().doConfigure(f10.getAbsolutePath(), this.genericHierarchy);
            } else {
                cat.warn("Could not find config file [" + f10 + "]. Will use the default hierarchy.");
                this.genericHierarchy = LogManager.getLoggerRepository();
            }
        }
        return this.genericHierarchy;
    }

    static /* synthetic */ Class class$(String x02) {
        try {
            return Class.forName(x02);
        }
        catch (ClassNotFoundException x12) {
            throw new NoClassDefFoundError(x12.getMessage());
        }
    }
}

