/*
 * Decompiled with CFR 0.152.
 */
package org.fife.io;

import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class DocumentReader
extends Reader {
    private long position = 0L;
    private long mark = -1L;
    private Document document;
    private Segment segment;

    public DocumentReader(Document document) {
        this.document = document;
        this.segment = new Segment();
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.position;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        if (this.position >= (long)this.document.getLength()) {
            return -1;
        }
        try {
            this.document.getText((int)this.position, 1, this.segment);
            ++this.position;
            return this.segment.array[this.segment.offset];
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return -1;
        }
    }

    @Override
    public int read(char[] array) {
        return this.read(array, 0, array.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.position >= (long)this.document.getLength()) {
            return -1;
        }
        int k10 = len;
        if (this.position + (long)k10 >= (long)this.document.getLength()) {
            k10 = this.document.getLength() - (int)this.position;
        }
        if (off + k10 >= cbuf.length) {
            k10 = cbuf.length - off;
        }
        try {
            this.document.getText((int)this.position, k10, this.segment);
            this.position += (long)k10;
            System.arraycopy(this.segment.array, this.segment.offset, cbuf, off, k10);
            return k10;
        }
        catch (BadLocationException ble) {
            return -1;
        }
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public void reset() {
        if (this.mark == -1L) {
            this.position = 0L;
        } else {
            this.position = this.mark;
            this.mark = -1L;
        }
    }

    @Override
    public long skip(long n10) {
        if (this.position + n10 <= (long)this.document.getLength()) {
            this.position += n10;
            return n10;
        }
        long temp = this.position;
        this.position = this.document.getLength();
        return (long)this.document.getLength() - temp;
    }

    public void seek(long pos) {
        this.position = Math.min(pos, (long)this.document.getLength());
    }
}

