/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.miginfocom.swing.MigLayout;
import org.fife.rsta.ui.EscapableDialog;
import org.fife.rsta.ui.UIUtil;

public class GoToDialog
extends EscapableDialog {
    private JButton okButton;
    private JButton cancelButton;
    private JTextField lineNumberField;
    private int maxLineNumberAllowed;
    private int lineNumber;
    private String errorDialogTitle;
    private static final String MSG = "org.fife.rsta.ui.GoToDialog";
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.rsta.ui.GoToDialog");

    public GoToDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public GoToDialog(Frame owner) {
        super(owner);
        this.init();
    }

    private void init() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.lineNumber = -1;
        this.maxLineNumberAllowed = 1;
        Listener l10 = new Listener();
        JPanel contentPane = new JPanel(new MigLayout("insets 5 10 5 10,align center"));
        this.setContentPane(contentPane);
        JPanel p12 = new JPanel(new MigLayout("insets 0 0 0 0,align center", "[]5[]", ""));
        this.lineNumberField = new JTextField(16);
        this.lineNumberField.setText("1");
        AbstractDocument doc = (AbstractDocument)this.lineNumberField.getDocument();
        doc.addDocumentListener(l10);
        doc.setDocumentFilter(new NumberDocumentFilter());
        JLabel label = UIUtil.newLabel(msg, "LineNumber", this.lineNumberField);
        p12.add(label);
        p12.add(this.lineNumberField);
        this.okButton = UIUtil.newButton(msg, "OK");
        this.okButton.addActionListener(l10);
        this.cancelButton = UIUtil.newButton(msg, "Cancel");
        this.cancelButton.addActionListener(l10);
        Container bottomPanel = this.createButtonPanel(this.okButton, this.cancelButton);
        contentPane.add((Component)p12, "wrap");
        contentPane.add(bottomPanel);
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(this.okButton);
        this.setTitle("\u8df3\u8f6c\u81f3");
        this.setModal(true);
        this.applyComponentOrientation(orientation);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private boolean attemptToGetGoToLine() {
        try {
            this.lineNumber = Integer.parseInt(this.lineNumberField.getText());
            if (this.lineNumber < 1 || this.lineNumber > this.maxLineNumberAllowed) {
                this.lineNumber = -1;
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.displayInvalidLineNumberMessage();
            return false;
        }
        this.setVisible(false);
        return true;
    }

    protected Container createButtonPanel(JButton ok2, JButton cancel) {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        buttonPanel.add(ok2);
        buttonPanel.add(cancel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)buttonPanel, "After");
        return bottomPanel;
    }

    protected void displayInvalidLineNumberMessage() {
        JOptionPane.showMessageDialog(this, String.valueOf(msg.getString("LineNumberRange")) + this.maxLineNumberAllowed + ".", this.getErrorDialogTitle(), 0);
    }

    @Override
    protected void escapePressed() {
        this.lineNumber = -1;
        super.escapePressed();
    }

    public String getErrorDialogTitle() {
        String title = this.errorDialogTitle;
        if (title == null) {
            title = msg.getString("ErrorDialog.Title");
        }
        return title;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getMaxLineNumberAllowed() {
        return this.maxLineNumberAllowed;
    }

    public void setErrorDialogTitle(String title) {
        this.errorDialogTitle = title;
    }

    public void setMaxLineNumberAllowed(int max) {
        this.maxLineNumberAllowed = max;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.lineNumber = -1;
            this.okButton.setEnabled(this.lineNumberField.getDocument().getLength() > 0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GoToDialog.this.lineNumberField.requestFocusInWindow();
                    GoToDialog.this.lineNumberField.selectAll();
                }
            });
        }
        super.setVisible(visible);
    }

    private class Listener
    implements ActionListener,
    DocumentListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            Object source = e10.getSource();
            if (GoToDialog.this.okButton == source) {
                GoToDialog.this.attemptToGetGoToLine();
            } else if (GoToDialog.this.cancelButton == source) {
                GoToDialog.this.escapePressed();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e10) {
        }

        @Override
        public void insertUpdate(DocumentEvent e10) {
            GoToDialog.this.okButton.setEnabled(GoToDialog.this.lineNumberField.getDocument().getLength() > 0);
        }

        @Override
        public void removeUpdate(DocumentEvent e10) {
            GoToDialog.this.okButton.setEnabled(GoToDialog.this.lineNumberField.getDocument().getLength() > 0);
        }
    }

    private class NumberDocumentFilter
    extends DocumentFilter {
        private NumberDocumentFilter() {
        }

        private String fix(String str) {
            if (str != null) {
                int origLength = str.length();
                int i10 = 0;
                while (i10 < str.length()) {
                    if (!Character.isDigit(str.charAt(i10))) {
                        str = String.valueOf(str.substring(0, i10)) + str.substring(i10 + 1);
                        --i10;
                    }
                    ++i10;
                }
                if (origLength != str.length()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(GoToDialog.this);
                }
            }
            return str;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb2, int offset, String string, AttributeSet attr) throws BadLocationException {
            fb2.insertString(offset, this.fix(string), attr);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb2, int offset, int length, String text, AttributeSet attr) throws BadLocationException {
            fb2.replace(offset, length, this.fix(text), attr);
        }
    }
}

