/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.fife.rsta.ui.EscapableDialog;
import org.fife.rsta.ui.ResizableFrameContentPane;
import org.fife.rsta.ui.UIUtil;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;

public class TextFilePropertiesDialog
extends EscapableDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField filePathField;
    private JComboBox terminatorCombo;
    private JComboBox encodingCombo;
    private JButton okButton;
    private TextEditorPane textArea;
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.rsta.ui.TextFilePropertiesDialog");
    private static final String[] LINE_TERMINATOR_LABELS = new String[]{msg.getString("SysDef"), msg.getString("CR"), msg.getString("LF"), msg.getString("CRLF")};
    private static final String[] LINE_TERMINATORS = new String[]{System.getProperty("line.separator"), "\r", "\n", "\r\n"};

    public TextFilePropertiesDialog(Dialog parent, TextEditorPane textArea) {
        super(parent);
        this.init(textArea);
    }

    public TextFilePropertiesDialog(Frame parent, TextEditorPane textArea) {
        super(parent);
        this.init(textArea);
    }

    @Override
    public void actionPerformed(ActionEvent e10) {
        String command = e10.getActionCommand();
        if ("TerminatorComboBox".equals(command)) {
            this.okButton.setEnabled(true);
        } else if ("encodingCombo".equals(command)) {
            this.okButton.setEnabled(true);
        } else if ("OKButton".equals(command)) {
            String encoding;
            String old;
            String terminator = this.getSelectedLineTerminator();
            if (terminator != null && !terminator.equals(old = (String)this.textArea.getLineSeparator())) {
                this.textArea.setLineSeparator(terminator);
            }
            if ((encoding = (String)this.encodingCombo.getSelectedItem()) != null) {
                this.textArea.setEncoding(encoding);
            }
            this.setVisible(false);
        } else if ("CancelButton".equals(command)) {
            this.escapePressed();
        }
    }

    private int calculateWordCount(TextEditorPane textArea) {
        int wordCount = 0;
        RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
        BreakIterator bi2 = BreakIterator.getWordInstance();
        bi2.setText(new DocumentCharIterator(textArea.getDocument()));
        int nextBoundary = bi2.first();
        while (nextBoundary != -1) {
            try {
                char ch2 = doc.charAt(nextBoundary);
                if (Character.isLetterOrDigit(ch2)) {
                    ++wordCount;
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            nextBoundary = bi2.next();
        }
        return wordCount;
    }

    protected Container createButtonFooter(JButton ok2, JButton cancel) {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        buttonPanel.add(ok2);
        buttonPanel.add(cancel);
        JPanel panel = new JPanel(new BorderLayout());
        ComponentOrientation o10 = this.getComponentOrientation();
        int PADDING = 8;
        int left = o10.isLeftToRight() ? 0 : 8;
        int right = o10.isLeftToRight() ? 8 : 0;
        panel.setBorder(BorderFactory.createEmptyBorder(10, left, 0, right));
        panel.add((Component)buttonPanel, "After");
        return panel;
    }

    protected String createTitle(String fileName) {
        return MessageFormat.format(msg.getString("Title"), this.textArea.getFileName());
    }

    private static final String getFileSizeStringFor(File file) {
        double tempSize;
        int count = 0;
        double prevSize = tempSize = (double)file.length();
        while (count < 4 && (tempSize = prevSize / 1024.0) >= 1.0) {
            prevSize = tempSize;
            ++count;
        }
        String suffix = null;
        switch (count) {
            case 0: {
                suffix = "bytes";
                break;
            }
            case 1: {
                suffix = "KB";
                break;
            }
            case 2: {
                suffix = "MB";
                break;
            }
            case 3: {
                suffix = "GB";
                break;
            }
            case 4: {
                suffix = "TB";
            }
        }
        NumberFormat fileSizeFormat = NumberFormat.getNumberInstance();
        fileSizeFormat.setGroupingUsed(true);
        fileSizeFormat.setMinimumFractionDigits(0);
        fileSizeFormat.setMaximumFractionDigits(1);
        return String.valueOf(fileSizeFormat.format(prevSize)) + " " + suffix;
    }

    private String getSelectedLineTerminator() {
        return LINE_TERMINATORS[this.terminatorCombo.getSelectedIndex()];
    }

    private void init(TextEditorPane textArea) {
        String modifiedString;
        this.textArea = textArea;
        this.setTitle(this.createTitle(textArea.getFileName()));
        ComponentOrientation o10 = ComponentOrientation.getOrientation(this.getLocale());
        ResizableFrameContentPane contentPane = new ResizableFrameContentPane(new BorderLayout());
        contentPane.setBorder(UIUtil.getEmpty5Border());
        JPanel content2 = new JPanel();
        content2.setLayout(new SpringLayout());
        contentPane.add((Component)content2, "North");
        this.filePathField = new JTextField(40);
        this.filePathField.setText(textArea.getFileFullPath());
        this.filePathField.setEditable(false);
        JLabel filePathLabel = UIUtil.newLabel(msg, "Path", this.filePathField);
        JLabel linesLabel = new JLabel(msg.getString("Lines"));
        JLabel linesCountLabel = new JLabel(Integer.toString(textArea.getLineCount()));
        JLabel charsLabel = new JLabel(msg.getString("Characters"));
        JLabel charsCountLabel = new JLabel(Integer.toString(textArea.getDocument().getLength()));
        JLabel wordsLabel = new JLabel(msg.getString("Words"));
        JLabel wordsCountLabel = new JLabel(Integer.toString(this.calculateWordCount(textArea)));
        this.terminatorCombo = new JComboBox<String>(LINE_TERMINATOR_LABELS);
        if (textArea.isReadOnly()) {
            this.terminatorCombo.setEnabled(false);
        }
        UIUtil.fixComboOrientation(this.terminatorCombo);
        this.setSelectedLineTerminator((String)textArea.getLineSeparator());
        this.terminatorCombo.setActionCommand("TerminatorComboBox");
        this.terminatorCombo.addActionListener(this);
        JLabel terminatorLabel = UIUtil.newLabel(msg, "LineTerminator", this.terminatorCombo);
        this.encodingCombo = new JComboBox();
        if (textArea.isReadOnly()) {
            this.encodingCombo.setEnabled(false);
        }
        UIUtil.fixComboOrientation(this.encodingCombo);
        SortedMap<String, Charset> availcs = Charset.availableCharsets();
        Set charsetNames = availcs.keySet();
        for (String charsetName : charsetNames) {
            this.encodingCombo.addItem(charsetName);
        }
        this.setEncoding(textArea.getEncoding());
        this.encodingCombo.setActionCommand("encodingCombo");
        this.encodingCombo.addActionListener(this);
        JLabel encodingLabel = UIUtil.newLabel(msg, "Encoding", this.encodingCombo);
        JLabel sizeLabel = new JLabel(msg.getString("FileSize"));
        File file = new File(textArea.getFileFullPath());
        String size = "";
        if (file.exists() && !file.isDirectory()) {
            size = TextFilePropertiesDialog.getFileSizeStringFor(file);
        }
        JLabel sizeLabel2 = new JLabel(size);
        long temp = textArea.getLastSaveOrLoadTime();
        if (temp <= 0L) {
            modifiedString = "";
        } else {
            Date modifiedDate = new Date(temp);
            SimpleDateFormat sdf = new SimpleDateFormat("hh:mm a  EEE, MMM d, yyyy");
            modifiedString = sdf.format(modifiedDate);
        }
        JLabel modifiedLabel = new JLabel(msg.getString("LastModified"));
        JLabel modified = new JLabel(modifiedString);
        if (o10.isLeftToRight()) {
            content2.add(filePathLabel);
            content2.add(this.filePathField);
            content2.add(linesLabel);
            content2.add(linesCountLabel);
            content2.add(charsLabel);
            content2.add(charsCountLabel);
            content2.add(wordsLabel);
            content2.add(wordsCountLabel);
            content2.add(terminatorLabel);
            content2.add(this.terminatorCombo);
            content2.add(encodingLabel);
            content2.add(this.encodingCombo);
            content2.add(sizeLabel);
            content2.add(sizeLabel2);
            content2.add(modifiedLabel);
            content2.add(modified);
        } else {
            content2.add(this.filePathField);
            content2.add(filePathLabel);
            content2.add(linesCountLabel);
            content2.add(linesLabel);
            content2.add(charsCountLabel);
            content2.add(charsLabel);
            content2.add(wordsCountLabel);
            content2.add(wordsLabel);
            content2.add(this.terminatorCombo);
            content2.add(terminatorLabel);
            content2.add(this.encodingCombo);
            content2.add(encodingLabel);
            content2.add(sizeLabel2);
            content2.add(sizeLabel);
            content2.add(modified);
            content2.add(modifiedLabel);
        }
        UIUtil.makeSpringCompactGrid(content2, 8, 2, 0, 0, 5, 5);
        this.okButton = UIUtil.newButton(msg, "OK");
        this.okButton.setActionCommand("OKButton");
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        JButton cancelButton = UIUtil.newButton(msg, "Cancel");
        cancelButton.setActionCommand("CancelButton");
        cancelButton.addActionListener(this);
        Container buttons = this.createButtonFooter(this.okButton, cancelButton);
        contentPane.add((Component)buttons, "South");
        this.setContentPane(contentPane);
        this.setModal(true);
        this.applyComponentOrientation(o10);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void setEncoding(String encoding) {
        Charset cs2;
        String item;
        Charset cs1 = Charset.forName(encoding);
        int count = this.encodingCombo.getItemCount();
        int i10 = 0;
        while (i10 < count) {
            item = (String)this.encodingCombo.getItemAt(i10);
            cs2 = Charset.forName(item);
            if (cs1.equals(cs2)) {
                this.encodingCombo.setSelectedIndex(i10);
                return;
            }
            ++i10;
        }
        cs1 = Charset.forName("US-ASCII");
        i10 = 0;
        while (i10 < count) {
            item = (String)this.encodingCombo.getItemAt(i10);
            cs2 = Charset.forName(item);
            if (cs1.equals(cs2)) {
                this.encodingCombo.setSelectedIndex(i10);
                return;
            }
            ++i10;
        }
    }

    private void setSelectedLineTerminator(String terminator) {
        int i10 = 0;
        while (i10 < LINE_TERMINATORS.length) {
            if (LINE_TERMINATORS[i10].equals(terminator)) {
                this.terminatorCombo.setSelectedIndex(i10);
                break;
            }
            ++i10;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextFilePropertiesDialog.this.filePathField.requestFocusInWindow();
                    TextFilePropertiesDialog.this.filePathField.selectAll();
                }
            });
        }
        super.setVisible(visible);
    }

    private static class DocumentCharIterator
    implements CharacterIterator {
        private Document doc;
        private int index;
        private Segment s;

        public DocumentCharIterator(Document doc) {
            this.doc = doc;
            this.index = 0;
            this.s = new Segment();
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new InternalError("Clone not supported???");
            }
        }

        @Override
        public char current() {
            if (this.index >= this.getEndIndex()) {
                return '\uffff';
            }
            try {
                this.doc.getText(this.index, 1, this.s);
                return this.s.first();
            }
            catch (BadLocationException ble) {
                return '\uffff';
            }
        }

        @Override
        public char first() {
            this.index = this.getBeginIndex();
            return this.current();
        }

        @Override
        public int getBeginIndex() {
            return 0;
        }

        @Override
        public int getEndIndex() {
            return this.doc.getLength();
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public char last() {
            this.index = Math.max(0, this.getEndIndex() - 1);
            return this.current();
        }

        @Override
        public char next() {
            this.index = Math.min(this.index + 1, this.getEndIndex());
            return this.current();
        }

        @Override
        public char previous() {
            this.index = Math.max(this.index - 1, this.getBeginIndex());
            return this.current();
        }

        @Override
        public char setIndex(int pos) {
            if (pos < this.getBeginIndex() || pos > this.getEndIndex()) {
                throw new IllegalArgumentException("Illegal index: " + this.index);
            }
            this.index = pos;
            return this.current();
        }
    }
}

