/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class UIUtil {
    private static boolean desktopCreationAttempted;
    private static Object desktop;
    private static final Object LOCK_DESKTOP_CREATION;
    private static final Border EMPTY_5_BORDER;

    static {
        LOCK_DESKTOP_CREATION = new Object();
        EMPTY_5_BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    }

    private UIUtil() {
    }

    public static boolean browse(String uri) {
        if (uri == null) {
            return false;
        }
        try {
            return UIUtil.browse(new URI(uri));
        }
        catch (URISyntaxException e10) {
            return false;
        }
    }

    public static boolean browse(URI uri) {
        Object desktop;
        boolean success = false;
        if (uri != null && (desktop = UIUtil.getDesktop()) != null) {
            try {
                Method m10 = desktop.getClass().getDeclaredMethod("browse", URI.class);
                m10.invoke(desktop, uri);
                success = true;
            }
            catch (RuntimeException re2) {
                throw re2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    public static void fixComboOrientation(JComboBox combo) {
        ListCellRenderer r10 = combo.getRenderer();
        if (r10 instanceof Component) {
            ComponentOrientation o10 = ComponentOrientation.getOrientation(Locale.getDefault());
            ((Component)((Object)r10)).setComponentOrientation(o10);
        }
    }

    private static final SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c10 = parent.getComponent(row * cols + col);
        return layout.getConstraints(c10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getDesktop() {
        Object object = LOCK_DESKTOP_CREATION;
        synchronized (object) {
            if (!desktopCreationAttempted) {
                desktopCreationAttempted = true;
                try {
                    Class<?> desktopClazz = Class.forName("java.awt.Desktop");
                    Method m10 = desktopClazz.getDeclaredMethod("isDesktopSupported", new Class[0]);
                    boolean supported = (Boolean)m10.invoke(null, new Object[0]);
                    if (supported) {
                        m10 = desktopClazz.getDeclaredMethod("getDesktop", new Class[0]);
                        desktop = m10.invoke(null, new Object[0]);
                    }
                }
                catch (RuntimeException re2) {
                    throw re2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return desktop;
    }

    public static Border getEmpty5Border() {
        return EMPTY_5_BORDER;
    }

    public static final Color getErrorTextForeground() {
        Color defaultFG = UIManager.getColor("TextField.foreground");
        if (defaultFG.getRed() >= 160 && defaultFG.getGreen() >= 160 && defaultFG.getBlue() >= 160) {
            return new Color(255, 160, 160);
        }
        return Color.red;
    }

    public static final int getMnemonic(ResourceBundle msg, String key) {
        int mnemonic = 0;
        try {
            Object value = msg.getObject(key);
            if (value instanceof String) {
                mnemonic = ((String)value).charAt(0);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return mnemonic;
    }

    public static final JTextComponent getTextComponent(JComboBox combo) {
        return (JTextComponent)combo.getEditor().getEditorComponent();
    }

    public static final void makeSpringCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException cce) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x10 = Spring.constant(initialX);
        int c10 = 0;
        while (c10 < cols) {
            Spring width = Spring.constant(0);
            int r10 = 0;
            while (r10 < rows) {
                width = Spring.max(width, UIUtil.getConstraintsForCell(r10, c10, parent, cols).getWidth());
                ++r10;
            }
            r10 = 0;
            while (r10 < rows) {
                SpringLayout.Constraints constraints = UIUtil.getConstraintsForCell(r10, c10, parent, cols);
                constraints.setX(x10);
                constraints.setWidth(width);
                ++r10;
            }
            x10 = Spring.sum(x10, Spring.sum(width, Spring.constant(xPad)));
            ++c10;
        }
        Spring y10 = Spring.constant(initialY);
        int r11 = 0;
        while (r11 < rows) {
            Spring height = Spring.constant(0);
            int c11 = 0;
            while (c11 < cols) {
                height = Spring.max(height, UIUtil.getConstraintsForCell(r11, c11, parent, cols).getHeight());
                ++c11;
            }
            c11 = 0;
            while (c11 < cols) {
                SpringLayout.Constraints constraints = UIUtil.getConstraintsForCell(r11, c11, parent, cols);
                constraints.setY(y10);
                constraints.setHeight(height);
                ++c11;
            }
            y10 = Spring.sum(y10, Spring.sum(height, Spring.constant(yPad)));
            ++r11;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y10);
        pCons.setConstraint("East", x10);
    }

    public static final JButton newButton(ResourceBundle bundle, String key) {
        JButton b10 = new JButton(bundle.getString(key));
        b10.setMnemonic(UIUtil.getMnemonic(bundle, String.valueOf(key) + ".Mnemonic"));
        return b10;
    }

    public static final JLabel newLabel(ResourceBundle msg, String key, Component labelFor) {
        JLabel label = new JLabel(msg.getString(key));
        String mnemonicKey = String.valueOf(key) + ".Mnemonic";
        label.setDisplayedMnemonic(UIUtil.getMnemonic(msg, mnemonicKey));
        if (labelFor != null) {
            label.setLabelFor(labelFor);
        }
        return label;
    }
}

