/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import org.fife.rsta.ui.CollapsibleSectionPanel;
import org.fife.rsta.ui.GoToDialog;
import org.fife.rsta.ui.demo.StatusBar;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.FindToolBar;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.ReplaceToolBar;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;

public class RSTAUIDemoApp
extends JFrame
implements SearchListener {
    private CollapsibleSectionPanel csp;
    private RSyntaxTextArea textArea;
    private FindDialog findDialog;
    private ReplaceDialog replaceDialog;
    private FindToolBar findToolBar;
    private ReplaceToolBar replaceToolBar;
    private StatusBar statusBar;

    public RSTAUIDemoApp() {
        this.initSearchDialogs();
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        this.csp = new CollapsibleSectionPanel();
        contentPane.add(this.csp);
        this.setJMenuBar(this.createMenuBar());
        this.textArea = new RSyntaxTextArea(25, 80);
        this.textArea.setSyntaxEditingStyle("text/java");
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setMarkOccurrences(true);
        RTextScrollPane sp2 = new RTextScrollPane(this.textArea);
        this.csp.add(sp2);
        ErrorStrip errorStrip = new ErrorStrip(this.textArea);
        contentPane.add((Component)errorStrip, "After");
        this.statusBar = new StatusBar();
        contentPane.add((Component)this.statusBar, "South");
        this.setTitle("RSTAUI Demo Application");
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void addItem(Action a10, ButtonGroup bg2, JMenu menu) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(a10);
        bg2.add(item);
        menu.add(item);
    }

    private JMenuBar createMenuBar() {
        JMenuBar mb2 = new JMenuBar();
        JMenu menu = new JMenu("Search");
        menu.add(new JMenuItem(new ShowFindDialogAction()));
        menu.add(new JMenuItem(new ShowReplaceDialogAction()));
        menu.add(new JMenuItem(new GoToLineAction()));
        menu.addSeparator();
        int ctrl = this.getToolkit().getMenuShortcutKeyMask();
        int shift = 1;
        KeyStroke ks2 = KeyStroke.getKeyStroke(70, ctrl | shift);
        Action a10 = this.csp.addBottomComponent(ks2, this.findToolBar);
        a10.putValue("Name", "Show Find Search Bar");
        menu.add(new JMenuItem(a10));
        ks2 = KeyStroke.getKeyStroke(72, ctrl | shift);
        a10 = this.csp.addBottomComponent(ks2, this.replaceToolBar);
        a10.putValue("Name", "Show Replace Search Bar");
        menu.add(new JMenuItem(a10));
        mb2.add(menu);
        menu = new JMenu("LookAndFeel");
        ButtonGroup bg2 = new ButtonGroup();
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        int i10 = 0;
        while (i10 < infos.length) {
            this.addItem(new LookAndFeelAction(infos[i10]), bg2, menu);
            ++i10;
        }
        mb2.add(menu);
        return mb2;
    }

    @Override
    public String getSelectedText() {
        return this.textArea.getSelectedText();
    }

    public void initSearchDialogs() {
        this.findDialog = new FindDialog((Frame)this, (SearchListener)this);
        this.replaceDialog = new ReplaceDialog((Frame)this, (SearchListener)this);
        SearchContext context = this.findDialog.getSearchContext();
        this.replaceDialog.setSearchContext(context);
        this.findToolBar = new FindToolBar(this);
        this.findToolBar.setSearchContext(context);
        this.replaceToolBar = new ReplaceToolBar(this);
        this.replaceToolBar.setSearchContext(context);
    }

    @Override
    public void searchEvent(SearchEvent e10) {
        SearchEvent.Type type = e10.getType();
        SearchContext context = e10.getSearchContext();
        SearchResult result = null;
        switch (type) {
            default: {
                result = SearchEngine.markAll(this.textArea, context);
                break;
            }
            case FIND: {
                result = SearchEngine.find(this.textArea, context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback(this.textArea);
                break;
            }
            case REPLACE: {
                result = SearchEngine.replace(this.textArea, context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback(this.textArea);
                break;
            }
            case REPLACE_ALL: {
                result = SearchEngine.replaceAll(this.textArea, context);
                JOptionPane.showMessageDialog(null, String.valueOf(result.getCount()) + " occurrences replaced.");
            }
        }
        String text = null;
        text = result.wasFound() ? "Text found; occurrences marked: " + result.getMarkedCount() : (type == SearchEvent.Type.MARK_ALL ? (result.getMarkedCount() > 0 ? "Occurrences marked: " + result.getMarkedCount() : "") : "Text not found");
        this.statusBar.setLabel(text);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e10) {
                    e10.printStackTrace();
                }
                new RSTAUIDemoApp().setVisible(true);
            }
        });
    }

    private class GoToLineAction
    extends AbstractAction {
        public GoToLineAction() {
            super("Go To Line...");
            int c10 = RSTAUIDemoApp.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, c10));
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (RSTAUIDemoApp.this.findDialog.isVisible()) {
                RSTAUIDemoApp.this.findDialog.setVisible(false);
            }
            if (RSTAUIDemoApp.this.replaceDialog.isVisible()) {
                RSTAUIDemoApp.this.replaceDialog.setVisible(false);
            }
            GoToDialog dialog = new GoToDialog(RSTAUIDemoApp.this);
            dialog.setMaxLineNumberAllowed(RSTAUIDemoApp.this.textArea.getLineCount());
            dialog.setVisible(true);
            int line = dialog.getLineNumber();
            if (line > 0) {
                try {
                    RSTAUIDemoApp.this.textArea.setCaretPosition(RSTAUIDemoApp.this.textArea.getLineStartOffset(line - 1));
                }
                catch (BadLocationException ble) {
                    UIManager.getLookAndFeel().provideErrorFeedback(RSTAUIDemoApp.this.textArea);
                    ble.printStackTrace();
                }
            }
        }
    }

    private class LookAndFeelAction
    extends AbstractAction {
        private UIManager.LookAndFeelInfo info;

        public LookAndFeelAction(UIManager.LookAndFeelInfo info) {
            this.putValue("Name", info.getName());
            this.info = info;
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            try {
                UIManager.setLookAndFeel(this.info.getClassName());
                SwingUtilities.updateComponentTreeUI(RSTAUIDemoApp.this);
                if (RSTAUIDemoApp.this.findDialog != null) {
                    RSTAUIDemoApp.this.findDialog.updateUI();
                    RSTAUIDemoApp.this.replaceDialog.updateUI();
                }
                RSTAUIDemoApp.this.pack();
            }
            catch (RuntimeException re2) {
                throw re2;
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
    }

    private class ShowFindDialogAction
    extends AbstractAction {
        public ShowFindDialogAction() {
            super("Find...");
            int c10 = RSTAUIDemoApp.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, c10));
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (RSTAUIDemoApp.this.replaceDialog.isVisible()) {
                RSTAUIDemoApp.this.replaceDialog.setVisible(false);
            }
            RSTAUIDemoApp.this.findDialog.setVisible(true);
        }
    }

    private class ShowReplaceDialogAction
    extends AbstractAction {
        private static final long serialVersionUID = 3876100492651364380L;

        public ShowReplaceDialogAction() {
            super("Replace...");
            int c10 = RSTAUIDemoApp.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, c10));
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (RSTAUIDemoApp.this.findDialog.isVisible()) {
                RSTAUIDemoApp.this.findDialog.setVisible(false);
            }
            RSTAUIDemoApp.this.replaceDialog.setVisible(true);
        }
    }
}

