/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ui.AssistanceIconPanel;
import org.fife.rsta.ui.UIUtil;
import org.fife.rsta.ui.search.FindReplaceButtonsEnableResult;
import org.fife.rsta.ui.search.SearchComboBox;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.rsta.ui.search.SearchUtil;
import org.fife.ui.rtextarea.SearchContext;

public class FindToolBar
extends JPanel {
    private SearchContext context;
    protected ToolBarListener listener;
    protected FindFieldListener findFieldListener;
    protected SearchComboBox findCombo;
    protected SearchComboBox replaceCombo;
    protected JButton findButton;
    protected JButton findPrevButton;
    protected JCheckBox matchCaseCheckBox;
    protected JCheckBox wholeWordCheckBox;
    protected JCheckBox regexCheckBox;
    protected JCheckBox markAllCheckBox;
    private JLabel infoLabel;
    private Timer markAllTimer;
    private boolean settingFindTextFromEvent;
    protected static final ResourceBundle searchMsg = ResourceBundle.getBundle("org.fife.rsta.ui.search.Search");
    protected static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.rsta.ui.search.SearchToolBar");

    public FindToolBar(SearchListener listener) {
        this.setFocusCycleRoot(true);
        this.installKeyboardShortcuts();
        this.markAllTimer = new Timer(300, new MarkAllEventNotifier());
        this.markAllTimer.setRepeats(false);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.addSearchListener(listener);
        this.listener = new ToolBarListener();
        this.setSearchContext(new SearchContext());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.add(Box.createHorizontalStrut(5));
        this.add(this.createFieldPanel());
        Box rest = new Box(2);
        this.add((Component)rest, "After");
        rest.add(Box.createHorizontalStrut(5));
        rest.add(this.createButtonPanel());
        rest.add(Box.createHorizontalStrut(15));
        this.infoLabel = new JLabel();
        rest.add(this.infoLabel);
        rest.add(Box.createHorizontalGlue());
        this.applyComponentOrientation(orientation);
    }

    public void addSearchListener(SearchListener l10) {
        this.listenerList.add(SearchListener.class, l10);
    }

    protected Container createButtonPanel() {
        Box panel = new Box(2);
        this.createFindButtons();
        JPanel filler = new JPanel(new BorderLayout());
        filler.setBorder(BorderFactory.createEmptyBorder());
        filler.add(this.findButton);
        panel.add(filler);
        panel.add(Box.createHorizontalStrut(5));
        this.matchCaseCheckBox = this.createCB("MatchCase");
        panel.add(this.matchCaseCheckBox);
        this.regexCheckBox = this.createCB("RegEx");
        panel.add(this.regexCheckBox);
        this.wholeWordCheckBox = this.createCB("WholeWord");
        panel.add(this.wholeWordCheckBox);
        this.markAllCheckBox = this.createCB("MarkAll");
        panel.add(this.markAllCheckBox);
        return panel;
    }

    protected JCheckBox createCB(String key) {
        JCheckBox cb2 = new JCheckBox(searchMsg.getString(key));
        cb2.addActionListener(this.listener);
        cb2.addMouseListener(this.listener);
        return cb2;
    }

    protected Container createContentAssistablePanel(JComponent comp) {
        JPanel temp = new JPanel(new BorderLayout());
        temp.add(comp);
        AssistanceIconPanel aip2 = new AssistanceIconPanel(comp);
        temp.add((Component)aip2, "Before");
        return temp;
    }

    protected Container createFieldPanel() {
        this.findFieldListener = new FindFieldListener();
        JPanel temp = new JPanel(new BorderLayout());
        this.findCombo = new SearchComboBox(this, false);
        JTextComponent findField = UIUtil.getTextComponent(this.findCombo);
        this.findFieldListener.install(findField);
        temp.add(this.createContentAssistablePanel(this.findCombo));
        return temp;
    }

    protected void createFindButtons() {
        this.findPrevButton = new JButton(msg.getString("FindPrev"));
        this.makeEnterActivateButton(this.findPrevButton);
        this.findPrevButton.setActionCommand("FindPrevious");
        this.findPrevButton.addActionListener(this.listener);
        this.findPrevButton.setEnabled(false);
        this.findButton = new JButton(searchMsg.getString("Find")){

            @Override
            public Dimension getPreferredSize() {
                return FindToolBar.this.findPrevButton.getPreferredSize();
            }
        };
        this.makeEnterActivateButton(this.findButton);
        this.findButton.setToolTipText(msg.getString("Find.ToolTip"));
        this.findButton.setActionCommand("FindNext");
        this.findButton.addActionListener(this.listener);
        this.findButton.setEnabled(false);
    }

    protected void doMarkAll(boolean delay) {
        if (this.context.getMarkAll() && !this.settingFindTextFromEvent) {
            if (delay) {
                this.markAllTimer.restart();
            } else {
                this.fireMarkAllEvent();
            }
        }
    }

    void doSearch(boolean forward) {
        if (forward) {
            this.findButton.doClick(0);
        } else {
            this.findPrevButton.doClick(0);
        }
    }

    private void fireMarkAllEvent() {
        SearchEvent se2 = new SearchEvent(this, SearchEvent.Type.MARK_ALL, this.context);
        this.fireSearchEvent(se2);
    }

    protected void fireSearchEvent(SearchEvent e10) {
        SearchListener[] listeners = (SearchListener[])this.listenerList.getListeners(SearchListener.class);
        int count = listeners == null ? 0 : listeners.length;
        int i10 = count - 1;
        while (i10 >= 0) {
            listeners[i10].searchEvent(e10);
            --i10;
        }
    }

    protected String getFindText() {
        return UIUtil.getTextComponent(this.findCombo).getText();
    }

    public int getMarkAllDelay() {
        return this.markAllTimer.getInitialDelay();
    }

    protected String getReplaceText() {
        if (this.replaceCombo == null) {
            return null;
        }
        return UIUtil.getTextComponent(this.replaceCombo).getText();
    }

    public SearchContext getSearchContext() {
        return this.context;
    }

    protected void handleRegExCheckBoxClicked() {
        this.handleToggleButtons();
        boolean b10 = this.regexCheckBox.isSelected();
        this.findCombo.setAutoCompleteEnabled(b10);
    }

    protected void handleSearchAction(ActionEvent e10) {
        SearchEvent.Type type = null;
        boolean forward = true;
        String action = e10.getActionCommand();
        int allowedModifiers = 195;
        if ("FindNext".equals(action)) {
            type = SearchEvent.Type.FIND;
            int mods = e10.getModifiers();
            forward = (mods & allowedModifiers) == 0;
            JTextComponent tc2 = UIUtil.getTextComponent(this.findCombo);
            this.findCombo.addItem(tc2.getText());
        } else if ("FindPrevious".equals(action)) {
            type = SearchEvent.Type.FIND;
            forward = false;
            JTextComponent tc3 = UIUtil.getTextComponent(this.findCombo);
            this.findCombo.addItem(tc3.getText());
        } else if ("Replace".equals(action)) {
            type = SearchEvent.Type.REPLACE;
            int mods = e10.getModifiers();
            forward = (mods & allowedModifiers) == 0;
            JTextComponent tc4 = UIUtil.getTextComponent(this.findCombo);
            this.findCombo.addItem(tc4.getText());
            tc4 = UIUtil.getTextComponent(this.replaceCombo);
            this.replaceCombo.addItem(tc4.getText());
        } else if ("ReplaceAll".equals(action)) {
            type = SearchEvent.Type.REPLACE_ALL;
            JTextComponent tc5 = UIUtil.getTextComponent(this.findCombo);
            this.findCombo.addItem(tc5.getText());
            tc5 = UIUtil.getTextComponent(this.replaceCombo);
            this.replaceCombo.addItem(tc5.getText());
        }
        this.context.setSearchFor(this.getFindText());
        if (this.replaceCombo != null) {
            this.context.setReplaceWith(this.replaceCombo.getSelectedString());
        }
        this.context.setSearchForward(forward);
        SearchEvent se2 = new SearchEvent(this, type, this.context);
        this.fireSearchEvent(se2);
        this.handleToggleButtons();
    }

    protected FindReplaceButtonsEnableResult handleToggleButtons() {
        FindReplaceButtonsEnableResult result = new FindReplaceButtonsEnableResult(true, null);
        String text = this.getFindText();
        if (text.length() == 0) {
            result = new FindReplaceButtonsEnableResult(false, null);
        } else if (this.regexCheckBox.isSelected()) {
            try {
                Pattern.compile(text);
            }
            catch (PatternSyntaxException pse) {
                result = new FindReplaceButtonsEnableResult(false, pse.getMessage());
            }
        }
        boolean enable = result.getEnable();
        this.findButton.setEnabled(enable);
        this.findPrevButton.setEnabled(enable);
        JTextComponent tc2 = UIUtil.getTextComponent(this.findCombo);
        tc2.setForeground(enable ? UIManager.getColor("TextField.foreground") : UIUtil.getErrorTextForeground());
        String tooltip = SearchUtil.getToolTip(result);
        tc2.setToolTipText(tooltip);
        return result;
    }

    protected void initUIFromContext() {
        if (this.findCombo == null) {
            return;
        }
        this.setFindText(this.context.getSearchFor());
        if (this.replaceCombo != null) {
            this.setReplaceText(this.context.getReplaceWith());
        }
        this.matchCaseCheckBox.setSelected(this.context.getMatchCase());
        this.wholeWordCheckBox.setSelected(this.context.getWholeWord());
        this.regexCheckBox.setSelected(this.context.isRegularExpression());
        this.markAllCheckBox.setSelected(this.context.getMarkAll());
    }

    private void installKeyboardShortcuts() {
        InputMap im2 = this.getInputMap(1);
        ActionMap am10 = this.getActionMap();
        KeyStroke ks2 = KeyStroke.getKeyStroke("ENTER");
        im2.put(ks2, "searchForward");
        am10.put("searchForward", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                FindToolBar.this.doSearch(true);
            }
        });
        int shift = 1;
        int ctrl = 2;
        if (System.getProperty("os.name").toLowerCase().contains("os x")) {
            ctrl = 4;
        }
        ks2 = KeyStroke.getKeyStroke(10, shift);
        im2.put(ks2, "searchBackward");
        ks2 = KeyStroke.getKeyStroke(10, ctrl);
        im2.put(ks2, "searchBackward");
        am10.put("searchForward", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                FindToolBar.this.doSearch(false);
            }
        });
    }

    protected void makeEnterActivateButton(JButton button) {
        InputMap im2 = button.getInputMap();
        im2.put(KeyStroke.getKeyStroke("ENTER"), "pressed");
        im2.put(KeyStroke.getKeyStroke("released ENTER"), "released");
        im2.put(KeyStroke.getKeyStroke(10, 1, false), "pressed");
        im2.put(KeyStroke.getKeyStroke(10, 1, true), "released");
    }

    public void removeSearchListener(SearchListener l10) {
        this.listenerList.remove(SearchListener.class, l10);
    }

    @Override
    public boolean requestFocusInWindow() {
        JTextComponent findField = UIUtil.getTextComponent(this.findCombo);
        findField.selectAll();
        return findField.requestFocusInWindow();
    }

    void searchComboUpdateUICallback(SearchComboBox combo) {
        this.findFieldListener.install(UIUtil.getTextComponent(combo));
    }

    protected void setFindText(String text) {
        UIUtil.getTextComponent(this.findCombo).setText(text);
    }

    public void setMarkAllDelay(int millis) {
        this.markAllTimer.setInitialDelay(millis);
    }

    protected void setReplaceText(String text) {
        if (this.replaceCombo != null) {
            UIUtil.getTextComponent(this.replaceCombo).setText(text);
        }
    }

    public void setSearchContext(SearchContext context) {
        if (this.context != null) {
            this.context.removePropertyChangeListener(this.listener);
        }
        this.context = context;
        this.context.addPropertyChangeListener(this.listener);
        this.initUIFromContext();
    }

    protected class FindFieldListener
    extends KeyAdapter
    implements DocumentListener,
    FocusListener {
        protected boolean selectAll;

        protected FindFieldListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e10) {
        }

        @Override
        public void focusGained(FocusEvent e10) {
            JTextField field = (JTextField)e10.getComponent();
            if (this.selectAll) {
                field.selectAll();
            }
            this.selectAll = true;
        }

        @Override
        public void focusLost(FocusEvent e10) {
        }

        protected void handleDocumentEvent(DocumentEvent e10) {
            FindToolBar.this.handleToggleButtons();
            if (!FindToolBar.this.settingFindTextFromEvent) {
                JTextComponent findField = UIUtil.getTextComponent(FindToolBar.this.findCombo);
                if (e10.getDocument() == findField.getDocument()) {
                    FindToolBar.this.context.setSearchFor(findField.getText());
                    if (FindToolBar.this.context.getMarkAll()) {
                        FindToolBar.this.doMarkAll(true);
                    }
                } else {
                    JTextComponent replaceField = UIUtil.getTextComponent(FindToolBar.this.replaceCombo);
                    FindToolBar.this.context.setReplaceWith(replaceField.getText());
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e10) {
            this.handleDocumentEvent(e10);
        }

        public void install(JTextComponent field) {
            field.getDocument().addDocumentListener(this);
            field.addKeyListener(this);
            field.addFocusListener(this);
        }

        @Override
        public void keyTyped(KeyEvent e10) {
            if (e10.getKeyChar() == '\n') {
                int ctrlShift;
                int mod = e10.getModifiers();
                boolean forward = (mod & (ctrlShift = 3)) == 0;
                FindToolBar.this.doSearch(forward);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e10) {
            this.handleDocumentEvent(e10);
        }
    }

    private class MarkAllEventNotifier
    implements ActionListener {
        private MarkAllEventNotifier() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            FindToolBar.this.fireMarkAllEvent();
        }
    }

    private class ToolBarListener
    extends MouseAdapter
    implements ActionListener,
    PropertyChangeListener {
        private ToolBarListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            Object source = e10.getSource();
            if (source == FindToolBar.this.matchCaseCheckBox) {
                FindToolBar.this.context.setMatchCase(FindToolBar.this.matchCaseCheckBox.isSelected());
                if (FindToolBar.this.markAllCheckBox.isSelected()) {
                    FindToolBar.this.doMarkAll(false);
                }
            } else if (source == FindToolBar.this.wholeWordCheckBox) {
                FindToolBar.this.context.setWholeWord(FindToolBar.this.wholeWordCheckBox.isSelected());
                if (FindToolBar.this.markAllCheckBox.isSelected()) {
                    FindToolBar.this.doMarkAll(false);
                }
            } else if (source == FindToolBar.this.regexCheckBox) {
                FindToolBar.this.context.setRegularExpression(FindToolBar.this.regexCheckBox.isSelected());
                if (FindToolBar.this.markAllCheckBox.isSelected()) {
                    FindToolBar.this.doMarkAll(false);
                }
            } else if (source == FindToolBar.this.markAllCheckBox) {
                FindToolBar.this.context.setMarkAll(FindToolBar.this.markAllCheckBox.isSelected());
                FindToolBar.this.fireMarkAllEvent();
            } else {
                FindToolBar.this.handleSearchAction(e10);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e10) {
            if (e10.getSource() instanceof JCheckBox) {
                FindToolBar.this.findFieldListener.selectAll = false;
                FindToolBar.this.findCombo.requestFocusInWindow();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e10) {
            String oldValue;
            String newValue;
            String prop = e10.getPropertyName();
            if ("Search.MatchCase".equals(prop)) {
                boolean newValue2 = (Boolean)e10.getNewValue();
                FindToolBar.this.matchCaseCheckBox.setSelected(newValue2);
            } else if ("Search.MatchWholeWord".equals(prop)) {
                boolean newValue3 = (Boolean)e10.getNewValue();
                FindToolBar.this.wholeWordCheckBox.setSelected(newValue3);
            } else if ("Search.UseRegex".equals(prop)) {
                boolean newValue4 = (Boolean)e10.getNewValue();
                FindToolBar.this.regexCheckBox.setSelected(newValue4);
                FindToolBar.this.handleRegExCheckBoxClicked();
            } else if ("Search.MarkAll".equals(prop)) {
                boolean newValue5 = (Boolean)e10.getNewValue();
                FindToolBar.this.markAllCheckBox.setSelected(newValue5);
            } else if ("Search.searchFor".equals(prop)) {
                String oldValue2;
                String newValue6 = (String)e10.getNewValue();
                if (!newValue6.equals(oldValue2 = FindToolBar.this.getFindText())) {
                    FindToolBar.this.settingFindTextFromEvent = true;
                    FindToolBar.this.setFindText(newValue6);
                    FindToolBar.this.settingFindTextFromEvent = false;
                }
            } else if ("Search.replaceWith".equals(prop) && !(newValue = (String)e10.getNewValue()).equals(oldValue = FindToolBar.this.getReplaceText())) {
                FindToolBar.this.settingFindTextFromEvent = true;
                FindToolBar.this.setReplaceText(newValue);
                FindToolBar.this.settingFindTextFromEvent = false;
            }
        }
    }
}

