/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui.search;

import javax.swing.ComboBoxModel;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ui.ContentAssistable;
import org.fife.rsta.ui.MaxWidthComboBox;
import org.fife.rsta.ui.RComboBoxModel;
import org.fife.rsta.ui.search.AbstractSearchDialog;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;

public class RegexAwareComboBox
extends MaxWidthComboBox
implements ContentAssistable {
    private boolean enabled;
    private boolean replace;
    private AutoCompletion ac;
    private RegexAwareProvider provider;

    public RegexAwareComboBox(boolean replace) {
        this(new RComboBoxModel(), 200, replace);
    }

    public RegexAwareComboBox(ComboBoxModel model, int maxWidth, boolean replace) {
        super(model, maxWidth);
        this.setEditable(true);
        this.replace = replace;
    }

    private void addFindFieldCompletions(RegexAwareProvider p10) {
        p10.addCompletion(new RegexCompletion(p10, "\\\\", "\\\\", "\\\\ - Backslash"));
        p10.addCompletion(new RegexCompletion(p10, "\\t", "\\t", "\\t - Tab"));
        p10.addCompletion(new RegexCompletion(p10, "\\n", "\\n", "\\n - Newline"));
        p10.addCompletion(new RegexCompletion(p10, "[", "[", "[abc] - Any of a, b, or c"));
        p10.addCompletion(new RegexCompletion(p10, "[^", "[^", "[^abc] - Any character except a, b, or c"));
        p10.addCompletion(new RegexCompletion(p10, ".", ".", ". - Any character"));
        p10.addCompletion(new RegexCompletion(p10, "\\d", "\\d", "\\d - A digit"));
        p10.addCompletion(new RegexCompletion(p10, "\\D", "\\D", "\\D - Not a digit"));
        p10.addCompletion(new RegexCompletion(p10, "\\s", "\\s", "\\s - A whitespace"));
        p10.addCompletion(new RegexCompletion(p10, "\\S", "\\S", "\\S - Not a whitespace"));
        p10.addCompletion(new RegexCompletion(p10, "\\w", "\\w", "\\w - An alphanumeric (word character)"));
        p10.addCompletion(new RegexCompletion(p10, "\\W", "\\W", "\\W - Not an alphanumeric"));
        p10.addCompletion(new RegexCompletion(p10, "^", "^", "^ - Line Start"));
        p10.addCompletion(new RegexCompletion(p10, "$", "$", "$ - Line End"));
        p10.addCompletion(new RegexCompletion(p10, "\\b", "\b", "\\b - Word beginning or end"));
        p10.addCompletion(new RegexCompletion(p10, "\\B", "\\B", "\\B - Not a word beginning or end"));
        p10.addCompletion(new RegexCompletion(p10, "?", "?", "X? - Greedy match, 0 or 1 times"));
        p10.addCompletion(new RegexCompletion(p10, "*", "*", "X* - Greedy match, 0 or more times"));
        p10.addCompletion(new RegexCompletion(p10, "+", "+", "X+ - Greedy match, 1 or more times"));
        p10.addCompletion(new RegexCompletion(p10, "{", "{", "X{n} - Greedy match, exactly n times"));
        p10.addCompletion(new RegexCompletion(p10, "{", "{", "X{n,} - Greedy match, at least n times"));
        p10.addCompletion(new RegexCompletion(p10, "{", "{", "X{n,m} - Greedy match, at least n but no more than m times"));
        p10.addCompletion(new RegexCompletion(p10, "??", "??", "X?? - Lazy match, 0 or 1 times"));
        p10.addCompletion(new RegexCompletion(p10, "*?", "*?", "X*? - Lazy match, 0 or more times"));
        p10.addCompletion(new RegexCompletion(p10, "+?", "+?", "X+? - Lazy match, 1 or more times"));
        p10.addCompletion(new RegexCompletion(p10, "?+", "?+", "X?+ - Possessive match, 0 or 1 times"));
        p10.addCompletion(new RegexCompletion(p10, "*+", "*+", "X*+ - Possessive match, 0 or more times"));
        p10.addCompletion(new RegexCompletion(p10, "++", "++", "X++ - Possessive match, 0 or more times"));
        p10.addCompletion(new RegexCompletion(p10, "\\i", "\\i", "\\i - Match of the capturing group i"));
        p10.addCompletion(new RegexCompletion(p10, "(", "(", "(Expr) - Mark Expr as capturing group"));
        p10.addCompletion(new RegexCompletion(p10, "(?:", "(?:", "(?:Expr) - Non-capturing group"));
    }

    private void addReplaceFieldCompletions(RegexAwareProvider p10) {
        p10.addCompletion(new RegexCompletion(p10, "$", "$", "$i - Match of the capturing group i"));
        p10.addCompletion(new RegexCompletion(p10, "\\", "\\", "\\ - Quote next character"));
        p10.addCompletion(new RegexCompletion(p10, "\\t", "\\t", "\\t - Tab"));
        p10.addCompletion(new RegexCompletion(p10, "\\n", "\\n", "\\n - Newline"));
    }

    private AutoCompletion getAutoCompletion() {
        if (this.ac == null) {
            this.ac = new AutoCompletion(this.getCompletionProvider());
        }
        return this.ac;
    }

    protected synchronized CompletionProvider getCompletionProvider() {
        if (this.provider == null) {
            this.provider = new RegexAwareProvider();
            if (this.replace) {
                this.addReplaceFieldCompletions(this.provider);
            } else {
                this.addFindFieldCompletions(this.provider);
            }
        }
        return this.provider;
    }

    public boolean hideAutoCompletePopups() {
        return this.ac == null ? false : this.ac.hideChildWindows();
    }

    public boolean isAutoCompleteEnabled() {
        return this.enabled;
    }

    public void setAutoCompleteEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (enabled) {
                AutoCompletion ac10 = this.getAutoCompletion();
                JTextComponent tc2 = (JTextComponent)this.getEditor().getEditorComponent();
                ac10.install(tc2);
            } else {
                this.ac.uninstall();
            }
            String prop = "AssistanceImage";
            if (enabled) {
                this.firePropertyChange(prop, null, AbstractSearchDialog.getContentAssistImage());
            } else {
                this.firePropertyChange(prop, null, null);
            }
        }
    }

    private static class RegexAwareProvider
    extends DefaultCompletionProvider {
        private RegexAwareProvider() {
        }

        @Override
        protected boolean isValidChar(char ch2) {
            switch (ch2) {
                case '$': 
                case '(': 
                case '*': 
                case '+': 
                case '.': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': {
                    return true;
                }
            }
            return false;
        }
    }

    private static class RegexCompletion
    extends BasicCompletion {
        private String inputText;

        public RegexCompletion(CompletionProvider provider, String inputText, String replacementText, String shortDesc) {
            super(provider, replacementText, shortDesc);
            this.inputText = inputText;
        }

        @Override
        public String getInputText() {
            return this.inputText;
        }

        @Override
        public String toString() {
            return this.getShortDescription();
        }
    }
}

