/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.fife.rsta.ui.AssistanceIconPanel;
import org.fife.rsta.ui.UIUtil;
import org.fife.rsta.ui.search.AbstractFindReplaceDialog;
import org.fife.rsta.ui.search.FindReplaceButtonsEnableResult;
import org.fife.rsta.ui.search.SearchComboBox;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.rtextarea.SearchContext;

public class ReplaceDialog
extends AbstractFindReplaceDialog {
    private static final long serialVersionUID = 1L;
    private JButton replaceButton;
    private JButton replaceAllButton;
    private JLabel replaceFieldLabel;
    private SearchComboBox replaceWithCombo;
    private String lastSearchString;
    private String lastReplaceString;
    protected SearchListener searchListener;
    Dialog owner;

    public ReplaceDialog(Dialog owner, SearchListener listener) {
        super(owner);
        this.owner = owner;
        this.init(listener);
    }

    public ReplaceDialog(Frame owner, SearchListener listener) {
        super(owner);
        this.init(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e10) {
        String command = e10.getActionCommand();
        if (SearchEvent.Type.REPLACE.name().equals(command) || SearchEvent.Type.REPLACE_ALL.name().equals(command)) {
            this.context.setSearchFor(this.getSearchString());
            this.context.setReplaceWith(this.replaceWithCombo.getSelectedString());
            JTextComponent tc2 = UIUtil.getTextComponent(this.findTextCombo);
            this.findTextCombo.addItem(tc2.getText());
            tc2 = UIUtil.getTextComponent(this.replaceWithCombo);
            String replaceText = tc2.getText();
            if (replaceText.length() != 0) {
                this.replaceWithCombo.addItem(replaceText);
            }
            this.fireSearchEvent(e10);
        } else {
            super.actionPerformed(e10);
            if (SearchEvent.Type.FIND.name().equals(command)) {
                this.handleToggleButtons();
            }
        }
    }

    @Override
    protected void escapePressed() {
        if (this.replaceWithCombo.hideAutoCompletePopups()) {
            return;
        }
        super.escapePressed();
    }

    public final String getReplaceButtonText() {
        return this.replaceButton.getText();
    }

    public final String getReplaceAllButtonText() {
        return this.replaceAllButton.getText();
    }

    public String getReplaceString() {
        String text = this.replaceWithCombo.getSelectedString();
        if (text == null) {
            text = "";
        }
        return text;
    }

    public final String getReplaceWithLabelText() {
        return this.replaceFieldLabel.getText();
    }

    @Override
    protected void handleRegExCheckBoxClicked() {
        super.handleRegExCheckBoxClicked();
        boolean b10 = this.regexCheckBox.isSelected();
        this.replaceWithCombo.setAutoCompleteEnabled(b10);
    }

    @Override
    protected void handleSearchContextPropertyChanged(PropertyChangeEvent e10) {
        String prop = e10.getPropertyName();
        if ("Search.replaceWith".equals(prop)) {
            String oldValue;
            String newValue = (String)e10.getNewValue();
            if (newValue == null) {
                newValue = "";
            }
            if (!newValue.equals(oldValue = this.getReplaceString())) {
                this.setReplaceString(newValue);
            }
        } else {
            super.handleSearchContextPropertyChanged(e10);
        }
    }

    @Override
    protected FindReplaceButtonsEnableResult handleToggleButtons() {
        FindReplaceButtonsEnableResult er2 = super.handleToggleButtons();
        boolean shouldReplace = er2.getEnable();
        this.replaceAllButton.setEnabled(shouldReplace);
        if (shouldReplace) {
            String text = this.searchListener.getSelectedText();
            shouldReplace = this.matchesSearchFor(text);
        }
        this.replaceButton.setEnabled(shouldReplace);
        return er2;
    }

    private void init(SearchListener listener) {
        this.searchListener = listener;
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        JPanel searchPanel = new JPanel(new MigLayout("insets  0 0 0 0", "[]0[]0[]0[]", "[]5[]"));
        JPanel s12 = new JPanel(new MigLayout("insets  0 0 0 0", "[]5[]0[]0[]", "[]0[]"));
        JPanel s22 = new JPanel(new MigLayout("insets  0 0 0 0", "[]5[]0[]0[]", "[]0[]"));
        searchPanel.add((Component)s12, "wrap");
        searchPanel.add((Component)s22, "wrap");
        ReplaceFocusAdapter replaceFocusAdapter = new ReplaceFocusAdapter();
        ReplaceKeyListener replaceKeyListener = new ReplaceKeyListener();
        ReplaceDocumentListener replaceDocumentListener = new ReplaceDocumentListener();
        JTextComponent textField = UIUtil.getTextComponent(this.findTextCombo);
        textField.addFocusListener(replaceFocusAdapter);
        textField.addKeyListener(replaceKeyListener);
        textField.getDocument().addDocumentListener(replaceDocumentListener);
        this.replaceWithCombo = new SearchComboBox(null, true);
        textField = UIUtil.getTextComponent(this.replaceWithCombo);
        textField.addFocusListener(replaceFocusAdapter);
        textField.addKeyListener(replaceKeyListener);
        textField.getDocument().addDocumentListener(replaceDocumentListener);
        this.replaceFieldLabel = UIUtil.newLabel(this.getBundle(), "ReplaceWith", this.replaceWithCombo);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add(this.findTextCombo);
        AssistanceIconPanel aip2 = new AssistanceIconPanel(this.findTextCombo);
        temp.add((Component)aip2, "Before");
        JPanel temp2 = new JPanel(new BorderLayout());
        temp2.add(this.replaceWithCombo);
        AssistanceIconPanel aip22 = new AssistanceIconPanel(this.replaceWithCombo);
        temp2.add((Component)aip22, "Before");
        s12.add((Component)new JLabel("\u67e5\u627e "), "width 50::");
        s12.add((Component)this.findTextCombo, "width 200::");
        s22.add((Component)new JLabel("\u66ff\u6362\u4e3a"), "width 50::");
        s22.add((Component)this.replaceWithCombo, "width 200::");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        temp = new JPanel(new BorderLayout());
        bottomPanel.setBorder(UIUtil.getEmpty5Border());
        temp.add((Component)this.searchConditionsPanel, "Before");
        temp.add(this.dirPanel);
        bottomPanel.add((Component)temp, "Before");
        JPanel leftPanel = new JPanel(new MigLayout("insets  0 0 0 0", "", "[]5[]"));
        leftPanel.add((Component)searchPanel, "wrap");
        leftPanel.add(bottomPanel);
        JPanel buttonPanel = new JPanel(new MigLayout("insets  0 0 0 0", "", "[]0[]0[]0[]0[]0[]"));
        ResourceBundle msg = this.getBundle();
        this.replaceButton = UIUtil.newButton(msg, "Replace");
        this.replaceButton.setActionCommand(SearchEvent.Type.REPLACE.name());
        this.replaceButton.addActionListener(this);
        this.replaceButton.setEnabled(false);
        this.replaceButton.setIcon(null);
        this.replaceButton.setToolTipText(null);
        this.replaceAllButton = UIUtil.newButton(msg, "ReplaceAll");
        this.replaceAllButton.setActionCommand(SearchEvent.Type.REPLACE_ALL.name());
        this.replaceAllButton.addActionListener(this);
        this.replaceAllButton.setEnabled(false);
        this.replaceAllButton.setIcon(null);
        this.replaceAllButton.setToolTipText(null);
        buttonPanel.add((Component)this.findNextButton, "wrap");
        buttonPanel.add((Component)this.replaceButton, "wrap");
        buttonPanel.add((Component)this.replaceAllButton, "wrap");
        buttonPanel.add((Component)this.cancelButton, "wrap");
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)buttonPanel, "North");
        JPanel contentPane = new JPanel(new MigLayout("insets 5 10 5 10", "[][]", "[][]"));
        contentPane.add(leftPanel);
        contentPane.add(rightPanel);
        this.setContentPane(contentPane);
        this.getRootPane().setDefaultButton(this.findNextButton);
        this.setTitle("\u67e5\u627e/\u66ff\u6362");
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setSearchContext(new SearchContext());
        this.addSearchListener(listener);
        this.applyComponentOrientation(orientation);
    }

    public final void setReplaceButtonText(String text) {
        this.replaceButton.setText(text);
    }

    public final void setReplaceAllButtonText(String text) {
        this.replaceAllButton.setText(text);
    }

    public final void setReplaceWithLabelText(String text) {
        this.replaceFieldLabel.setText(text);
    }

    public void setReplaceString(String newReplaceString) {
        this.replaceWithCombo.addItem(newReplaceString);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            String selectedItem;
            String text = this.searchListener.getSelectedText();
            if (text != null) {
                this.findTextCombo.addItem(text);
            }
            if ((selectedItem = this.findTextCombo.getSelectedString()) == null || selectedItem.length() == 0) {
                this.findNextButton.setEnabled(false);
                this.replaceButton.setEnabled(false);
                this.replaceAllButton.setEnabled(false);
            } else {
                this.handleToggleButtons();
            }
            super.setVisible(true);
            this.focusFindTextField();
        } else {
            super.setVisible(false);
        }
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
        this.pack();
        ReplaceFocusAdapter replaceFocusAdapter = new ReplaceFocusAdapter();
        ReplaceKeyListener replaceKeyListener = new ReplaceKeyListener();
        ReplaceDocumentListener replaceDocumentListener = new ReplaceDocumentListener();
        JTextComponent textField = UIUtil.getTextComponent(this.findTextCombo);
        textField.addFocusListener(replaceFocusAdapter);
        textField.addKeyListener(replaceKeyListener);
        textField.getDocument().addDocumentListener(replaceDocumentListener);
        textField = UIUtil.getTextComponent(this.replaceWithCombo);
        textField.addFocusListener(replaceFocusAdapter);
        textField.addKeyListener(replaceKeyListener);
        textField.getDocument().addDocumentListener(replaceDocumentListener);
    }

    private class ReplaceDocumentListener
    implements DocumentListener {
        private ReplaceDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e10) {
            JTextComponent findWhatTextField = UIUtil.getTextComponent(ReplaceDialog.this.findTextCombo);
            if (e10.getDocument().equals(findWhatTextField.getDocument())) {
                ReplaceDialog.this.handleToggleButtons();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e10) {
            JTextComponent findWhatTextField = UIUtil.getTextComponent(ReplaceDialog.this.findTextCombo);
            if (e10.getDocument().equals(findWhatTextField.getDocument()) && e10.getDocument().getLength() == 0) {
                ReplaceDialog.this.findNextButton.setEnabled(false);
                ReplaceDialog.this.replaceButton.setEnabled(false);
                ReplaceDialog.this.replaceAllButton.setEnabled(false);
            } else {
                ReplaceDialog.this.handleToggleButtons();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e10) {
        }
    }

    private class ReplaceFocusAdapter
    extends FocusAdapter {
        private ReplaceFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e10) {
            JTextComponent textField = (JTextComponent)e10.getSource();
            textField.selectAll();
            if (textField == UIUtil.getTextComponent(ReplaceDialog.this.findTextCombo)) {
                ReplaceDialog.this.lastSearchString = ReplaceDialog.this.findTextCombo.getSelectedString();
            } else {
                ReplaceDialog.this.lastReplaceString = ReplaceDialog.this.replaceWithCombo.getSelectedString();
            }
            ReplaceDialog.this.handleToggleButtons();
        }
    }

    private class ReplaceKeyListener
    extends KeyAdapter {
        private ReplaceKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e10) {
            if (e10.getKeyCode() == 10 && ReplaceDialog.isPreJava6JRE()) {
                if (e10.getSource() == UIUtil.getTextComponent(ReplaceDialog.this.findTextCombo)) {
                    String replaceString = ReplaceDialog.this.replaceWithCombo.getSelectedString();
                    ReplaceDialog.this.lastReplaceString = replaceString;
                    String searchString = ReplaceDialog.this.findTextCombo.getSelectedString();
                    if (!searchString.equals(ReplaceDialog.this.lastSearchString)) {
                        ReplaceDialog.this.findNextButton.doClick(0);
                        ReplaceDialog.this.lastSearchString = searchString;
                        UIUtil.getTextComponent(ReplaceDialog.this.findTextCombo).selectAll();
                    }
                } else {
                    String searchString = ReplaceDialog.this.findTextCombo.getSelectedString();
                    ReplaceDialog.this.lastSearchString = searchString;
                    String replaceString = ReplaceDialog.this.replaceWithCombo.getSelectedString();
                    if (!replaceString.equals(ReplaceDialog.this.lastReplaceString)) {
                        ReplaceDialog.this.findNextButton.doClick(0);
                        ReplaceDialog.this.lastReplaceString = replaceString;
                        UIUtil.getTextComponent(ReplaceDialog.this.replaceWithCombo).selectAll();
                    }
                }
            }
        }
    }
}

