/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui.search;

import java.util.Vector;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ui.UIUtil;
import org.fife.rsta.ui.search.FindToolBar;
import org.fife.rsta.ui.search.RegexAwareComboBox;

public class SearchComboBox
extends RegexAwareComboBox {
    private FindToolBar toolBar;

    public SearchComboBox(FindToolBar toolBar, boolean replace) {
        super(replace);
        this.toolBar = toolBar;
        UIUtil.fixComboOrientation(this);
        this.updateTextFieldKeyMap();
    }

    public void addItem(Object item) {
        int curIndex = this.getIndexOf(item);
        if (curIndex == -1) {
            super.addItem(item);
        } else if (curIndex > 0) {
            this.removeItem(item);
            this.insertItemAt(item, 0);
        }
        this.setSelectedIndex(0);
    }

    private int getIndexOf(Object item) {
        int i10 = 0;
        while (i10 < this.dataModel.getSize()) {
            if (this.dataModel.getElementAt(i10).equals(item)) {
                return i10;
            }
            ++i10;
        }
        return -1;
    }

    public String getSelectedString() {
        JTextComponent comp = UIUtil.getTextComponent(this);
        return comp.getText();
    }

    public Vector<String> getSearchStrings() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex == -1) {
            this.addItem(this.getSelectedString());
        } else if (selectedIndex > 0) {
            Object item = this.getSelectedItem();
            this.removeItem(item);
            this.insertItemAt(item, 0);
            this.setSelectedIndex(0);
        }
        int itemCount = this.getItemCount();
        Vector<String> vector = new Vector<String>(itemCount);
        int i10 = 0;
        while (i10 < itemCount) {
            vector.add((String)this.getItemAt(i10));
            ++i10;
        }
        return vector;
    }

    private void updateTextFieldKeyMap() {
        JTextComponent comp = UIUtil.getTextComponent(this);
        InputMap im2 = comp.getInputMap();
        im2.put(KeyStroke.getKeyStroke("ctrl H"), "none");
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.toolBar != null) {
            this.toolBar.searchComboUpdateUICallback(this);
        }
        this.updateTextFieldKeyMap();
    }
}

