/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.CompletionProviderBase;
import org.fife.ui.autocomplete.Util;

public abstract class AbstractCompletionProvider
extends CompletionProviderBase {
    protected List<Completion> completions;
    protected CaseInsensitiveComparator comparator = new CaseInsensitiveComparator();

    public AbstractCompletionProvider() {
        this.clearParameterizedCompletionParams();
        this.completions = new ArrayList<Completion>();
    }

    public void addCompletion(Completion c10) {
        this.checkProviderAndAdd(c10);
        Collections.sort(this.completions);
    }

    public void addCompletions(List<Completion> completions) {
        for (Completion c10 : completions) {
            this.checkProviderAndAdd(c10);
        }
        Collections.sort(this.completions);
    }

    protected void addWordCompletions(String[] words) {
        int count = words == null ? 0 : words.length;
        int i10 = 0;
        while (i10 < count) {
            this.completions.add(new BasicCompletion((CompletionProvider)this, words[i10]));
            ++i10;
        }
        Collections.sort(this.completions);
    }

    protected void checkProviderAndAdd(Completion c10) {
        if (c10.getProvider() != this) {
            throw new IllegalArgumentException("Invalid CompletionProvider");
        }
        this.completions.add(c10);
    }

    public void clear() {
        this.completions.clear();
    }

    public List<Completion> getCompletionByInputText(String inputText) {
        int end = Collections.binarySearch(this.completions, inputText, this.comparator);
        if (end < 0) {
            return null;
        }
        int start = end;
        while (start > 0 && this.comparator.compare(this.completions.get(start - 1), inputText) == 0) {
            --start;
        }
        int count = this.completions.size();
        while (++end < count && this.comparator.compare(this.completions.get(end), inputText) == 0) {
        }
        return this.completions.subList(start, end);
    }

    @Override
    protected List<Completion> getCompletionsImpl(JTextComponent comp) {
        ArrayList<Completion> retVal = new ArrayList<Completion>();
        String text = this.getAlreadyEnteredText(comp);
        if (text != null) {
            int index = Collections.binarySearch(this.completions, text, this.comparator);
            if (index < 0) {
                index = -index - 1;
            } else {
                int pos = index - 1;
                while (pos > 0 && this.comparator.compare(this.completions.get(pos), text) == 0) {
                    retVal.add(this.completions.get(pos));
                    --pos;
                }
            }
            while (index < this.completions.size()) {
                Completion c10 = this.completions.get(index);
                if (!Util.startsWithIgnoreCase(c10.getInputText(), text)) break;
                retVal.add(c10);
                ++index;
            }
        }
        return retVal;
    }

    public boolean removeCompletion(Completion c10) {
        int index = Collections.binarySearch(this.completions, c10);
        if (index < 0) {
            return false;
        }
        this.completions.remove(index);
        return true;
    }

    public static class CaseInsensitiveComparator
    implements Comparator,
    Serializable {
        public int compare(Object o12, Object o22) {
            String s12 = o12 instanceof String ? (String)o12 : ((Completion)o12).getInputText();
            String s22 = o22 instanceof String ? (String)o22 : ((Completion)o22).getInputText();
            return String.CASE_INSENSITIVE_ORDER.compare(s12, s22);
        }
    }
}

