/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.BorderLayout;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompleteDescWindow;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionListModel;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DelegatingCellRenderer;
import org.fife.ui.autocomplete.FastListUI;
import org.fife.ui.autocomplete.SizeGrip;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;

class AutoCompletePopupWindow
extends JWindow
implements CaretListener,
ListSelectionListener,
MouseListener {
    private AutoCompletion ac;
    private JList list;
    private CompletionListModel model;
    private Completion lastSelection;
    private AutoCompleteDescWindow descWindow;
    private Dimension preferredDescWindowSize;
    private boolean aboveCaret;
    private int lastLine;
    private boolean keyBindingsInstalled;
    private KeyActionPair escapeKap;
    private KeyActionPair upKap;
    private KeyActionPair downKap;
    private KeyActionPair leftKap;
    private KeyActionPair rightKap;
    private KeyActionPair enterKap;
    private KeyActionPair tabKap;
    private KeyActionPair homeKap;
    private KeyActionPair endKap;
    private KeyActionPair pageUpKap;
    private KeyActionPair pageDownKap;
    private KeyActionPair ctrlCKap;
    private KeyActionPair oldEscape;
    private KeyActionPair oldUp;
    private KeyActionPair oldDown;
    private KeyActionPair oldLeft;
    private KeyActionPair oldRight;
    private KeyActionPair oldEnter;
    private KeyActionPair oldTab;
    private KeyActionPair oldHome;
    private KeyActionPair oldEnd;
    private KeyActionPair oldPageUp;
    private KeyActionPair oldPageDown;
    private KeyActionPair oldCtrlC;
    private static final int VERTICAL_SPACE = 1;
    private static final String SUBSTANCE_LIST_UI = "org.pushingpixels.substance.internal.ui.SubstanceListUI";

    public AutoCompletePopupWindow(Window parent, AutoCompletion ac10) {
        super(parent);
        PopupWindowDecorator decorator;
        ComponentOrientation o10 = ac10.getTextComponentOrientation();
        this.ac = ac10;
        this.model = new CompletionListModel();
        this.list = new PopupList(this.model);
        this.list.setCellRenderer(new DelegatingCellRenderer());
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(this);
        JPanel contentPane = new JPanel(new BorderLayout());
        JScrollPane sp2 = new JScrollPane(this.list, 22, 32);
        SizeGrip corner = new SizeGrip();
        boolean isLeftToRight = o10.isLeftToRight();
        String str = isLeftToRight ? "LOWER_RIGHT_CORNER" : "LOWER_LEFT_CORNER";
        sp2.setCorner(str, corner);
        contentPane.add(sp2);
        this.setContentPane(contentPane);
        this.applyComponentOrientation(o10);
        if (Util.getShouldAllowDecoratingMainAutoCompleteWindows() && (decorator = PopupWindowDecorator.get()) != null) {
            decorator.decorate(this);
        }
        this.pack();
        this.setFocusableWindowState(false);
        this.lastLine = -1;
    }

    @Override
    public void caretUpdate(CaretEvent e10) {
        if (this.isVisible()) {
            int line = this.ac.getLineOfCaret();
            if (line != this.lastLine) {
                this.lastLine = -1;
                this.setVisible(false);
            } else {
                this.doAutocomplete();
            }
        } else if (AutoCompletion.getDebug()) {
            Thread.dumpStack();
        }
    }

    private AutoCompleteDescWindow createDescriptionWindow() {
        AutoCompleteDescWindow dw2 = new AutoCompleteDescWindow((Window)this, this.ac);
        dw2.applyComponentOrientation(this.ac.getTextComponentOrientation());
        Dimension size = this.preferredDescWindowSize;
        if (size == null) {
            size = this.getSize();
        }
        dw2.setSize(size);
        return dw2;
    }

    private void createKeyActionPairs() {
        EnterAction enterAction = new EnterAction();
        this.escapeKap = new KeyActionPair("Escape", new EscapeAction());
        this.upKap = new KeyActionPair("Up", new UpAction());
        this.downKap = new KeyActionPair("Down", new DownAction());
        this.leftKap = new KeyActionPair("Left", new LeftAction());
        this.rightKap = new KeyActionPair("Right", new RightAction());
        this.enterKap = new KeyActionPair("Enter", enterAction);
        this.tabKap = new KeyActionPair("Tab", enterAction);
        this.homeKap = new KeyActionPair("Home", new HomeAction());
        this.endKap = new KeyActionPair("End", new EndAction());
        this.pageUpKap = new KeyActionPair("PageUp", new PageUpAction());
        this.pageDownKap = new KeyActionPair("PageDown", new PageDownAction());
        this.ctrlCKap = new KeyActionPair("CtrlC", new CopyAction());
        this.oldEscape = new KeyActionPair();
        this.oldUp = new KeyActionPair();
        this.oldDown = new KeyActionPair();
        this.oldLeft = new KeyActionPair();
        this.oldRight = new KeyActionPair();
        this.oldEnter = new KeyActionPair();
        this.oldTab = new KeyActionPair();
        this.oldHome = new KeyActionPair();
        this.oldEnd = new KeyActionPair();
        this.oldPageUp = new KeyActionPair();
        this.oldPageDown = new KeyActionPair();
        this.oldCtrlC = new KeyActionPair();
    }

    protected void doAutocomplete() {
        this.lastLine = this.ac.refreshPopupWindow();
    }

    private static final KeyStroke getCopyKeyStroke() {
        int key = 67;
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        return KeyStroke.getKeyStroke(key, mask);
    }

    public ListCellRenderer getListCellRenderer() {
        DelegatingCellRenderer dcr = (DelegatingCellRenderer)this.list.getCellRenderer();
        return dcr.getFallbackCellRenderer();
    }

    public Completion getSelection() {
        return this.isShowing() ? (Completion)this.list.getSelectedValue() : this.lastSelection;
    }

    private void insertSelectedCompletion() {
        Completion comp = this.getSelection();
        this.ac.insertCompletion(comp);
    }

    private void installKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("PopupWindow: Installing keybindings");
        }
        if (this.keyBindingsInstalled) {
            System.err.println("Error: key bindings were already installed");
            Thread.dumpStack();
            return;
        }
        if (this.escapeKap == null) {
            this.createKeyActionPairs();
        }
        JTextComponent comp = this.ac.getTextComponent();
        InputMap im2 = comp.getInputMap();
        ActionMap am10 = comp.getActionMap();
        this.replaceAction(im2, am10, 27, this.escapeKap, this.oldEscape);
        if (AutoCompletion.getDebug() && this.oldEscape.action == this.escapeKap.action) {
            Thread.dumpStack();
        }
        this.replaceAction(im2, am10, 38, this.upKap, this.oldUp);
        this.replaceAction(im2, am10, 37, this.leftKap, this.oldLeft);
        this.replaceAction(im2, am10, 40, this.downKap, this.oldDown);
        this.replaceAction(im2, am10, 39, this.rightKap, this.oldRight);
        this.replaceAction(im2, am10, 10, this.enterKap, this.oldEnter);
        this.replaceAction(im2, am10, 9, this.tabKap, this.oldTab);
        this.replaceAction(im2, am10, 36, this.homeKap, this.oldHome);
        this.replaceAction(im2, am10, 35, this.endKap, this.oldEnd);
        this.replaceAction(im2, am10, 33, this.pageUpKap, this.oldPageUp);
        this.replaceAction(im2, am10, 34, this.pageDownKap, this.oldPageDown);
        KeyStroke ks2 = AutoCompletePopupWindow.getCopyKeyStroke();
        this.oldCtrlC.key = im2.get(ks2);
        im2.put(ks2, this.ctrlCKap.key);
        this.oldCtrlC.action = am10.get(this.ctrlCKap.key);
        am10.put(this.ctrlCKap.key, this.ctrlCKap.action);
        comp.addCaretListener(this);
        this.keyBindingsInstalled = true;
    }

    @Override
    public void mouseClicked(MouseEvent e10) {
        if (e10.getClickCount() == 2) {
            this.insertSelectedCompletion();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e10) {
    }

    @Override
    public void mouseExited(MouseEvent e10) {
    }

    @Override
    public void mousePressed(MouseEvent e10) {
    }

    @Override
    public void mouseReleased(MouseEvent e10) {
    }

    private void positionDescWindow() {
        int x10;
        boolean showDescWindow;
        boolean bl2 = showDescWindow = this.descWindow != null && this.ac.getShowDescWindow();
        if (!showDescWindow) {
            return;
        }
        Point p10 = this.getLocation();
        Rectangle screenBounds = Util.getScreenBoundsForPoint(p10.x, p10.y);
        if (this.ac.getTextComponentOrientation().isLeftToRight()) {
            x10 = this.getX() + this.getWidth() + 5;
            if (x10 + this.descWindow.getWidth() > screenBounds.x + screenBounds.width) {
                x10 = this.getX() - 5 - this.descWindow.getWidth();
            }
        } else {
            x10 = this.getX() - 5 - this.descWindow.getWidth();
            if (x10 < screenBounds.x) {
                x10 = this.getX() + this.getWidth() + 5;
            }
        }
        int y10 = this.getY();
        if (this.aboveCaret) {
            y10 = y10 + this.getHeight() - this.descWindow.getHeight();
        }
        if (x10 != this.descWindow.getX() || y10 != this.descWindow.getY()) {
            this.descWindow.setLocation(x10, y10);
        }
    }

    private void putBackAction(InputMap im2, ActionMap am10, int key, KeyActionPair kap) {
        KeyStroke ks2 = KeyStroke.getKeyStroke(key, 0);
        am10.put(im2.get(ks2), kap.action);
        im2.put(ks2, kap.key);
    }

    private void replaceAction(InputMap im2, ActionMap am10, int key, KeyActionPair kap, KeyActionPair old) {
        KeyStroke ks2 = KeyStroke.getKeyStroke(key, 0);
        old.key = im2.get(ks2);
        im2.put(ks2, kap.key);
        old.action = am10.get(kap.key);
        am10.put(kap.key, kap.action);
    }

    private void selectFirstItem() {
        if (this.model.getSize() > 0) {
            this.list.setSelectedIndex(0);
            this.list.ensureIndexIsVisible(0);
        }
    }

    private void selectLastItem() {
        int index = this.model.getSize() - 1;
        if (index > -1) {
            this.list.setSelectedIndex(index);
            this.list.ensureIndexIsVisible(index);
        }
    }

    private void selectNextItem() {
        int index = this.list.getSelectedIndex();
        if (index > -1) {
            index = (index + 1) % this.model.getSize();
            this.list.setSelectedIndex(index);
            this.list.ensureIndexIsVisible(index);
        }
    }

    private void selectPageDownItem() {
        int visibleRowCount = this.list.getVisibleRowCount();
        int i10 = Math.min(this.list.getModel().getSize() - 1, this.list.getSelectedIndex() + visibleRowCount);
        this.list.setSelectedIndex(i10);
        this.list.ensureIndexIsVisible(i10);
    }

    private void selectPageUpItem() {
        int visibleRowCount = this.list.getVisibleRowCount();
        int i10 = Math.max(0, this.list.getSelectedIndex() - visibleRowCount);
        this.list.setSelectedIndex(i10);
        this.list.ensureIndexIsVisible(i10);
    }

    private void selectPreviousItem() {
        int index = this.list.getSelectedIndex();
        switch (index) {
            case 0: {
                index = this.list.getModel().getSize() - 1;
                break;
            }
            case -1: {
                index = this.list.getModel().getSize() - 1;
                if (index != -1) break;
                return;
            }
            default: {
                --index;
            }
        }
        this.list.setSelectedIndex(index);
        this.list.ensureIndexIsVisible(index);
    }

    public void setCompletions(List<Completion> completions) {
        this.model.setContents(completions);
        this.selectFirstItem();
    }

    public void setDescriptionWindowSize(Dimension size) {
        if (this.descWindow != null) {
            this.descWindow.setSize(size);
        } else {
            this.preferredDescWindowSize = size;
        }
    }

    public void setListCellRenderer(ListCellRenderer renderer) {
        DelegatingCellRenderer dcr = (DelegatingCellRenderer)this.list.getCellRenderer();
        dcr.setFallbackCellRenderer(renderer);
    }

    public void setLocationRelativeTo(Rectangle r10) {
        Rectangle screenBounds = Util.getScreenBoundsForPoint(r10.x, r10.y);
        boolean showDescWindow = this.descWindow != null && this.ac.getShowDescWindow();
        int totalH = this.getHeight();
        if (showDescWindow) {
            totalH = Math.max(totalH, this.descWindow.getHeight());
        }
        this.aboveCaret = false;
        int y10 = r10.y + r10.height + 1;
        if (y10 + totalH > screenBounds.height) {
            y10 = r10.y - 1 - this.getHeight();
            this.aboveCaret = true;
        }
        int x10 = r10.x;
        if (!this.ac.getTextComponentOrientation().isLeftToRight()) {
            x10 -= this.getWidth();
        }
        if (x10 < screenBounds.x) {
            x10 = screenBounds.x;
        } else if (x10 + this.getWidth() > screenBounds.x + screenBounds.width) {
            x10 = screenBounds.x + screenBounds.width - this.getWidth();
        }
        this.setLocation(x10, y10);
        if (showDescWindow) {
            this.positionDescWindow();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            if (visible) {
                Completion c10;
                this.installKeyBindings();
                this.lastLine = this.ac.getLineOfCaret();
                this.selectFirstItem();
                if (this.descWindow == null && this.ac.getShowDescWindow()) {
                    this.descWindow = this.createDescriptionWindow();
                    this.positionDescWindow();
                }
                if (this.descWindow != null && (c10 = (Completion)this.list.getSelectedValue()) != null) {
                    this.descWindow.setDescriptionFor(c10);
                }
            } else {
                this.uninstallKeyBindings();
            }
            super.setVisible(visible);
            if (!visible) {
                this.lastSelection = (Completion)this.list.getSelectedValue();
                this.model.clear();
            }
            if (this.descWindow != null) {
                this.descWindow.setVisible(visible && this.ac.getShowDescWindow());
            }
        }
    }

    private void uninstallKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("PopupWindow: Removing keybindings");
        }
        if (!this.keyBindingsInstalled) {
            return;
        }
        JTextComponent comp = this.ac.getTextComponent();
        InputMap im2 = comp.getInputMap();
        ActionMap am10 = comp.getActionMap();
        this.putBackAction(im2, am10, 27, this.oldEscape);
        this.putBackAction(im2, am10, 38, this.oldUp);
        this.putBackAction(im2, am10, 40, this.oldDown);
        this.putBackAction(im2, am10, 37, this.oldLeft);
        this.putBackAction(im2, am10, 39, this.oldRight);
        this.putBackAction(im2, am10, 10, this.oldEnter);
        this.putBackAction(im2, am10, 9, this.oldTab);
        this.putBackAction(im2, am10, 36, this.oldHome);
        this.putBackAction(im2, am10, 35, this.oldEnd);
        this.putBackAction(im2, am10, 33, this.oldPageUp);
        this.putBackAction(im2, am10, 34, this.oldPageDown);
        KeyStroke ks2 = AutoCompletePopupWindow.getCopyKeyStroke();
        am10.put(im2.get(ks2), this.oldCtrlC.action);
        im2.put(ks2, this.oldCtrlC.key);
        comp.removeCaretListener(this);
        this.keyBindingsInstalled = false;
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
        if (this.descWindow != null) {
            this.descWindow.updateUI();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e10) {
        Object value;
        if (!e10.getValueIsAdjusting() && (value = this.list.getSelectedValue()) != null && this.descWindow != null) {
            this.descWindow.setDescriptionFor((Completion)value);
            this.positionDescWindow();
        }
    }

    class CopyAction
    extends AbstractAction {
        CopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            boolean doNormalCopy = false;
            if (AutoCompletePopupWindow.this.descWindow != null && AutoCompletePopupWindow.this.descWindow.isVisible()) {
                boolean bl2 = doNormalCopy = !AutoCompletePopupWindow.this.descWindow.copy();
            }
            if (doNormalCopy) {
                AutoCompletePopupWindow.this.ac.getTextComponent().copy();
            }
        }
    }

    class DownAction
    extends AbstractAction {
        DownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.selectNextItem();
            }
        }
    }

    class EndAction
    extends AbstractAction {
        EndAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.selectLastItem();
            }
        }
    }

    class EnterAction
    extends AbstractAction {
        EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.insertSelectedCompletion();
            }
        }
    }

    class EscapeAction
    extends AbstractAction {
        EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.setVisible(false);
            }
        }
    }

    class HomeAction
    extends AbstractAction {
        HomeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.selectFirstItem();
            }
        }
    }

    private static class KeyActionPair {
        public Object key;
        public Action action;

        public KeyActionPair() {
        }

        public KeyActionPair(Object key, Action a10) {
            this.key = key;
            this.action = a10;
        }
    }

    class LeftAction
    extends AbstractAction {
        LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            JTextComponent comp;
            Caret c10;
            int dot;
            if (AutoCompletePopupWindow.this.isVisible() && (dot = (c10 = (comp = AutoCompletePopupWindow.this.ac.getTextComponent()).getCaret()).getDot()) > 0) {
                c10.setDot(--dot);
                if (comp.isVisible() && AutoCompletePopupWindow.this.lastLine != -1) {
                    AutoCompletePopupWindow.this.doAutocomplete();
                }
            }
        }
    }

    class PageDownAction
    extends AbstractAction {
        PageDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.selectPageDownItem();
            }
        }
    }

    class PageUpAction
    extends AbstractAction {
        PageUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.selectPageUpItem();
            }
        }
    }

    private class PopupList
    extends JList {
        public PopupList(CompletionListModel model) {
            super(model);
        }

        @Override
        public void setUI(ListUI ui2) {
            if (Util.getUseSubstanceRenderers() && AutoCompletePopupWindow.SUBSTANCE_LIST_UI.equals(ui2.getClass().getName())) {
                CompletionProvider p10 = AutoCompletePopupWindow.this.ac.getCompletionProvider();
                BasicCompletion bc2 = new BasicCompletion(p10, "Hello world");
                this.setPrototypeCellValue(bc2);
            } else {
                ui2 = new FastListUI();
                this.setPrototypeCellValue(null);
            }
            super.setUI(ui2);
        }
    }

    class RightAction
    extends AbstractAction {
        RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            JTextComponent comp;
            Caret c10;
            int dot;
            if (AutoCompletePopupWindow.this.isVisible() && (dot = (c10 = (comp = AutoCompletePopupWindow.this.ac.getTextComponent()).getCaret()).getDot()) < comp.getDocument().getLength()) {
                c10.setDot(++dot);
                if (comp.isVisible() && AutoCompletePopupWindow.this.lastLine != -1) {
                    AutoCompletePopupWindow.this.doAutocomplete();
                }
            }
        }
    }

    class UpAction
    extends AbstractAction {
        UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.selectPreviousItem();
            }
        }
    }
}

