/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionXMLParser;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultCompletionProvider
extends AbstractCompletionProvider {
    protected Segment seg;
    private String lastCompletionsAtText;
    private List<Completion> lastParameterizedCompletionsAt;

    public DefaultCompletionProvider() {
        this.init();
    }

    public DefaultCompletionProvider(String[] words) {
        this.init();
        this.addWordCompletions(words);
    }

    @Override
    public String getAlreadyEnteredText(JTextComponent comp) {
        Document doc = comp.getDocument();
        int dot = comp.getCaretPosition();
        Element root = doc.getDefaultRootElement();
        int index = root.getElementIndex(dot);
        Element elem = root.getElement(index);
        int start = elem.getStartOffset();
        int len = dot - start;
        try {
            doc.getText(start, len, this.seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return "";
        }
        int segEnd = this.seg.offset + len;
        start = segEnd - 1;
        while (start >= this.seg.offset && this.isValidChar(this.seg.array[start])) {
            --start;
        }
        return (len = segEnd - ++start) == 0 ? "" : new String(this.seg.array, start, len);
    }

    @Override
    public List<Completion> getCompletionsAt(JTextComponent tc2, Point p10) {
        int offset = tc2.viewToModel(p10);
        if (offset < 0 || offset >= tc2.getDocument().getLength()) {
            this.lastCompletionsAtText = null;
            this.lastParameterizedCompletionsAt = null;
            return null;
        }
        Segment s10 = new Segment();
        Document doc = tc2.getDocument();
        Element root = doc.getDefaultRootElement();
        int line = root.getElementIndex(offset);
        Element elem = root.getElement(line);
        int start = elem.getStartOffset();
        int end = elem.getEndOffset() - 1;
        try {
            doc.getText(start, end - start, s10);
            int startOffs = s10.offset + (offset - start) - 1;
            while (startOffs >= s10.offset && this.isValidChar(s10.array[startOffs])) {
                --startOffs;
            }
            int endOffs = s10.offset + (offset - start);
            while (endOffs < s10.offset + s10.count && this.isValidChar(s10.array[endOffs])) {
                ++endOffs;
            }
            int len = endOffs - startOffs - 1;
            if (len <= 0) {
                this.lastParameterizedCompletionsAt = null;
                return null;
            }
            String text = new String(s10.array, startOffs + 1, len);
            if (text.equals(this.lastCompletionsAtText)) {
                return this.lastParameterizedCompletionsAt;
            }
            List<Completion> list = this.getCompletionByInputText(text);
            this.lastCompletionsAtText = text;
            this.lastParameterizedCompletionsAt = list;
            return this.lastParameterizedCompletionsAt;
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            this.lastCompletionsAtText = null;
            this.lastParameterizedCompletionsAt = null;
            return null;
        }
    }

    @Override
    public List<ParameterizedCompletion> getParameterizedCompletions(JTextComponent tc2) {
        int line;
        ArrayList<ParameterizedCompletion> list = null;
        char paramListStart = this.getParameterListStart();
        if (paramListStart == '\u0000') {
            return list;
        }
        int dot = tc2.getCaretPosition();
        Segment s10 = new Segment();
        Document doc = tc2.getDocument();
        Element root = doc.getDefaultRootElement();
        Element elem = root.getElement(line = root.getElementIndex(dot));
        int offs = elem.getStartOffset();
        int len = dot - offs - 1;
        if (len <= 0) {
            return list;
        }
        try {
            doc.getText(offs, len, s10);
            offs = s10.offset + len - 1;
            while (offs >= s10.offset && Character.isWhitespace(s10.array[offs])) {
                --offs;
            }
            int end = offs;
            while (offs >= s10.offset && this.isValidChar(s10.array[offs])) {
                --offs;
            }
            String text = new String(s10.array, offs + 1, end - offs);
            List<Completion> l10 = this.getCompletionByInputText(text);
            if (l10 != null && !l10.isEmpty()) {
                int i10 = 0;
                while (i10 < l10.size()) {
                    Completion o10 = l10.get(i10);
                    if (o10 instanceof ParameterizedCompletion) {
                        if (list == null) {
                            list = new ArrayList<ParameterizedCompletion>(1);
                        }
                        list.add((ParameterizedCompletion)o10);
                    }
                    ++i10;
                }
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return list;
    }

    protected void init() {
        this.seg = new Segment();
    }

    protected boolean isValidChar(char ch2) {
        return Character.isLetterOrDigit(ch2) || ch2 == '_';
    }

    public void loadFromXML(File file) throws IOException {
        try (BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));){
            this.loadFromXML(bin);
        }
    }

    public void loadFromXML(InputStream in2) throws IOException {
        this.loadFromXML(in2, null);
    }

    public void loadFromXML(InputStream in2, ClassLoader cl2) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        CompletionXMLParser handler = new CompletionXMLParser(this, cl2);
        try (BufferedInputStream bin = new BufferedInputStream(in2);){
            try {
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse((InputStream)bin, (DefaultHandler)handler);
                List<Completion> completions = handler.getCompletions();
                this.addCompletions(completions);
                char startChar = handler.getParamStartChar();
                if (startChar != '\u0000') {
                    char endChar = handler.getParamEndChar();
                    String sep = handler.getParamSeparator();
                    if (endChar != '\u0000' && sep != null && sep.length() > 0) {
                        this.setParameterizedCompletionParams(startChar, sep, endChar);
                    }
                }
            }
            catch (SAXException se2) {
                throw new IOException(se2.toString());
            }
            catch (ParserConfigurationException pce) {
                throw new IOException(pce.toString());
            }
        }
    }

    public void loadFromXML(String resource) throws IOException {
        ClassLoader cl2 = this.getClass().getClassLoader();
        InputStream in2 = cl2.getResourceAsStream(resource);
        if (in2 == null) {
            File file = new File(resource);
            if (file.isFile()) {
                in2 = new FileInputStream(file);
            } else {
                throw new IOException("No such resource: " + resource);
            }
        }
        try (BufferedInputStream bin = new BufferedInputStream(in2);){
            this.loadFromXML(bin);
        }
    }
}

