/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.autocomplete.VariableCompletion;

public class FunctionCompletion
extends VariableCompletion
implements ParameterizedCompletion {
    private List<ParameterizedCompletion.Parameter> params;
    private String returnValDesc;
    private String compareString;

    public FunctionCompletion(CompletionProvider provider, String name, String returnType) {
        super(provider, name, returnType);
    }

    @Override
    protected void addDefinitionString(StringBuilder sb2) {
        sb2.append("<html><b>");
        sb2.append(this.getDefinitionString());
        sb2.append("</b>");
    }

    protected void addParameters(StringBuilder sb2) {
        int paramCount = this.getParamCount();
        if (paramCount > 0) {
            sb2.append("<b>Parameters:</b><br>");
            sb2.append("<center><table width='90%'><tr><td>");
            int i10 = 0;
            while (i10 < paramCount) {
                ParameterizedCompletion.Parameter param = this.getParam(i10);
                sb2.append("<b>");
                sb2.append(param.getName() != null ? param.getName() : param.getType());
                sb2.append("</b>&nbsp;");
                String desc = param.getDescription();
                if (desc != null) {
                    sb2.append(desc);
                }
                sb2.append("<br>");
                ++i10;
            }
            sb2.append("</td></tr></table></center><br><br>");
        }
        if (this.returnValDesc != null) {
            sb2.append("<b>Returns:</b><br><center><table width='90%'><tr><td>");
            sb2.append(this.returnValDesc);
            sb2.append("</td></tr></table></center><br><br>");
        }
    }

    @Override
    public int compareTo(Completion c22) {
        int rc2 = -1;
        rc2 = c22 == this ? 0 : (c22 instanceof FunctionCompletion ? this.getCompareString().compareTo(((FunctionCompletion)c22).getCompareString()) : super.compareTo(c22));
        return rc2;
    }

    private String getCompareString() {
        if (this.compareString == null) {
            StringBuilder sb2 = new StringBuilder(this.getName());
            int paramCount = this.getParamCount();
            if (paramCount < 10) {
                sb2.append('0');
            }
            sb2.append(paramCount);
            int i10 = 0;
            while (i10 < paramCount) {
                String type = this.getParam(i10).getType();
                sb2.append(type);
                if (i10 < paramCount - 1) {
                    sb2.append(',');
                }
                ++i10;
            }
            this.compareString = sb2.toString();
        }
        return this.compareString;
    }

    @Override
    public String getDefinitionString() {
        StringBuilder sb2 = new StringBuilder();
        String type = this.getType();
        if (type != null) {
            sb2.append(type).append(' ');
        }
        sb2.append(this.getName());
        CompletionProvider provider = this.getProvider();
        char start = provider.getParameterListStart();
        if (start != '\u0000') {
            sb2.append(start);
        }
        int i10 = 0;
        while (i10 < this.getParamCount()) {
            ParameterizedCompletion.Parameter param = this.getParam(i10);
            type = param.getType();
            String name = param.getName();
            if (type != null) {
                sb2.append(type);
                if (name != null) {
                    sb2.append(' ');
                }
            }
            if (name != null) {
                sb2.append(name);
            }
            if (i10 < this.params.size() - 1) {
                sb2.append(provider.getParameterListSeparator());
            }
            ++i10;
        }
        char end = provider.getParameterListEnd();
        if (end != '\u0000') {
            sb2.append(end);
        }
        return sb2.toString();
    }

    @Override
    public ParameterizedCompletionInsertionInfo getInsertionInfo(JTextComponent tc2, boolean replaceTabsWithSpaces) {
        ParameterizedCompletionInsertionInfo info = new ParameterizedCompletionInsertionInfo();
        StringBuilder sb2 = new StringBuilder();
        char paramListStart = this.getProvider().getParameterListStart();
        if (paramListStart != '\u0000') {
            sb2.append(paramListStart);
        }
        int dot = tc2.getCaretPosition() + sb2.length();
        int paramCount = this.getParamCount();
        int minPos = dot;
        Position maxPos = null;
        try {
            maxPos = tc2.getDocument().createPosition(dot - sb2.length() + 1);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        info.setCaretRange(minPos, maxPos);
        int firstParamLen = 0;
        int start = dot;
        int i10 = 0;
        while (i10 < paramCount) {
            ParameterizedCompletion.Parameter param = this.getParam(i10);
            String paramText = this.getParamText(param);
            if (i10 == 0) {
                firstParamLen = paramText.length();
            }
            sb2.append(paramText);
            int end = start + paramText.length();
            info.addReplacementLocation(start, end);
            String sep = this.getProvider().getParameterListSeparator();
            if (i10 < paramCount - 1 && sep != null) {
                sb2.append(sep);
                start = end + sep.length();
            }
            ++i10;
        }
        sb2.append(this.getProvider().getParameterListEnd());
        int endOffs = dot + sb2.length();
        info.addReplacementLocation(--endOffs, endOffs);
        info.setDefaultEndOffs(endOffs);
        int selectionEnd = paramCount > 0 ? dot + firstParamLen : dot;
        info.setInitialSelection(dot, selectionEnd);
        info.setTextToInsert(sb2.toString());
        return info;
    }

    @Override
    public ParameterizedCompletion.Parameter getParam(int index) {
        return this.params.get(index);
    }

    @Override
    public int getParamCount() {
        return this.params == null ? 0 : this.params.size();
    }

    @Override
    public boolean getShowParameterToolTip() {
        return true;
    }

    private String getParamText(ParameterizedCompletion.Parameter param) {
        String text = param.getName();
        if (text == null && (text = param.getType()) == null) {
            text = "arg";
        }
        return text;
    }

    public String getReturnValueDescription() {
        return this.returnValDesc;
    }

    @Override
    public String getSummary() {
        StringBuilder sb2 = new StringBuilder();
        this.addDefinitionString(sb2);
        if (!this.possiblyAddDescription(sb2)) {
            sb2.append("<br><br><br>");
        }
        this.addParameters(sb2);
        this.possiblyAddDefinedIn(sb2);
        return sb2.toString();
    }

    @Override
    public String getToolTipText() {
        String text = this.getSummary();
        if (text == null) {
            text = this.getDefinitionString();
        }
        return text;
    }

    public void setParams(List<ParameterizedCompletion.Parameter> params) {
        if (params != null) {
            this.params = new ArrayList<ParameterizedCompletion.Parameter>(params);
        }
    }

    public void setReturnValueDescription(String desc) {
        this.returnValDesc = desc;
    }
}

