/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import org.fife.ui.autocomplete.AbstractCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;

public class MarkupTagCompletion
extends AbstractCompletion {
    private String name;
    private String desc;
    private String definedIn;
    private List<ParameterizedCompletion.Parameter> attrs;

    public MarkupTagCompletion(CompletionProvider provider, String name) {
        super(provider);
        this.name = name;
    }

    protected void addAttributes(StringBuilder sb2) {
        int attrCount = this.getAttributeCount();
        if (attrCount > 0) {
            sb2.append("<b>Attributes:</b><br>");
            sb2.append("<center><table width='90%'><tr><td>");
            int i10 = 0;
            while (i10 < attrCount) {
                ParameterizedCompletion.Parameter attr = this.getAttribute(i10);
                sb2.append("&nbsp;&nbsp;&nbsp;<b>");
                sb2.append(attr.getName() != null ? attr.getName() : attr.getType());
                sb2.append("</b>&nbsp;");
                String desc = attr.getDescription();
                if (desc != null) {
                    sb2.append(desc);
                }
                sb2.append("<br>");
                ++i10;
            }
            sb2.append("</td></tr></table></center><br><br>");
        }
    }

    protected void addDefinitionString(StringBuilder sb2) {
        sb2.append("<html><b>").append(this.name).append("</b>");
    }

    public List<ParameterizedCompletion.Parameter> getAttributes() {
        return this.attrs;
    }

    public ParameterizedCompletion.Parameter getAttribute(int index) {
        return this.attrs.get(index);
    }

    public int getAttributeCount() {
        return this.attrs == null ? 0 : this.attrs.size();
    }

    public String getDefinedIn() {
        return this.definedIn;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getReplacementText() {
        return this.getName();
    }

    @Override
    public String getSummary() {
        StringBuilder sb2 = new StringBuilder();
        this.addDefinitionString(sb2);
        this.possiblyAddDescription(sb2);
        this.addAttributes(sb2);
        this.possiblyAddDefinedIn(sb2);
        return sb2.toString();
    }

    protected void possiblyAddDefinedIn(StringBuilder sb2) {
        if (this.definedIn != null) {
            sb2.append("<hr>Defined in:");
            sb2.append(" <em>").append(this.definedIn).append("</em>");
        }
    }

    protected void possiblyAddDescription(StringBuilder sb2) {
        if (this.desc != null) {
            sb2.append("<hr><br>");
            sb2.append(this.desc);
            sb2.append("<br><br><br>");
        }
    }

    public void setDefinedIn(String definedIn) {
        this.definedIn = definedIn;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void setAttributes(List<? extends ParameterizedCompletion.Parameter> attrs) {
        this.attrs = new ArrayList<ParameterizedCompletion.Parameter>(attrs);
    }
}

