/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

class OutlineHighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter {
    private Color color;

    public OutlineHighlightPainter(Color color) {
        super(color);
        this.setColor(color);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Shape paintLayer(Graphics g10, int p02, int p12, Shape viewBounds, JTextComponent c10, View view) {
        g10.setColor(this.getColor());
        if (++p02 == p12) {
            try {
                Shape s10 = view.modelToView(p02, viewBounds, Position.Bias.Forward);
                Rectangle r10 = s10.getBounds();
                g10.drawLine(r10.x, r10.y, r10.x, r10.y + r10.height);
                return r10;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return null;
            }
        }
        if (p02 == view.getStartOffset() && p12 == view.getEndOffset()) {
            Rectangle alloc = viewBounds instanceof Rectangle ? (Rectangle)viewBounds : viewBounds.getBounds();
            g10.drawRect(alloc.x, alloc.y, alloc.width - 1, alloc.height - 1);
            return alloc;
        }
        try {
            Shape shape = view.modelToView(p02, Position.Bias.Forward, p12, Position.Bias.Backward, viewBounds);
            Rectangle r11 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            g10.drawRect(r11.x, r11.y, r11.width - 1, r11.height - 1);
            return r11;
        }
        catch (BadLocationException e10) {
            e10.printStackTrace();
            return null;
        }
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cannot be null");
        }
        this.color = color;
    }
}

