/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterChoicesProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionContext;
import org.fife.ui.autocomplete.SortByRelevanceComparator;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;

public class ParameterizedCompletionChoicesWindow
extends JWindow {
    private AutoCompletion ac;
    private JList list;
    private DefaultListModel model;
    private List<List<Completion>> choicesListList;
    private JScrollPane sp;
    private static final Comparator<Completion> sortByRelevanceComparator = new SortByRelevanceComparator();

    public ParameterizedCompletionChoicesWindow(Window parent, AutoCompletion ac10, final ParameterizedCompletionContext context) {
        super(parent);
        this.ac = ac10;
        ComponentOrientation o10 = ac10.getTextComponentOrientation();
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        if (ac10.getParamChoicesRenderer() != null) {
            this.list.setCellRenderer(ac10.getParamChoicesRenderer());
        }
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e10) {
                if (e10.getClickCount() == 2) {
                    context.insertSelectedChoice();
                }
            }
        });
        this.sp = new JScrollPane(this.list);
        this.setContentPane(this.sp);
        this.applyComponentOrientation(o10);
        this.setFocusableWindowState(false);
        PopupWindowDecorator decorator = PopupWindowDecorator.get();
        if (decorator != null) {
            decorator.decorate(this);
        }
    }

    public String getSelectedChoice() {
        Completion c10 = (Completion)this.list.getSelectedValue();
        return c10 == null ? null : c10.toString();
    }

    public void incSelection(int amount) {
        int selection = this.list.getSelectedIndex();
        selection = (selection += amount) < 0 ? this.model.getSize() - 1 : (selection %= this.model.getSize());
        this.list.setSelectedIndex(selection);
        this.list.ensureIndexIsVisible(selection);
    }

    public void initialize(ParameterizedCompletion pc2) {
        CompletionProvider provider = pc2.getProvider();
        ParameterChoicesProvider pcp = provider.getParameterChoicesProvider();
        if (pcp == null) {
            this.choicesListList = null;
            return;
        }
        int paramCount = pc2.getParamCount();
        this.choicesListList = new ArrayList<List<Completion>>(paramCount);
        JTextComponent tc2 = this.ac.getTextComponent();
        int i10 = 0;
        while (i10 < paramCount) {
            ParameterizedCompletion.Parameter param = pc2.getParam(i10);
            List<Completion> choices = pcp.getParameterChoices(tc2, param);
            this.choicesListList.add(choices);
            ++i10;
        }
    }

    public void setLocationRelativeTo(Rectangle r10) {
        Rectangle screenBounds = Util.getScreenBoundsForPoint(r10.x, r10.y);
        int y10 = r10.y + r10.height + 5;
        int x10 = r10.x;
        if (x10 < screenBounds.x) {
            x10 = screenBounds.x;
        } else if (x10 + this.getWidth() > screenBounds.x + screenBounds.width) {
            x10 = screenBounds.x + screenBounds.width - this.getWidth();
        }
        this.setLocation(x10, y10);
    }

    public void setParameter(int param, String prefix) {
        this.model.clear();
        ArrayList<Completion> temp = new ArrayList<Completion>();
        if (this.choicesListList != null && param >= 0 && param < this.choicesListList.size()) {
            List<Completion> choices = this.choicesListList.get(param);
            if (choices != null) {
                for (Completion completion : choices) {
                    String choice = completion.getReplacementText();
                    if (prefix != null && !Util.startsWithIgnoreCase(choice, prefix)) continue;
                    temp.add(completion);
                }
            }
            Object var5_8 = null;
            Comparator<Completion> comparator = sortByRelevanceComparator;
            Collections.sort(temp, comparator);
            int i10 = 0;
            while (i10 < temp.size()) {
                this.model.addElement(temp.get(i10));
                ++i10;
            }
            int visibleRowCount = Math.min(this.model.size(), 10);
            this.list.setVisibleRowCount(visibleRowCount);
            if (visibleRowCount == 0 && this.isVisible()) {
                this.setVisible(false);
            } else if (visibleRowCount > 0) {
                Dimension size = this.getPreferredSize();
                if (size.width < 150) {
                    this.setSize(150, size.height);
                } else {
                    this.pack();
                }
                if (this.sp.getVerticalScrollBar() != null && this.sp.getVerticalScrollBar().isVisible()) {
                    size = this.getSize();
                    int w10 = size.width + this.sp.getVerticalScrollBar().getWidth() + 5;
                    this.setSize(w10, size.height);
                }
                this.list.setSelectedIndex(0);
                this.list.ensureIndexIsVisible(0);
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
            }
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            if (visible && this.model.size() == 0) {
                return;
            }
            super.setVisible(visible);
        }
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
    }
}

