/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.AutoCompletionStyleContext;
import org.fife.ui.autocomplete.OutlineHighlightPainter;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionChoicesWindow;
import org.fife.ui.autocomplete.ParameterizedCompletionDescriptionToolTip;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;

class ParameterizedCompletionContext {
    private Window parentWindow;
    private AutoCompletion ac;
    private ParameterizedCompletion pc;
    private boolean active;
    private ParameterizedCompletionDescriptionToolTip tip;
    private Highlighter.HighlightPainter p;
    private Highlighter.HighlightPainter endingP;
    private Highlighter.HighlightPainter paramCopyP;
    private List<Object> tags;
    private List<ParamCopyInfo> paramCopyInfos;
    private transient boolean ignoringDocumentEvents;
    private Listener listener;
    private int minPos;
    private Position maxPos;
    private Position defaultEndOffs;
    private int lastSelectedParam;
    private ParameterizedCompletionChoicesWindow paramChoicesWindow;
    private String paramPrefix;
    private Object oldTabKey;
    private Action oldTabAction;
    private Object oldShiftTabKey;
    private Action oldShiftTabAction;
    private Object oldUpKey;
    private Action oldUpAction;
    private Object oldDownKey;
    private Action oldDownAction;
    private Object oldEnterKey;
    private Action oldEnterAction;
    private Object oldEscapeKey;
    private Action oldEscapeAction;
    private Object oldClosingKey;
    private Action oldClosingAction;
    private static final String IM_KEY_TAB = "ParamCompKey.Tab";
    private static final String IM_KEY_SHIFT_TAB = "ParamCompKey.ShiftTab";
    private static final String IM_KEY_UP = "ParamCompKey.Up";
    private static final String IM_KEY_DOWN = "ParamCompKey.Down";
    private static final String IM_KEY_ESCAPE = "ParamCompKey.Escape";
    private static final String IM_KEY_ENTER = "ParamCompKey.Enter";
    private static final String IM_KEY_CLOSING = "ParamCompKey.Closing";

    public ParameterizedCompletionContext(Window owner, AutoCompletion ac10, ParameterizedCompletion pc2) {
        this.parentWindow = owner;
        this.ac = ac10;
        this.pc = pc2;
        this.listener = new Listener();
        AutoCompletionStyleContext sc2 = AutoCompletion.getStyleContext();
        this.p = new OutlineHighlightPainter(sc2.getParameterOutlineColor());
        this.endingP = new OutlineHighlightPainter(sc2.getParameterizedCompletionCursorPositionColor());
        this.paramCopyP = new ChangeableHighlightPainter(sc2.getParameterCopyColor());
        this.tags = new ArrayList<Object>(1);
        this.paramCopyInfos = new ArrayList<ParamCopyInfo>(1);
    }

    public void activate() {
        if (this.active) {
            return;
        }
        this.active = true;
        JTextComponent tc2 = this.ac.getTextComponent();
        this.lastSelectedParam = -1;
        if (this.pc.getShowParameterToolTip()) {
            this.tip = new ParameterizedCompletionDescriptionToolTip(this.parentWindow, this, this.ac, this.pc);
            try {
                int dot = tc2.getCaretPosition();
                Rectangle r10 = tc2.modelToView(dot);
                Point p10 = new Point(r10.x, r10.y);
                SwingUtilities.convertPointToScreen(p10, tc2);
                r10.x = p10.x;
                r10.y = p10.y;
                this.tip.setLocationRelativeTo(r10);
                this.tip.setVisible(true);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(tc2);
                ble.printStackTrace();
                this.tip = null;
            }
        }
        this.listener.install(tc2);
        if (this.paramChoicesWindow == null) {
            this.paramChoicesWindow = this.createParamChoicesWindow();
        }
        this.lastSelectedParam = this.getCurrentParameterIndex();
        this.prepareParamChoicesWindow();
        this.paramChoicesWindow.setVisible(true);
    }

    private ParameterizedCompletionChoicesWindow createParamChoicesWindow() {
        ParameterizedCompletionChoicesWindow pcw = new ParameterizedCompletionChoicesWindow(this.parentWindow, this.ac, this);
        pcw.initialize(this.pc);
        return pcw;
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.listener.uninstall();
        if (this.tip != null) {
            this.tip.setVisible(false);
        }
        if (this.paramChoicesWindow != null) {
            this.paramChoicesWindow.setVisible(false);
        }
    }

    public String getArgumentText(int offs) {
        List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
        if (paramHighlights == null || paramHighlights.size() == 0) {
            return null;
        }
        for (Highlighter.Highlight h10 : paramHighlights) {
            if (offs < h10.getStartOffset() || offs > h10.getEndOffset()) continue;
            int start = h10.getStartOffset() + 1;
            int len = h10.getEndOffset() - start;
            JTextComponent tc2 = this.ac.getTextComponent();
            Document doc = tc2.getDocument();
            try {
                return doc.getText(start, len);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(tc2);
                ble.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private Highlighter.Highlight getCurrentParameterHighlight() {
        JTextComponent tc2 = this.ac.getTextComponent();
        int dot = tc2.getCaretPosition();
        if (dot > 0) {
            --dot;
        }
        List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
        for (Highlighter.Highlight h10 : paramHighlights) {
            if (dot < h10.getStartOffset() || dot >= h10.getEndOffset()) continue;
            return h10;
        }
        return null;
    }

    private int getCurrentParameterIndex() {
        JTextComponent tc2 = this.ac.getTextComponent();
        int dot = tc2.getCaretPosition();
        if (dot > 0) {
            --dot;
        }
        List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
        int i10 = 0;
        while (i10 < paramHighlights.size()) {
            Highlighter.Highlight h10 = paramHighlights.get(i10);
            if (dot >= h10.getStartOffset() && dot < h10.getEndOffset()) {
                return i10;
            }
            ++i10;
        }
        return -1;
    }

    private int getCurrentParameterStartOffset() {
        Highlighter.Highlight h10 = this.getCurrentParameterHighlight();
        return h10 != null ? h10.getStartOffset() + 1 : -1;
    }

    private static final int getFirstHighlight(List<Highlighter.Highlight> highlights) {
        int first = -1;
        Highlighter.Highlight firstH = null;
        int i10 = 0;
        while (i10 < highlights.size()) {
            Highlighter.Highlight h10 = highlights.get(i10);
            if (firstH == null || h10.getStartOffset() < firstH.getStartOffset()) {
                firstH = h10;
                first = i10;
            }
            ++i10;
        }
        return first;
    }

    private static final int getLastHighlight(List<Highlighter.Highlight> highlights) {
        int last = -1;
        Highlighter.Highlight lastH = null;
        int i10 = highlights.size() - 1;
        while (i10 >= 0) {
            Highlighter.Highlight h10 = highlights.get(i10);
            if (lastH == null || h10.getStartOffset() > lastH.getStartOffset()) {
                lastH = h10;
                last = i10;
            }
            --i10;
        }
        return last;
    }

    public List<Highlighter.Highlight> getParameterHighlights() {
        ArrayList<Highlighter.Highlight> paramHighlights = new ArrayList<Highlighter.Highlight>(2);
        JTextComponent tc2 = this.ac.getTextComponent();
        Highlighter.Highlight[] highlights = tc2.getHighlighter().getHighlights();
        int i10 = 0;
        while (i10 < highlights.length) {
            Highlighter.HighlightPainter painter = highlights[i10].getPainter();
            if (painter == this.p || painter == this.endingP) {
                paramHighlights.add(highlights[i10]);
            }
            ++i10;
        }
        return paramHighlights;
    }

    boolean insertSelectedChoice() {
        String choice;
        if (this.paramChoicesWindow != null && this.paramChoicesWindow.isVisible() && (choice = this.paramChoicesWindow.getSelectedChoice()) != null) {
            JTextComponent tc2 = this.ac.getTextComponent();
            Highlighter.Highlight h10 = this.getCurrentParameterHighlight();
            if (h10 != null) {
                tc2.setSelectionStart(h10.getStartOffset() + 1);
                tc2.setSelectionEnd(h10.getEndOffset());
                tc2.replaceSelection(choice);
                this.moveToNextParam();
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(tc2);
            }
            return true;
        }
        return false;
    }

    private void installKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("CompletionContext: Installing keybindings");
        }
        JTextComponent tc2 = this.ac.getTextComponent();
        InputMap im2 = tc2.getInputMap();
        ActionMap am10 = tc2.getActionMap();
        KeyStroke ks2 = KeyStroke.getKeyStroke(9, 0);
        this.oldTabKey = im2.get(ks2);
        im2.put(ks2, IM_KEY_TAB);
        this.oldTabAction = am10.get(IM_KEY_TAB);
        am10.put(IM_KEY_TAB, new NextParamAction());
        ks2 = KeyStroke.getKeyStroke(9, 1);
        this.oldShiftTabKey = im2.get(ks2);
        im2.put(ks2, IM_KEY_SHIFT_TAB);
        this.oldShiftTabAction = am10.get(IM_KEY_SHIFT_TAB);
        am10.put(IM_KEY_SHIFT_TAB, new PrevParamAction());
        ks2 = KeyStroke.getKeyStroke(38, 0);
        this.oldUpKey = im2.get(ks2);
        im2.put(ks2, IM_KEY_UP);
        this.oldUpAction = am10.get(IM_KEY_UP);
        am10.put(IM_KEY_UP, new NextChoiceAction(-1, this.oldUpAction));
        ks2 = KeyStroke.getKeyStroke(40, 0);
        this.oldDownKey = im2.get(ks2);
        im2.put(ks2, IM_KEY_DOWN);
        this.oldDownAction = am10.get(IM_KEY_DOWN);
        am10.put(IM_KEY_DOWN, new NextChoiceAction(1, this.oldDownAction));
        ks2 = KeyStroke.getKeyStroke(10, 0);
        this.oldEnterKey = im2.get(ks2);
        im2.put(ks2, IM_KEY_ENTER);
        this.oldEnterAction = am10.get(IM_KEY_ENTER);
        am10.put(IM_KEY_ENTER, new GotoEndAction());
        ks2 = KeyStroke.getKeyStroke(27, 0);
        this.oldEscapeKey = im2.get(ks2);
        im2.put(ks2, IM_KEY_ESCAPE);
        this.oldEscapeAction = am10.get(IM_KEY_ESCAPE);
        am10.put(IM_KEY_ESCAPE, new HideAction());
        char end = this.pc.getProvider().getParameterListEnd();
        ks2 = KeyStroke.getKeyStroke(end);
        this.oldClosingKey = im2.get(ks2);
        im2.put(ks2, IM_KEY_CLOSING);
        this.oldClosingAction = am10.get(IM_KEY_CLOSING);
        am10.put(IM_KEY_CLOSING, new ClosingAction());
    }

    private void moveToNextParam() {
        JTextComponent tc2 = this.ac.getTextComponent();
        int dot = tc2.getCaretPosition();
        int tagCount = this.tags.size();
        if (tagCount == 0) {
            tc2.setCaretPosition(this.maxPos.getOffset());
            this.deactivate();
        }
        Highlighter.Highlight currentNext = null;
        int pos = -1;
        List<Highlighter.Highlight> highlights = this.getParameterHighlights();
        int i10 = 0;
        while (i10 < highlights.size()) {
            Highlighter.Highlight hl2 = highlights.get(i10);
            if (currentNext == null || currentNext.getStartOffset() < dot || hl2.getStartOffset() > dot && hl2.getStartOffset() <= currentNext.getStartOffset()) {
                currentNext = hl2;
                pos = i10;
            }
            ++i10;
        }
        if (currentNext.getStartOffset() + 1 <= dot) {
            int nextIndex = ParameterizedCompletionContext.getFirstHighlight(highlights);
            currentNext = highlights.get(nextIndex);
            pos = 0;
        }
        tc2.setSelectionStart(currentNext.getStartOffset() + 1);
        tc2.setSelectionEnd(currentNext.getEndOffset());
        this.updateToolTipText(pos);
    }

    private void moveToPreviousParam() {
        JTextComponent tc2 = this.ac.getTextComponent();
        int tagCount = this.tags.size();
        if (tagCount == 0) {
            tc2.setCaretPosition(this.maxPos.getOffset());
            this.deactivate();
        }
        int dot = tc2.getCaretPosition();
        int selStart = tc2.getSelectionStart() - 1;
        Highlighter.Highlight currentPrev = null;
        int pos = 0;
        List<Highlighter.Highlight> highlights = this.getParameterHighlights();
        int i10 = 0;
        while (i10 < highlights.size()) {
            Highlighter.Highlight h10 = highlights.get(i10);
            if (currentPrev == null || currentPrev.getStartOffset() >= dot || h10.getStartOffset() < selStart && (h10.getStartOffset() > currentPrev.getStartOffset() || pos == this.lastSelectedParam)) {
                currentPrev = h10;
                pos = i10;
            }
            ++i10;
        }
        int firstIndex = ParameterizedCompletionContext.getFirstHighlight(highlights);
        if (pos == firstIndex && this.lastSelectedParam == firstIndex && highlights.size() > 1) {
            pos = ParameterizedCompletionContext.getLastHighlight(highlights);
            currentPrev = highlights.get(pos);
            tc2.setSelectionStart(currentPrev.getStartOffset() + 1);
            tc2.setSelectionEnd(currentPrev.getEndOffset());
            this.updateToolTipText(pos);
        } else if (currentPrev != null && dot > currentPrev.getStartOffset()) {
            tc2.setSelectionStart(currentPrev.getStartOffset() + 1);
            tc2.setSelectionEnd(currentPrev.getEndOffset());
            this.updateToolTipText(pos);
        } else {
            tc2.setCaretPosition(this.maxPos.getOffset());
            this.deactivate();
        }
    }

    private void possiblyUpdateParamCopies(Document doc) {
        int index = this.getCurrentParameterIndex();
        if (index > -1 && index < this.pc.getParamCount()) {
            ParameterizedCompletion.Parameter param = this.pc.getParam(index);
            if (param.isEndParam()) {
                this.deactivate();
                return;
            }
            List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
            Highlighter.Highlight h10 = paramHighlights.get(index);
            int start = h10.getStartOffset() + 1;
            int len = h10.getEndOffset() - start;
            String replacement = null;
            try {
                replacement = doc.getText(start, len);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            for (ParamCopyInfo pci : this.paramCopyInfos) {
                if (!pci.paramName.equals(param.getName())) continue;
                pci.h = this.replaceHighlightedText(doc, pci.h, replacement);
            }
        } else {
            this.deactivate();
        }
    }

    private void prepareParamChoicesWindow() {
        if (this.paramChoicesWindow != null) {
            int offs = this.getCurrentParameterStartOffset();
            if (offs == -1) {
                this.paramChoicesWindow.setVisible(false);
                return;
            }
            JTextComponent tc2 = this.ac.getTextComponent();
            try {
                Rectangle r10 = tc2.modelToView(offs);
                Point p10 = new Point(r10.x, r10.y);
                SwingUtilities.convertPointToScreen(p10, tc2);
                r10.x = p10.x;
                r10.y = p10.y;
                this.paramChoicesWindow.setLocationRelativeTo(r10);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(tc2);
                ble.printStackTrace();
            }
            this.paramChoicesWindow.setParameter(this.lastSelectedParam, this.paramPrefix);
        }
    }

    private void removeParameterHighlights() {
        JTextComponent tc2 = this.ac.getTextComponent();
        Highlighter h10 = tc2.getHighlighter();
        int i10 = 0;
        while (i10 < this.tags.size()) {
            h10.removeHighlight(this.tags.get(i10));
            ++i10;
        }
        this.tags.clear();
        for (ParamCopyInfo pci : this.paramCopyInfos) {
            h10.removeHighlight(pci.h);
        }
        this.paramCopyInfos.clear();
    }

    private Highlighter.Highlight replaceHighlightedText(Document doc, Highlighter.Highlight h10, String replacement) {
        try {
            int start = h10.getStartOffset();
            int len = h10.getEndOffset() - start;
            Highlighter highlighter = this.ac.getTextComponent().getHighlighter();
            highlighter.removeHighlight(h10);
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).replace(start, len, replacement, null);
            } else {
                doc.remove(start, len);
                doc.insertString(start, replacement, null);
            }
            int newEnd = start + replacement.length();
            h10 = (Highlighter.Highlight)highlighter.addHighlight(start, newEnd, this.paramCopyP);
            return h10;
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return null;
        }
    }

    private void uninstallKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("CompletionContext Uninstalling keybindings");
        }
        JTextComponent tc2 = this.ac.getTextComponent();
        InputMap im2 = tc2.getInputMap();
        ActionMap am10 = tc2.getActionMap();
        KeyStroke ks2 = KeyStroke.getKeyStroke(9, 0);
        im2.put(ks2, this.oldTabKey);
        am10.put(IM_KEY_TAB, this.oldTabAction);
        ks2 = KeyStroke.getKeyStroke(9, 1);
        im2.put(ks2, this.oldShiftTabKey);
        am10.put(IM_KEY_SHIFT_TAB, this.oldShiftTabAction);
        ks2 = KeyStroke.getKeyStroke(38, 0);
        im2.put(ks2, this.oldUpKey);
        am10.put(IM_KEY_UP, this.oldUpAction);
        ks2 = KeyStroke.getKeyStroke(40, 0);
        im2.put(ks2, this.oldDownKey);
        am10.put(IM_KEY_DOWN, this.oldDownAction);
        ks2 = KeyStroke.getKeyStroke(10, 0);
        im2.put(ks2, this.oldEnterKey);
        am10.put(IM_KEY_ENTER, this.oldEnterAction);
        ks2 = KeyStroke.getKeyStroke(27, 0);
        im2.put(ks2, this.oldEscapeKey);
        am10.put(IM_KEY_ESCAPE, this.oldEscapeAction);
        char end = this.pc.getProvider().getParameterListEnd();
        ks2 = KeyStroke.getKeyStroke(end);
        im2.put(ks2, this.oldClosingKey);
        am10.put(IM_KEY_CLOSING, this.oldClosingAction);
    }

    private String updateToolTipText() {
        JTextComponent tc2 = this.ac.getTextComponent();
        int dot = tc2.getSelectionStart();
        int mark = tc2.getSelectionEnd();
        int index = -1;
        String paramPrefix = null;
        List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
        int i10 = 0;
        while (i10 < paramHighlights.size()) {
            Highlighter.Highlight h10 = paramHighlights.get(i10);
            int start = h10.getStartOffset() + 1;
            if (dot >= start && dot <= h10.getEndOffset()) {
                try {
                    if (dot != start || mark != h10.getEndOffset()) {
                        paramPrefix = tc2.getText(start, dot - start);
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                index = i10;
                break;
            }
            ++i10;
        }
        this.updateToolTipText(index);
        return paramPrefix;
    }

    private void updateToolTipText(int selectedParam) {
        if (selectedParam != this.lastSelectedParam) {
            if (this.tip != null) {
                this.tip.updateText(selectedParam);
            }
            this.lastSelectedParam = selectedParam;
        }
    }

    public void updateUI() {
        if (this.tip != null) {
            this.tip.updateUI();
        }
        if (this.paramChoicesWindow != null) {
            this.paramChoicesWindow.updateUI();
        }
    }

    private class ClosingAction
    extends AbstractAction {
        private ClosingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            JTextComponent tc2 = ParameterizedCompletionContext.this.ac.getTextComponent();
            int dot = tc2.getCaretPosition();
            char end = ParameterizedCompletionContext.this.pc.getProvider().getParameterListEnd();
            if (dot >= ParameterizedCompletionContext.this.maxPos.getOffset() - 2) {
                int endCount;
                char start;
                int startCount;
                String text = ParameterizedCompletionContext.this.getArgumentText(dot);
                if (text != null && (startCount = this.getCount(text, start = ParameterizedCompletionContext.this.pc.getProvider().getParameterListStart())) > (endCount = this.getCount(text, end))) {
                    tc2.replaceSelection(Character.toString(end));
                    return;
                }
                tc2.setCaretPosition(Math.min(tc2.getCaretPosition() + 1, tc2.getDocument().getLength()));
                ParameterizedCompletionContext.this.deactivate();
            } else {
                tc2.replaceSelection(Character.toString(end));
            }
        }

        public int getCount(String text, char ch2) {
            int count = 0;
            int old = 0;
            int pos = 0;
            while ((pos = text.indexOf(ch2, old)) > -1) {
                ++count;
                old = pos + 1;
            }
            return count;
        }
    }

    private class GotoEndAction
    extends AbstractAction {
        private GotoEndAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (ParameterizedCompletionContext.this.paramChoicesWindow != null && ParameterizedCompletionContext.this.paramChoicesWindow.isVisible() && ParameterizedCompletionContext.this.insertSelectedChoice()) {
                return;
            }
            ParameterizedCompletionContext.this.deactivate();
            JTextComponent tc2 = ParameterizedCompletionContext.this.ac.getTextComponent();
            int dot = tc2.getCaretPosition();
            if (dot != ParameterizedCompletionContext.this.defaultEndOffs.getOffset()) {
                tc2.setCaretPosition(ParameterizedCompletionContext.this.defaultEndOffs.getOffset());
            } else {
                Action a10 = this.getDefaultEnterAction(tc2);
                if (a10 != null) {
                    a10.actionPerformed(e10);
                } else {
                    tc2.replaceSelection("\n");
                }
            }
        }

        private Action getDefaultEnterAction(JTextComponent tc2) {
            ActionMap am10 = tc2.getActionMap();
            return am10.get("insert-break");
        }
    }

    private class HideAction
    extends AbstractAction {
        private HideAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (ParameterizedCompletionContext.this.paramChoicesWindow != null && ParameterizedCompletionContext.this.paramChoicesWindow.isVisible()) {
                ParameterizedCompletionContext.this.paramChoicesWindow.setVisible(false);
                ParameterizedCompletionContext.this.paramChoicesWindow = null;
            } else {
                ParameterizedCompletionContext.this.deactivate();
            }
        }
    }

    private class Listener
    implements FocusListener,
    CaretListener,
    DocumentListener {
        private boolean markOccurrencesEnabled;

        private Listener() {
        }

        @Override
        public void caretUpdate(CaretEvent e10) {
            if (ParameterizedCompletionContext.this.maxPos == null) {
                ParameterizedCompletionContext.this.deactivate();
                return;
            }
            int dot = e10.getDot();
            if (dot < ParameterizedCompletionContext.this.minPos || dot > ParameterizedCompletionContext.this.maxPos.getOffset()) {
                ParameterizedCompletionContext.this.deactivate();
                return;
            }
            ParameterizedCompletionContext.this.paramPrefix = ParameterizedCompletionContext.this.updateToolTipText();
            if (ParameterizedCompletionContext.this.active) {
                ParameterizedCompletionContext.this.prepareParamChoicesWindow();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e10) {
        }

        @Override
        public void focusGained(FocusEvent e10) {
        }

        @Override
        public void focusLost(FocusEvent e10) {
            ParameterizedCompletionContext.this.deactivate();
        }

        private void handleDocumentEvent(final DocumentEvent e10) {
            if (!ParameterizedCompletionContext.this.ignoringDocumentEvents) {
                ParameterizedCompletionContext.this.ignoringDocumentEvents = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ParameterizedCompletionContext.this.possiblyUpdateParamCopies(e10.getDocument());
                        ParameterizedCompletionContext.this.ignoringDocumentEvents = false;
                    }
                });
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e10) {
            this.handleDocumentEvent(e10);
        }

        public void install(JTextComponent tc2) {
            boolean replaceTabs = false;
            if (tc2 instanceof RSyntaxTextArea) {
                RSyntaxTextArea textArea = (RSyntaxTextArea)tc2;
                this.markOccurrencesEnabled = textArea.getMarkOccurrences();
                textArea.setMarkOccurrences(false);
                replaceTabs = textArea.getTabsEmulated();
            }
            Highlighter h10 = tc2.getHighlighter();
            try {
                ParameterizedCompletionInsertionInfo info = ParameterizedCompletionContext.this.pc.getInsertionInfo(tc2, replaceTabs);
                tc2.replaceSelection(info.getTextToInsert());
                int replacementCount = info.getReplacementCount();
                int i10 = 0;
                while (i10 < replacementCount) {
                    DocumentRange dr2 = info.getReplacementLocation(i10);
                    Highlighter.HighlightPainter painter = i10 < replacementCount - 1 ? ParameterizedCompletionContext.this.p : ParameterizedCompletionContext.this.endingP;
                    ParameterizedCompletionContext.this.tags.add(h10.addHighlight(dr2.getStartOffset() - 1, dr2.getEndOffset(), painter));
                    ++i10;
                }
                i10 = 0;
                while (i10 < info.getReplacementCopyCount()) {
                    ParameterizedCompletionInsertionInfo.ReplacementCopy rc2 = info.getReplacementCopy(i10);
                    ParameterizedCompletionContext.this.paramCopyInfos.add(new ParamCopyInfo(rc2.getId(), (Highlighter.Highlight)h10.addHighlight(rc2.getStart(), rc2.getEnd(), ParameterizedCompletionContext.this.paramCopyP)));
                    ++i10;
                }
                tc2.setCaretPosition(info.getSelectionStart());
                if (info.hasSelection()) {
                    tc2.moveCaretPosition(info.getSelectionEnd());
                }
                ParameterizedCompletionContext.this.minPos = info.getMinOffset();
                ParameterizedCompletionContext.this.maxPos = info.getMaxOffset();
                try {
                    Document doc = tc2.getDocument();
                    if (ParameterizedCompletionContext.this.maxPos.getOffset() == 0) {
                        ParameterizedCompletionContext.this.maxPos = doc.createPosition(info.getTextToInsert().length());
                    }
                    ParameterizedCompletionContext.this.defaultEndOffs = doc.createPosition(info.getDefaultEndOffs());
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                tc2.getDocument().addDocumentListener(this);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            tc2.addCaretListener(this);
            tc2.addFocusListener(this);
            ParameterizedCompletionContext.this.installKeyBindings();
        }

        @Override
        public void removeUpdate(DocumentEvent e10) {
            this.handleDocumentEvent(e10);
        }

        public void uninstall() {
            JTextComponent tc2 = ParameterizedCompletionContext.this.ac.getTextComponent();
            tc2.removeCaretListener(this);
            tc2.removeFocusListener(this);
            tc2.getDocument().removeDocumentListener(this);
            ParameterizedCompletionContext.this.uninstallKeyBindings();
            if (this.markOccurrencesEnabled) {
                ((RSyntaxTextArea)tc2).setMarkOccurrences(this.markOccurrencesEnabled);
            }
            ParameterizedCompletionContext.this.maxPos = null;
            ParameterizedCompletionContext.this.minPos = -1;
            ParameterizedCompletionContext.this.removeParameterHighlights();
        }
    }

    private class NextChoiceAction
    extends AbstractAction {
        private Action oldAction;
        private int amount;

        public NextChoiceAction(int amount, Action oldAction) {
            this.amount = amount;
            this.oldAction = oldAction;
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            if (ParameterizedCompletionContext.this.paramChoicesWindow != null && ParameterizedCompletionContext.this.paramChoicesWindow.isVisible()) {
                ParameterizedCompletionContext.this.paramChoicesWindow.incSelection(this.amount);
            } else if (this.oldAction != null) {
                this.oldAction.actionPerformed(e10);
            } else {
                ParameterizedCompletionContext.this.deactivate();
            }
        }
    }

    private class NextParamAction
    extends AbstractAction {
        private NextParamAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            ParameterizedCompletionContext.this.moveToNextParam();
        }
    }

    private static class ParamCopyInfo {
        private String paramName;
        private Highlighter.Highlight h;

        public ParamCopyInfo(String paramName, Highlighter.Highlight h10) {
            this.paramName = paramName;
            this.h = h10;
        }
    }

    private class PrevParamAction
    extends AbstractAction {
        private PrevParamAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            ParameterizedCompletionContext.this.moveToPreviousParam();
        }
    }
}

