/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessControlException;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class Util {
    public static final String PROPERTY_DONT_USE_SUBSTANCE_RENDERERS = "org.fife.ui.autocomplete.DontUseSubstanceRenderers";
    public static final String PROPERTY_ALLOW_DECORATED_AUTOCOMPLETE_WINDOWS = "org.fife.ui.autocomplete.allowDecoratedAutoCompleteWindows";
    private static final Color LIGHT_HYPERLINK_FG = new Color(0xD8FFFF);
    private static final Pattern TAG_PATTERN = Pattern.compile("<[^>]*>");
    private static final boolean useSubstanceRenderers;
    private static boolean desktopCreationAttempted;
    private static Object desktop;
    private static final Object LOCK_DESKTOP_CREATION;

    static {
        LOCK_DESKTOP_CREATION = new Object();
        boolean use = true;
        try {
            use = !Boolean.getBoolean(PROPERTY_DONT_USE_SUBSTANCE_RENDERERS);
        }
        catch (AccessControlException ace2) {
            use = true;
        }
        useSubstanceRenderers = use;
    }

    public static boolean browse(URI uri) {
        Object desktop;
        boolean success = false;
        if (uri != null && (desktop = Util.getDesktop()) != null) {
            try {
                Method m10 = desktop.getClass().getDeclaredMethod("browse", URI.class);
                m10.invoke(desktop, uri);
                success = true;
            }
            catch (RuntimeException re2) {
                throw re2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getDesktop() {
        Object object = LOCK_DESKTOP_CREATION;
        synchronized (object) {
            if (!desktopCreationAttempted) {
                desktopCreationAttempted = true;
                try {
                    Class<?> desktopClazz = Class.forName("java.awt.Desktop");
                    Method m10 = desktopClazz.getDeclaredMethod("isDesktopSupported", new Class[0]);
                    boolean supported = (Boolean)m10.invoke(null, new Object[0]);
                    if (supported) {
                        m10 = desktopClazz.getDeclaredMethod("getDesktop", new Class[0]);
                        desktop = m10.invoke(null, new Object[0]);
                    }
                }
                catch (RuntimeException re2) {
                    throw re2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return desktop;
    }

    public static String getHexString(Color c10) {
        if (c10 == null) {
            return null;
        }
        StringBuilder sb2 = new StringBuilder("#");
        int r10 = c10.getRed();
        if (r10 < 16) {
            sb2.append('0');
        }
        sb2.append(Integer.toHexString(r10));
        int g10 = c10.getGreen();
        if (g10 < 16) {
            sb2.append('0');
        }
        sb2.append(Integer.toHexString(g10));
        int b10 = c10.getBlue();
        if (b10 < 16) {
            sb2.append('0');
        }
        sb2.append(Integer.toHexString(b10));
        return sb2.toString();
    }

    static final Color getHyperlinkForeground() {
        Color fg2 = UIManager.getColor("Label.foreground");
        if (fg2 == null) {
            fg2 = new JLabel().getForeground();
        }
        return Util.isLightForeground(fg2) ? LIGHT_HYPERLINK_FG : Color.blue;
    }

    public static Rectangle getScreenBoundsForPoint(int x10, int y10) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        int i10 = 0;
        while (i10 < devices.length) {
            GraphicsConfiguration config = devices[i10].getDefaultConfiguration();
            Rectangle gcBounds = config.getBounds();
            if (gcBounds.contains(x10, y10)) {
                return gcBounds;
            }
            ++i10;
        }
        return env.getMaximumWindowBounds();
    }

    public static boolean getShouldAllowDecoratingMainAutoCompleteWindows() {
        try {
            return Boolean.getBoolean(PROPERTY_ALLOW_DECORATED_AUTOCOMPLETE_WINDOWS);
        }
        catch (AccessControlException ace2) {
            return false;
        }
    }

    public static boolean getUseSubstanceRenderers() {
        return useSubstanceRenderers;
    }

    public static final boolean isLightForeground(Color fg2) {
        return fg2.getRed() > 160 && fg2.getGreen() > 160 && fg2.getBlue() > 160;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        int prefixLength = prefix.length();
        if (str.length() >= prefixLength) {
            return str.regionMatches(true, 0, prefix, 0, prefixLength);
        }
        return false;
    }

    public static String stripHtml(String text) {
        if (text == null || !text.startsWith("<html>")) {
            return text;
        }
        return TAG_PATTERN.matcher(text).replaceAll("");
    }
}

