/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.CompletionProvider;

public class VariableCompletion
extends BasicCompletion {
    private String type;
    private String definedIn;

    public VariableCompletion(CompletionProvider provider, String name, String type) {
        super(provider, name);
        this.type = type;
    }

    protected void addDefinitionString(StringBuilder sb2) {
        sb2.append("<html><b>").append(this.getDefinitionString()).append("</b>");
    }

    public String getDefinitionString() {
        StringBuilder sb2 = new StringBuilder();
        if (this.type != null) {
            sb2.append(this.type).append(' ');
        }
        sb2.append(this.getName());
        return sb2.toString();
    }

    public String getDefinedIn() {
        return this.definedIn;
    }

    public String getName() {
        return this.getReplacementText();
    }

    @Override
    public String getSummary() {
        StringBuilder sb2 = new StringBuilder();
        this.addDefinitionString(sb2);
        this.possiblyAddDescription(sb2);
        this.possiblyAddDefinedIn(sb2);
        return sb2.toString();
    }

    @Override
    public String getToolTipText() {
        return this.getDefinitionString();
    }

    public String getType() {
        return this.type;
    }

    protected void possiblyAddDefinedIn(StringBuilder sb2) {
        if (this.definedIn != null) {
            sb2.append("<hr>Defined in:");
            sb2.append(" <em>").append(this.definedIn).append("</em>");
        }
    }

    protected boolean possiblyAddDescription(StringBuilder sb2) {
        if (this.getShortDescription() != null) {
            sb2.append("<hr><br>");
            sb2.append(this.getShortDescription());
            sb2.append("<br><br><br>");
            return true;
        }
        return false;
    }

    public void setDefinedIn(String definedIn) {
        this.definedIn = definedIn;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

