/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.AbstractJFlexTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;

public abstract class AbstractJFlexCTokenMaker
extends AbstractJFlexTokenMaker {
    private final Action INSERT_BREAK_ACTION = this.createInsertBreakAction();
    private static final Pattern MLC_PATTERN = Pattern.compile("([ \\t]*)(/?[\\*]+)([ \\t]*)");

    protected AbstractJFlexCTokenMaker() {
    }

    protected Action createInsertBreakAction() {
        return new CStyleInsertBreakAction();
    }

    @Override
    public boolean getCurlyBracesDenoteCodeBlocks(int languageIndex) {
        return true;
    }

    @Override
    public Action getInsertBreakAction() {
        return this.INSERT_BREAK_ACTION;
    }

    @Override
    public boolean getMarkOccurrencesOfTokenType(int type) {
        return type == 20 || type == 8;
    }

    @Override
    public boolean getShouldIndentNextLineAfter(Token t10) {
        if (t10 != null && t10.length() == 1) {
            char ch2 = t10.charAt(0);
            return ch2 == '{' || ch2 == '(';
        }
        return false;
    }

    private boolean isInternalEolTokenForMLCs(Token t10) {
        int type = t10.getType();
        if (type < 0) {
            return (type = this.getClosestStandardTokenTypeForInternalType(type)) == 2 || type == 3;
        }
        return false;
    }

    protected class CStyleInsertBreakAction
    extends RSyntaxTextAreaEditorKit.InsertBreakAction {
        protected CStyleInsertBreakAction() {
        }

        @Override
        public void actionPerformedImpl(ActionEvent e10, RTextArea textArea) {
            int line;
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            RSyntaxTextArea rsta = (RSyntaxTextArea)this.getTextComponent(e10);
            RSyntaxDocument doc = (RSyntaxDocument)rsta.getDocument();
            int type = doc.getLastTokenTypeOnLine(line = textArea.getCaretLineNumber());
            if (type < 0) {
                type = doc.getClosestStandardTokenTypeForInternalType(type);
            }
            if (type == 3 || type == 2) {
                this.insertBreakInMLC(e10, rsta, line);
            } else {
                this.handleInsertBreak(rsta, true);
            }
        }

        private boolean appearsNested(RSyntaxTextArea textArea, int line, int offs) {
            int firstLine = line;
            while (line < textArea.getLineCount()) {
                Token t10 = textArea.getTokenListForLine(line);
                int i10 = 0;
                if (line++ == firstLine) {
                    if ((t10 = RSyntaxUtilities.getTokenAtOffset(t10, offs)) == null) continue;
                    i10 = t10.documentToToken(offs);
                } else {
                    i10 = t10.getTextOffset();
                }
                int textOffset = t10.getTextOffset();
                while (i10 < textOffset + t10.length() - 1) {
                    if (t10.charAt(i10 - textOffset) == '/' && t10.charAt(i10 - textOffset + 1) == '*') {
                        return true;
                    }
                    ++i10;
                }
                if ((t10 = t10.getNextToken()) == null || AbstractJFlexCTokenMaker.this.isInternalEolTokenForMLCs(t10)) continue;
                return false;
            }
            return true;
        }

        private void insertBreakInMLC(ActionEvent e10, RSyntaxTextArea textArea, int line) {
            Matcher m10 = null;
            int start = -1;
            int end = -1;
            String text = null;
            try {
                start = textArea.getLineStartOffset(line);
                end = textArea.getLineEndOffset(line);
                text = textArea.getText(start, end - start);
                m10 = MLC_PATTERN.matcher(text);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                ble.printStackTrace();
                return;
            }
            if (m10.lookingAt()) {
                String leadingWS = m10.group(1);
                String mlcMarker = m10.group(2);
                int dot = textArea.getCaretPosition();
                if (dot >= start && dot < start + leadingWS.length() + mlcMarker.length()) {
                    if (mlcMarker.charAt(0) == '/') {
                        this.handleInsertBreak(textArea, true);
                        return;
                    }
                    textArea.setCaretPosition(end - 1);
                } else {
                    boolean moved = false;
                    while (dot < end - 1 && Character.isWhitespace(text.charAt(dot - start))) {
                        moved = true;
                        ++dot;
                    }
                    if (moved) {
                        textArea.setCaretPosition(dot);
                    }
                }
                boolean firstMlcLine = mlcMarker.charAt(0) == '/';
                boolean nested = this.appearsNested(textArea, line, start + leadingWS.length() + 2);
                String header = String.valueOf(leadingWS) + (firstMlcLine ? " * " : "*") + m10.group(3);
                textArea.replaceSelection("\n" + header);
                if (nested) {
                    dot = textArea.getCaretPosition();
                    textArea.insert("\n" + leadingWS + " */", dot);
                    textArea.setCaretPosition(dot);
                }
            } else {
                this.handleInsertBreak(textArea, true);
            }
        }
    }
}

