/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.templates.CodeTemplate;

public class CodeTemplateManager {
    private int maxTemplateIDLength;
    private List<CodeTemplate> templates;
    private Segment s = new Segment();
    private TemplateComparator comparator = new TemplateComparator();
    private File directory;

    public CodeTemplateManager() {
        this.templates = new ArrayList<CodeTemplate>();
    }

    public synchronized void addTemplate(CodeTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        this.templates.add(template);
        this.sortTemplates();
    }

    public synchronized CodeTemplate getTemplate(RSyntaxTextArea textArea) {
        int caretPos = textArea.getCaretPosition();
        int charsToGet = Math.min(caretPos, this.maxTemplateIDLength);
        try {
            Document doc = textArea.getDocument();
            doc.getText(caretPos - charsToGet, charsToGet, this.s);
            int index = Collections.binarySearch(this.templates, this.s, this.comparator);
            return index >= 0 ? this.templates.get(index) : null;
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            throw new InternalError("Error in CodeTemplateManager");
        }
    }

    private synchronized int getTemplateCount() {
        return this.templates.size();
    }

    public synchronized CodeTemplate[] getTemplates() {
        CodeTemplate[] temp = new CodeTemplate[this.templates.size()];
        return this.templates.toArray(temp);
    }

    private static boolean isValidChar(char ch2) {
        return RSyntaxUtilities.isLetterOrDigit(ch2) || ch2 == '_';
    }

    public synchronized boolean removeTemplate(CodeTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        return this.templates.remove(template);
    }

    public synchronized CodeTemplate removeTemplate(String id2) {
        if (id2 == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        Iterator<CodeTemplate> i10 = this.templates.iterator();
        while (i10.hasNext()) {
            CodeTemplate template = i10.next();
            if (!id2.equals(template.getID())) continue;
            i10.remove();
            return template;
        }
        return null;
    }

    public synchronized void replaceTemplates(CodeTemplate[] newTemplates) {
        this.templates.clear();
        if (newTemplates != null) {
            Collections.addAll(this.templates, newTemplates);
        }
        this.sortTemplates();
    }

    public synchronized boolean saveTemplates() {
        if (this.templates == null) {
            return true;
        }
        if (this.directory == null || !this.directory.isDirectory()) {
            return false;
        }
        File[] oldXMLFiles = this.directory.listFiles(new XMLFileFilter());
        if (oldXMLFiles == null) {
            return false;
        }
        int count = oldXMLFiles.length;
        File[] fileArray = oldXMLFiles;
        int n10 = oldXMLFiles.length;
        int n11 = 0;
        while (n11 < n10) {
            File oldXMLFile = fileArray[n11];
            oldXMLFile.delete();
            ++n11;
        }
        boolean wasSuccessful = true;
        for (CodeTemplate template : this.templates) {
            File xmlFile = new File(this.directory, String.valueOf(template.getID()) + ".xml");
            try {
                XMLEncoder e10 = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(xmlFile)));
                e10.writeObject(template);
                e10.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                wasSuccessful = false;
            }
        }
        return wasSuccessful;
    }

    public synchronized int setTemplateDirectory(File dir) {
        if (dir != null && dir.isDirectory()) {
            this.directory = dir;
            File[] files = dir.listFiles(new XMLFileFilter());
            int newCount = files == null ? 0 : files.length;
            int oldCount = this.templates.size();
            ArrayList<CodeTemplate> temp = new ArrayList<CodeTemplate>(oldCount + newCount);
            temp.addAll(this.templates);
            int i10 = 0;
            while (i10 < newCount) {
                try {
                    XMLDecoder d10 = new XMLDecoder(new BufferedInputStream(new FileInputStream(files[i10])));
                    Object obj = d10.readObject();
                    if (!(obj instanceof CodeTemplate)) {
                        d10.close();
                        throw new IOException("Not a CodeTemplate: " + files[i10].getAbsolutePath());
                    }
                    temp.add((CodeTemplate)obj);
                    d10.close();
                }
                catch (Exception e10) {
                    e10.printStackTrace();
                }
                ++i10;
            }
            this.templates = temp;
            this.sortTemplates();
            return this.getTemplateCount();
        }
        return -1;
    }

    private synchronized void sortTemplates() {
        this.maxTemplateIDLength = 0;
        Iterator<CodeTemplate> i10 = this.templates.iterator();
        while (i10.hasNext()) {
            CodeTemplate temp = i10.next();
            if (temp == null || temp.getID() == null) {
                i10.remove();
                continue;
            }
            this.maxTemplateIDLength = Math.max(this.maxTemplateIDLength, temp.getID().length());
        }
        Collections.sort(this.templates);
    }

    private static class TemplateComparator
    implements Comparator<Object>,
    Serializable {
        private TemplateComparator() {
        }

        @Override
        public int compare(Object template, Object segment) {
            CodeTemplate t10 = (CodeTemplate)template;
            char[] templateArray = t10.getID().toCharArray();
            int i10 = 0;
            int len1 = templateArray.length;
            Segment s10 = (Segment)segment;
            char[] segArray = s10.array;
            int len2 = s10.count;
            int j10 = s10.offset + len2 - 1;
            while (j10 >= s10.offset && CodeTemplateManager.isValidChar(segArray[j10])) {
                --j10;
            }
            int segShift = ++j10 - s10.offset;
            int n10 = Math.min(len1, len2 -= segShift);
            while (n10-- != 0) {
                char c22;
                char c12;
                if ((c12 = templateArray[i10++]) == (c22 = segArray[j10++])) continue;
                return c12 - c22;
            }
            return len1 - len2;
        }
    }

    private static class XMLFileFilter
    implements FileFilter {
        private XMLFileFilter() {
        }

        @Override
        public boolean accept(File f10) {
            return f10.getName().toLowerCase().endsWith(".xml");
        }
    }
}

