/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

class DefaultOccurrenceMarker
implements OccurrenceMarker {
    DefaultOccurrenceMarker() {
    }

    @Override
    public Token getTokenToMark(RSyntaxTextArea textArea) {
        Caret c10;
        int dot;
        int line = textArea.getCaretLineNumber();
        Token tokenList = textArea.getTokenListForLine(line);
        Token t10 = RSyntaxUtilities.getTokenAtOffset(tokenList, dot = (c10 = textArea.getCaret()).getDot());
        if (t10 == null || !this.isValidType(textArea, t10) || RSyntaxUtilities.isNonWordChar(t10)) {
            --dot;
            try {
                if (dot >= textArea.getLineStartOffset(line)) {
                    t10 = RSyntaxUtilities.getTokenAtOffset(tokenList, dot);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        return t10;
    }

    @Override
    public boolean isValidType(RSyntaxTextArea textArea, Token t10) {
        return textArea.getMarkOccurrencesOfTokenType(t10.getType());
    }

    @Override
    public void markOccurrences(RSyntaxDocument doc, Token t10, RSyntaxTextAreaHighlighter h10, SmartHighlightPainter p10) {
        DefaultOccurrenceMarker.markOccurrencesOfToken(doc, t10, h10, p10);
    }

    public static void markOccurrencesOfToken(RSyntaxDocument doc, Token t10, RSyntaxTextAreaHighlighter h10, SmartHighlightPainter p10) {
        char[] lexeme = t10.getLexeme().toCharArray();
        int type = t10.getType();
        int lineCount = doc.getDefaultRootElement().getElementCount();
        int i10 = 0;
        while (i10 < lineCount) {
            Token temp = doc.getTokenListForLine(i10);
            while (temp != null && temp.isPaintable()) {
                if (temp.is(type, lexeme)) {
                    try {
                        int end = temp.getEndOffset();
                        h10.addMarkedOccurrenceHighlight(temp.getOffset(), end, p10);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                }
                temp = temp.getNextToken();
            }
            ++i10;
        }
    }
}

