/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenPainter;

class DefaultTokenPainter
implements TokenPainter {
    private Rectangle2D.Float bgRect = new Rectangle2D.Float();
    private static char[] tabBuf;

    DefaultTokenPainter() {
    }

    @Override
    public final float paint(Token token, Graphics2D g10, float x10, float y10, RSyntaxTextArea host, TabExpander e10) {
        return this.paint(token, g10, x10, y10, host, e10, 0.0f);
    }

    @Override
    public float paint(Token token, Graphics2D g10, float x10, float y10, RSyntaxTextArea host, TabExpander e10, float clipStart) {
        return this.paintImpl(token, g10, x10, y10, host, e10, clipStart, false, false);
    }

    @Override
    public float paint(Token token, Graphics2D g10, float x10, float y10, RSyntaxTextArea host, TabExpander e10, float clipStart, boolean paintBG) {
        return this.paintImpl(token, g10, x10, y10, host, e10, clipStart, !paintBG, false);
    }

    protected void paintBackground(float x10, float y10, float width, float height, Graphics2D g10, int fontAscent, RSyntaxTextArea host, Color color) {
        g10.setColor(color);
        this.bgRect.setRect(x10, y10 - (float)fontAscent, width, height);
        g10.fillRect((int)x10, (int)(y10 - (float)fontAscent), (int)width, (int)height);
    }

    protected float paintImpl(Token token, Graphics2D g10, float x10, float y10, RSyntaxTextArea host, TabExpander e10, float clipStart, boolean selected, boolean useSTC) {
        int origX = (int)x10;
        int textOffs = token.getTextOffset();
        char[] text = token.getTextArray();
        int end = textOffs + token.length();
        float nextX = x10;
        int flushLen = 0;
        int flushIndex = textOffs;
        Color fg2 = useSTC ? host.getSelectedTextColor() : host.getForegroundForToken(token);
        Color bg2 = selected ? null : host.getBackgroundForToken(token);
        g10.setFont(host.getFontForTokenType(token.getType()));
        FontMetrics fm2 = host.getFontMetricsForTokenType(token.getType());
        int i10 = textOffs;
        while (i10 < end) {
            switch (text[i10]) {
                case '\t': {
                    nextX = e10.nextTabStop(x10 + (float)fm2.charsWidth(text, flushIndex, flushLen), 0);
                    if (bg2 != null) {
                        this.paintBackground(x10, y10, nextX - x10, fm2.getHeight(), g10, fm2.getAscent(), host, bg2);
                    }
                    if (flushLen > 0) {
                        g10.setColor(fg2);
                        g10.drawChars(text, flushIndex, flushLen, (int)x10, (int)y10);
                        flushLen = 0;
                    }
                    flushIndex = i10 + 1;
                    x10 = nextX;
                    break;
                }
                default: {
                    ++flushLen;
                }
            }
            ++i10;
        }
        nextX = x10 + (float)fm2.charsWidth(text, flushIndex, flushLen);
        Rectangle r10 = host.getMatchRectangle();
        if (flushLen > 0 && nextX >= clipStart) {
            if (bg2 != null) {
                this.paintBackground(x10, y10, nextX - x10, fm2.getHeight(), g10, fm2.getAscent(), host, bg2);
                if (token.length() == 1 && r10 != null && (float)r10.x == x10) {
                    ((RSyntaxTextAreaUI)host.getUI()).paintMatchedBracketImpl(g10, host, r10);
                }
            }
            g10.setColor(fg2);
            g10.drawChars(text, flushIndex, flushLen, (int)x10, (int)y10);
        }
        if (host.getUnderlineForToken(token)) {
            g10.setColor(fg2);
            int y22 = (int)(y10 + 1.0f);
            g10.drawLine(origX, y22, (int)nextX, y22);
        }
        if (host.getPaintTabLines() && origX == host.getMargin().left) {
            this.paintTabLines(token, origX, (int)y10, (int)nextX, g10, e10, host);
        }
        return nextX;
    }

    @Override
    public float paintSelected(Token token, Graphics2D g10, float x10, float y10, RSyntaxTextArea host, TabExpander e10, boolean useSTC) {
        return this.paintSelected(token, g10, x10, y10, host, e10, 0.0f, useSTC);
    }

    @Override
    public float paintSelected(Token token, Graphics2D g10, float x10, float y10, RSyntaxTextArea host, TabExpander e10, float clipStart, boolean useSTC) {
        return this.paintImpl(token, g10, x10, y10, host, e10, clipStart, true, useSTC);
    }

    protected void paintTabLines(Token token, int x10, int y10, int endX, Graphics2D g10, TabExpander e10, RSyntaxTextArea host) {
        Token next;
        if (token.getType() != 21) {
            int offs = 0;
            while (offs < token.length()) {
                if (!RSyntaxUtilities.isWhitespace(token.charAt(offs))) break;
                ++offs;
            }
            if (offs < 2) {
                return;
            }
            endX = (int)token.getWidthUpTo(offs, host, e10, 0.0f);
        }
        FontMetrics fm2 = host.getFontMetricsForTokenType(token.getType());
        int tabSize = host.getTabSize();
        if (tabBuf == null || tabBuf.length < tabSize) {
            tabBuf = new char[tabSize];
            int i10 = 0;
            while (i10 < tabSize) {
                DefaultTokenPainter.tabBuf[i10] = 32;
                ++i10;
            }
        }
        int tabW = fm2.charsWidth(tabBuf, 0, tabSize);
        g10.setColor(host.getTabLineColor());
        int x02 = x10 + tabW;
        int y02 = y10 - fm2.getAscent();
        if ((y02 & 1) > 0) {
            ++y02;
        }
        if ((next = token.getNextToken()) == null || !next.isPaintable()) {
            ++endX;
        }
        while (x02 < endX) {
            int y12 = y02;
            int y22 = y02 + host.getLineHeight();
            while (y12 < y22) {
                g10.drawLine(x02, y12, x02, y12);
                y12 += 2;
            }
            x02 += tabW;
        }
    }
}

