/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.IconRowHeader;

public class FoldingAwareIconRowHeader
extends IconRowHeader {
    public FoldingAwareIconRowHeader(RSyntaxTextArea textArea) {
        super(textArea);
    }

    @Override
    protected void paintComponent(Graphics g10) {
        if (this.textArea == null) {
            return;
        }
        RSyntaxTextArea rsta = (RSyntaxTextArea)this.textArea;
        FoldManager fm2 = rsta.getFoldManager();
        if (!fm2.isCodeFoldingSupportedAndEnabled()) {
            super.paintComponent(g10);
            return;
        }
        this.visibleRect = g10.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        this.paintBackgroundImpl(g10, this.visibleRect);
        if (this.textArea.getLineWrap()) {
            this.paintComponentWrapped(g10);
            return;
        }
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        if (this.visibleRect.y < this.textAreaInsets.top) {
            this.visibleRect.height -= this.textAreaInsets.top - this.visibleRect.y;
            this.visibleRect.y = this.textAreaInsets.top;
        }
        int cellHeight = this.textArea.getLineHeight();
        int topLine = (this.visibleRect.y - this.textAreaInsets.top) / cellHeight;
        int y10 = topLine * cellHeight + this.textAreaInsets.top;
        topLine += fm2.getHiddenLineCountAbove(topLine, true);
        if (this.activeLineRangeStart > -1 && this.activeLineRangeEnd > -1) {
            Color activeLineRangeColor = this.getActiveLineRangeColor();
            g10.setColor(activeLineRangeColor);
            try {
                int realY1 = rsta.yForLine(this.activeLineRangeStart);
                if (realY1 > -1) {
                    int y12 = realY1;
                    int y22 = rsta.yForLine(this.activeLineRangeEnd);
                    if (y22 == -1) {
                        y22 = y12;
                    }
                    if ((y22 += cellHeight - 1) < this.visibleRect.y || y12 > this.visibleRect.y + this.visibleRect.height) {
                        return;
                    }
                    y12 = Math.max(y10, realY1);
                    y22 = Math.min(y22, this.visibleRect.y + this.visibleRect.height);
                    int j10 = y12;
                    while (j10 <= y22) {
                        int yEnd = Math.min(y22, j10 + this.getWidth());
                        int xEnd = yEnd - j10;
                        g10.drawLine(0, j10, xEnd, yEnd);
                        j10 += 2;
                    }
                    int i10 = 2;
                    while (i10 < this.getWidth()) {
                        int yEnd = y12 + this.getWidth() - i10;
                        g10.drawLine(i10, y12, this.getWidth(), yEnd);
                        i10 += 2;
                    }
                    if (realY1 >= y10 && realY1 < this.visibleRect.y + this.visibleRect.height) {
                        g10.drawLine(0, realY1, this.getWidth(), realY1);
                    }
                    if (y22 >= y10 && y22 < this.visibleRect.y + this.visibleRect.height) {
                        g10.drawLine(0, y22, this.getWidth(), y22);
                    }
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        if (this.trackingIcons != null) {
            int lastLine = this.textArea.getLineCount() - 1;
            int i11 = this.trackingIcons.size() - 1;
            while (i11 >= 0) {
                IconRowHeader.GutterIconImpl ti2 = this.getTrackingIcon(i11);
                int offs = ti2.getMarkedOffset();
                if (offs >= 0 && offs <= doc.getLength()) {
                    int line = root.getElementIndex(offs);
                    if (line <= lastLine && line >= topLine) {
                        try {
                            int lineY;
                            Icon icon = ti2.getIcon();
                            if (icon != null && (lineY = rsta.yForLine(line)) >= y10 && lineY <= this.visibleRect.y + this.visibleRect.height) {
                                int y23 = lineY + (cellHeight - icon.getIconHeight()) / 2;
                                icon.paintIcon(this, g10, 0, y23);
                                lastLine = line - 1;
                            }
                        }
                        catch (BadLocationException ble) {
                            ble.printStackTrace();
                        }
                    } else if (line < topLine) break;
                }
                --i11;
            }
        }
    }

    private void paintComponentWrapped(Graphics g10) {
        RSyntaxTextArea rsta = (RSyntaxTextArea)this.textArea;
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        int topPosition = this.textArea.viewToModel(new Point(this.visibleRect.x, this.visibleRect.y));
        int topLine = root.getElementIndex(topPosition);
        int topY = this.visibleRect.y;
        int bottomY = this.visibleRect.y + this.visibleRect.height;
        int cellHeight = this.textArea.getLineHeight();
        if (this.trackingIcons != null) {
            int lastLine = this.textArea.getLineCount() - 1;
            int i10 = this.trackingIcons.size() - 1;
            while (i10 >= 0) {
                IconRowHeader.GutterIconImpl ti2 = this.getTrackingIcon(i10);
                Icon icon = ti2.getIcon();
                if (icon != null) {
                    int iconH = icon.getIconHeight();
                    int offs = ti2.getMarkedOffset();
                    if (offs >= 0 && offs <= doc.getLength()) {
                        int line = root.getElementIndex(offs);
                        if (line <= lastLine && line >= topLine) {
                            try {
                                int lineY = rsta.yForLine(line);
                                if (lineY <= bottomY && lineY + iconH >= topY) {
                                    int y22 = lineY + (cellHeight - iconH) / 2;
                                    ti2.getIcon().paintIcon(this, g10, 0, y22);
                                    lastLine = line - 1;
                                }
                            }
                            catch (BadLocationException ble) {
                                ble.printStackTrace();
                            }
                        } else if (line < topLine) break;
                    }
                }
                --i10;
            }
        }
    }
}

