/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.DefaultOccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

public class HtmlOccurrenceMarker
implements OccurrenceMarker {
    private static final char[] CLOSE_TAG_START = new char[]{'<', '/'};
    private static final char[] TAG_SELF_CLOSE = new char[]{'/', '>'};
    private static final Set<String> TAGS_REQUIRING_CLOSING = HtmlOccurrenceMarker.getRequiredClosingTags();

    public static final Set<String> getRequiredClosingTags() {
        String[] tags = new String[]{"html", "head", "title", "style", "script", "noscript", "body", "section", "nav", "article", "aside", "h1", "h2", "h3", "h4", "h5", "h6", "header", "footer", "address", "pre", "dialog", "blockquote", "ol", "ul", "dl", "a", "q", "cite", "em", "strong", "small", "mark", "dfn", "abbr", "time", "progress", "meter", "code", "var", "samp", "kbd", "sub", "sup", "span", "i", "b", "bdo", "ruby", "rt", "rp", "ins", "del", "figure", "iframe", "object", "video", "audio", "canvas", "map", "table", "caption", "form", "fieldset", "label", "button", "select", "datalist", "textarea", "output", "details", "bb", "menu", "legend", "div", "acronym", "applet", "big", "blink", "center", "dir", "font", "frame", "frameset", "isindex", "listing", "marquee", "nobr", "noembed", "noframes", "plaintext", "s", "spacer", "strike", "tt", "u", "xmp"};
        return new HashSet<String>(Arrays.asList(tags));
    }

    public static final Token getTagNameTokenForCaretOffset(RSyntaxTextArea textArea, OccurrenceMarker occurrenceMarker) {
        int dot = textArea.getCaretPosition();
        Token t10 = textArea.getTokenListForLine(textArea.getCaretLineNumber());
        Token toMark = null;
        while (t10 != null && t10.isPaintable()) {
            if (t10.getType() == 26) {
                toMark = t10;
            }
            if (t10.getEndOffset() == dot || t10.containsPosition(dot)) {
                if (occurrenceMarker.isValidType(textArea, t10) && t10.getType() != 26) {
                    return t10;
                }
                if (t10.containsPosition(dot)) break;
            }
            if (t10.getType() == 25 && (t10.isSingleChar('>') || t10.is(TAG_SELF_CLOSE))) {
                toMark = null;
            }
            t10 = t10.getNextToken();
        }
        return toMark;
    }

    @Override
    public Token getTokenToMark(RSyntaxTextArea textArea) {
        return HtmlOccurrenceMarker.getTagNameTokenForCaretOffset(textArea, this);
    }

    @Override
    public boolean isValidType(RSyntaxTextArea textArea, Token t10) {
        return textArea.getMarkOccurrencesOfTokenType(t10.getType());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void markOccurrences(RSyntaxDocument doc, Token t, RSyntaxTextAreaHighlighter h, SmartHighlightPainter p) {
        block36: {
            if (t.getType() != 26) {
                DefaultOccurrenceMarker.markOccurrencesOfToken(doc, t, h, p);
                return;
            }
            lexemeStr = t.getLexeme();
            lexeme = lexemeStr.toCharArray();
            lexemeStr = lexemeStr.toLowerCase();
            tokenOffs = t.getOffset();
            root = doc.getDefaultRootElement();
            lineCount = root.getElementCount();
            curLine = root.getElementIndex(t.getOffset());
            depth = 0;
            found = false;
            forward = true;
            t = doc.getTokenListForLine(curLine);
            while (t != null && t.isPaintable()) {
                if (t.getType() == 25) {
                    if (t.isSingleChar('<') && t.getOffset() + 1 == tokenOffs) {
                        if (!HtmlOccurrenceMarker.TAGS_REQUIRING_CLOSING.contains(lexemeStr)) break;
                        found = true;
                        break;
                    }
                    if (t.is(HtmlOccurrenceMarker.CLOSE_TAG_START) && t.getOffset() + 2 == tokenOffs) {
                        found = true;
                        forward = false;
                        break;
                    }
                }
                t = t.getNextToken();
            }
            if (!found) {
                return;
            }
            if (!forward) break block36;
            t = t.getNextToken().getNextToken();
            if (true) ** GOTO lbl62
        }
        openCloses = new ArrayList<Entry>();
        inPossibleMatch = false;
        t = doc.getTokenListForLine(curLine);
        endBefore = tokenOffs - 2;
        if (true) ** GOTO lbl95
        block5: while (true) {
            if (t.getType() == 25) {
                if (t.is(HtmlOccurrenceMarker.CLOSE_TAG_START)) {
                    match = t.getNextToken();
                    if (match != null && match.is(lexeme)) {
                        if (depth > 0) {
                            --depth;
                        } else {
                            try {
                                end = match.getOffset() + match.length();
                                h.addMarkedOccurrenceHighlight(match.getOffset(), end, p);
                                end = tokenOffs + match.length();
                                h.addMarkedOccurrenceHighlight(tokenOffs, end, p);
                                return;
                            }
                            catch (BadLocationException ble) {
                                ble.printStackTrace();
                            }
                            return;
                        }
                    }
                } else if (t.isSingleChar('<') && (t = t.getNextToken()) != null && t.is(lexeme)) {
                    ++depth;
                }
            }
            v0 = t = t == null ? null : t.getNextToken();
lbl62:
            // 2 sources

            do {
                if (t != null && t.isPaintable()) continue block5;
                if (++curLine >= lineCount) continue;
                t = doc.getTokenListForLine(curLine);
            } while (curLine < lineCount);
            break;
        }
        return;
        block7: while (true) {
            if (t.getType() == 25) {
                if (t.isSingleChar('<')) {
                    next = t.getNextToken();
                    if (next != null) {
                        if (next.is(lexeme)) {
                            openCloses.add(new Entry(true, next));
                            inPossibleMatch = true;
                        } else {
                            inPossibleMatch = false;
                        }
                        t = next;
                    }
                } else if (t.isSingleChar('>')) {
                    inPossibleMatch = false;
                } else if (inPossibleMatch && t.is(HtmlOccurrenceMarker.TAG_SELF_CLOSE)) {
                    openCloses.remove(openCloses.size() - 1);
                    inPossibleMatch = false;
                } else if (t.is(HtmlOccurrenceMarker.CLOSE_TAG_START) && (next = t.getNextToken()) != null) {
                    if (next.is(lexeme)) {
                        openCloses.add(new Entry(false, next));
                    }
                    t = next;
                }
            }
            t = t.getNextToken();
lbl95:
            // 2 sources

            do {
                if (t != null && t.getOffset() < endBefore && t.isPaintable()) continue block7;
                i = openCloses.size() - 1;
                while (i >= 0) {
                    entry = (Entry)openCloses.get(i);
                    if ((depth += Entry.access$0(entry) != false ? -1 : 1) == -1) {
                        try {
                            match = Entry.access$1(entry);
                            end = match.getOffset() + match.length();
                            h.addMarkedOccurrenceHighlight(match.getOffset(), end, p);
                            end = tokenOffs + match.length();
                            h.addMarkedOccurrenceHighlight(tokenOffs, end, p);
                        }
                        catch (BadLocationException ble) {
                            ble.printStackTrace();
                        }
                        openCloses.clear();
                        return;
                    }
                    --i;
                }
                openCloses.clear();
                if (--curLine < 0) continue;
                t = doc.getTokenListForLine(curLine);
            } while (curLine >= 0);
            break;
        }
    }

    private static class Entry {
        private boolean open;
        private Token t;

        Entry(boolean open, Token t10) {
            this.open = open;
            this.t = t10;
        }

        static /* synthetic */ boolean access$0(Entry entry) {
            return entry.open;
        }

        static /* synthetic */ Token access$1(Entry entry) {
            return entry.t;
        }
    }
}

