/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenUtils;

public final class HtmlUtil {
    private HtmlUtil() {
    }

    public static String escapeForHtml(String s10, String newlineReplacement, boolean inPreBlock) {
        if (s10 == null) {
            return null;
        }
        if (newlineReplacement == null) {
            newlineReplacement = "";
        }
        String tabString = inPreBlock ? "    " : "&nbsp;&nbsp;&nbsp;&nbsp;";
        boolean lastWasSpace = false;
        StringBuilder sb2 = new StringBuilder();
        int i10 = 0;
        while (i10 < s10.length()) {
            char ch2 = s10.charAt(i10);
            switch (ch2) {
                case ' ': {
                    if (inPreBlock || !lastWasSpace) {
                        sb2.append(' ');
                    } else {
                        sb2.append("&nbsp;");
                    }
                    lastWasSpace = true;
                    break;
                }
                case '\n': {
                    sb2.append(newlineReplacement);
                    lastWasSpace = false;
                    break;
                }
                case '&': {
                    sb2.append("&amp;");
                    lastWasSpace = false;
                    break;
                }
                case '\t': {
                    sb2.append(tabString);
                    lastWasSpace = true;
                    break;
                }
                case '<': {
                    sb2.append("&lt;");
                    lastWasSpace = false;
                    break;
                }
                case '>': {
                    sb2.append("&gt;");
                    lastWasSpace = false;
                    break;
                }
                case '\'': {
                    sb2.append("&#39;");
                    lastWasSpace = false;
                    break;
                }
                case '\"': {
                    sb2.append("&#34;");
                    lastWasSpace = false;
                    break;
                }
                case '/': {
                    sb2.append("&#47;");
                    lastWasSpace = false;
                    break;
                }
                default: {
                    sb2.append(ch2);
                    lastWasSpace = false;
                }
            }
            ++i10;
        }
        return sb2.toString();
    }

    public static String getHexString(Color c10) {
        if (c10 == null) {
            return null;
        }
        StringBuilder sb2 = new StringBuilder("#");
        int r10 = c10.getRed();
        if (r10 < 16) {
            sb2.append('0');
        }
        sb2.append(Integer.toHexString(r10));
        int g10 = c10.getGreen();
        if (g10 < 16) {
            sb2.append('0');
        }
        sb2.append(Integer.toHexString(g10));
        int b10 = c10.getBlue();
        if (b10 < 16) {
            sb2.append('0');
        }
        sb2.append(Integer.toHexString(b10));
        return sb2.toString();
    }

    public static String getTextAsHtml(RSyntaxTextArea textArea, int start, int end) {
        Token token;
        StringBuilder sb2 = new StringBuilder("<pre style=\"").append("font-family: '").append(textArea.getFont().getFamily()).append("', courier;");
        if (textArea.getBackground() != null) {
            sb2.append(" background: ").append(HtmlUtil.getHexString(textArea.getBackground()));
        }
        sb2.append("\">");
        Token t10 = token = textArea.getTokenListFor(start, end);
        while (t10 != null) {
            if (t10.isPaintable()) {
                if (t10.isSingleChar('\n')) {
                    sb2.append("<br>");
                } else {
                    sb2.append(TokenUtils.tokenToHtml(textArea, t10));
                }
            }
            t10 = t10.getNextToken();
        }
        sb2.append("</pre>");
        return sb2.toString();
    }
}

