/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenOrientedView;
import org.fife.ui.rsyntaxtextarea.TokenUtils;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public final class RSyntaxUtilities
implements SwingConstants {
    public static final int OS_WINDOWS = 1;
    public static final int OS_MAC_OSX = 2;
    public static final int OS_LINUX = 4;
    public static final int OS_OTHER = 8;
    private static final Color LIGHT_HYPERLINK_FG = new Color(0xD8FFFF);
    private static final int OS = RSyntaxUtilities.getOSImpl();
    private static final int LETTER_MASK = 2;
    private static final int HEX_CHARACTER_MASK = 16;
    private static final int LETTER_OR_DIGIT_MASK = 32;
    private static final int BRACKET_MASK = 64;
    private static final int JAVA_OPERATOR_MASK = 128;
    private static final int[] DATA_TABLE;
    private static Segment charSegment;
    private static final TokenImpl TEMP_TOKEN;
    private static final char[] JS_KEYWORD_RETURN;
    private static final char[] JS_AND;
    private static final char[] JS_OR;
    private static final String BRACKETS = "{([})]";

    static {
        int[] nArray = new int[256];
        nArray[9] = 4;
        nArray[32] = 4;
        nArray[33] = 128;
        nArray[37] = 128;
        nArray[38] = 128;
        nArray[40] = 64;
        nArray[41] = 64;
        nArray[42] = 128;
        nArray[43] = 128;
        nArray[45] = 128;
        nArray[47] = 128;
        nArray[48] = 49;
        nArray[49] = 49;
        nArray[50] = 49;
        nArray[51] = 49;
        nArray[52] = 49;
        nArray[53] = 49;
        nArray[54] = 49;
        nArray[55] = 49;
        nArray[56] = 49;
        nArray[57] = 49;
        nArray[58] = 128;
        nArray[60] = 128;
        nArray[61] = 128;
        nArray[62] = 128;
        nArray[63] = 128;
        nArray[65] = 58;
        nArray[66] = 58;
        nArray[67] = 58;
        nArray[68] = 58;
        nArray[69] = 58;
        nArray[70] = 58;
        nArray[71] = 42;
        nArray[72] = 42;
        nArray[73] = 42;
        nArray[74] = 42;
        nArray[75] = 42;
        nArray[76] = 42;
        nArray[77] = 42;
        nArray[78] = 42;
        nArray[79] = 42;
        nArray[80] = 42;
        nArray[81] = 42;
        nArray[82] = 42;
        nArray[83] = 42;
        nArray[84] = 42;
        nArray[85] = 42;
        nArray[86] = 42;
        nArray[87] = 42;
        nArray[88] = 42;
        nArray[89] = 42;
        nArray[90] = 42;
        nArray[91] = 64;
        nArray[93] = 64;
        nArray[94] = 128;
        nArray[97] = 50;
        nArray[98] = 50;
        nArray[99] = 50;
        nArray[100] = 50;
        nArray[101] = 50;
        nArray[102] = 50;
        nArray[103] = 34;
        nArray[104] = 34;
        nArray[105] = 34;
        nArray[106] = 34;
        nArray[107] = 34;
        nArray[108] = 34;
        nArray[109] = 34;
        nArray[110] = 34;
        nArray[111] = 34;
        nArray[112] = 34;
        nArray[113] = 34;
        nArray[114] = 34;
        nArray[115] = 34;
        nArray[116] = 34;
        nArray[117] = 34;
        nArray[118] = 34;
        nArray[119] = 34;
        nArray[120] = 34;
        nArray[121] = 34;
        nArray[122] = 34;
        nArray[123] = 64;
        nArray[124] = 128;
        nArray[125] = 64;
        nArray[126] = 128;
        DATA_TABLE = nArray;
        charSegment = new Segment();
        TEMP_TOKEN = new TokenImpl();
        JS_KEYWORD_RETURN = new char[]{'r', 'e', 't', 'u', 'r', 'n'};
        JS_AND = new char[]{'&', '&'};
        JS_OR = new char[]{'|', '|'};
    }

    private RSyntaxUtilities() {
    }

    public static Map<?, ?> getDesktopAntiAliasHints() {
        return (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    }

    public static Color getFoldedLineBottomColor(RSyntaxTextArea textArea) {
        Color color = Color.GRAY;
        Gutter gutter = RSyntaxUtilities.getGutter(textArea);
        if (gutter != null) {
            color = gutter.getFoldIndicatorForeground();
        }
        return color;
    }

    public static Gutter getGutter(RTextArea textArea) {
        Gutter gutter = null;
        Container parent = textArea.getParent();
        if (parent instanceof JViewport && (parent = parent.getParent()) instanceof RTextScrollPane) {
            RTextScrollPane sp2 = (RTextScrollPane)parent;
            gutter = sp2.getGutter();
        }
        return gutter;
    }

    public static Color getHyperlinkForeground() {
        Color fg2 = UIManager.getColor("Label.foreground");
        if (fg2 == null) {
            fg2 = new JLabel().getForeground();
        }
        return RSyntaxUtilities.isLightForeground(fg2) ? LIGHT_HYPERLINK_FG : Color.blue;
    }

    public static String getLeadingWhitespace(String text) {
        int count = 0;
        int len = text.length();
        while (count < len && RSyntaxUtilities.isWhitespace(text.charAt(count))) {
            ++count;
        }
        return text.substring(0, count);
    }

    public static String getLeadingWhitespace(Document doc, int offs) throws BadLocationException {
        Element root = doc.getDefaultRootElement();
        int line = root.getElementIndex(offs);
        Element elem = root.getElement(line);
        int startOffs = elem.getStartOffset();
        int endOffs = elem.getEndOffset() - 1;
        String text = doc.getText(startOffs, endOffs - startOffs);
        return RSyntaxUtilities.getLeadingWhitespace(text);
    }

    private static Element getLineElem(Document doc, int offs) {
        int line;
        Element root = doc.getDefaultRootElement();
        Element elem = root.getElement(line = root.getElementIndex(offs));
        if (offs >= elem.getStartOffset() && offs < elem.getEndOffset()) {
            return elem;
        }
        return null;
    }

    public static Rectangle getLineWidthUpTo(RSyntaxTextArea textArea, Segment s10, int p02, int p12, TabExpander e10, Rectangle rect, int x02) throws BadLocationException {
        RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
        if (p02 < 0) {
            throw new BadLocationException("Invalid document position", p02);
        }
        if (p12 > doc.getLength()) {
            throw new BadLocationException("Invalid document position", p12);
        }
        Element map = doc.getDefaultRootElement();
        int lineNum = map.getElementIndex(p02);
        if (Math.abs(lineNum - map.getElementIndex(p12)) > 1) {
            throw new IllegalArgumentException("p0 and p1 are not on the same line (" + p02 + ", " + p12 + ").");
        }
        Token t10 = doc.getTokenListForLine(lineNum);
        TokenUtils.TokenSubList subList = TokenUtils.getSubTokenList(t10, p02, e10, textArea, 0.0f, TEMP_TOKEN);
        t10 = subList.tokenList;
        rect = t10.listOffsetToView(textArea, e10, p12, x02, rect);
        return rect;
    }

    public static Point getMatchingBracketPosition(RSyntaxTextArea textArea, Point input) {
        if (input == null) {
            input = new Point();
        }
        input.setLocation(-1, -1);
        try {
            char bracketMatch;
            boolean goForward;
            int index;
            int caretPosition = textArea.getCaretPosition() - 1;
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            char bracket = '\u0000';
            if (caretPosition >= 0) {
                bracket = doc.charAt(caretPosition);
            }
            if ((index = BRACKETS.indexOf(bracket)) == -1 && caretPosition < doc.getLength() - 1) {
                bracket = doc.charAt(++caretPosition);
            }
            if (index == -1 && (index = BRACKETS.indexOf(bracket)) == -1) {
                return input;
            }
            Element map = doc.getDefaultRootElement();
            int curLine = map.getElementIndex(caretPosition);
            Element line = map.getElement(curLine);
            int start = line.getStartOffset();
            int end = line.getEndOffset();
            Token token = doc.getTokenListForLine(curLine);
            if ((token = RSyntaxUtilities.getTokenAtOffset(token, caretPosition)).getType() != 22) {
                return input;
            }
            int languageIndex = token.getLanguageIndex();
            if (index < 3) {
                goForward = true;
                bracketMatch = BRACKETS.charAt(index + 3);
            } else {
                goForward = false;
                bracketMatch = BRACKETS.charAt(index - 3);
            }
            if (goForward) {
                int lastLine = map.getElementCount();
                start = caretPosition + 1;
                int numEmbedded = 0;
                boolean haveTokenList = false;
                while (true) {
                    int segOffset;
                    doc.getText(start, end - start, charSegment);
                    int i10 = segOffset = RSyntaxUtilities.charSegment.offset;
                    while (i10 < segOffset + RSyntaxUtilities.charSegment.count) {
                        int offset;
                        char ch2 = RSyntaxUtilities.charSegment.array[i10];
                        if (ch2 == bracket) {
                            if (!haveTokenList) {
                                token = doc.getTokenListForLine(curLine);
                                haveTokenList = true;
                            }
                            if ((token = RSyntaxUtilities.getTokenAtOffset(token, offset = start + (i10 - segOffset))).getType() == 22 && token.getLanguageIndex() == languageIndex) {
                                ++numEmbedded;
                            }
                        } else if (ch2 == bracketMatch) {
                            if (!haveTokenList) {
                                token = doc.getTokenListForLine(curLine);
                                haveTokenList = true;
                            }
                            if ((token = RSyntaxUtilities.getTokenAtOffset(token, offset = start + (i10 - segOffset))).getType() == 22 && token.getLanguageIndex() == languageIndex) {
                                if (numEmbedded == 0) {
                                    if (textArea.isCodeFoldingEnabled() && textArea.getFoldManager().isLineHidden(curLine)) {
                                        return input;
                                    }
                                    input.setLocation(caretPosition, offset);
                                    return input;
                                }
                                --numEmbedded;
                            }
                        }
                        ++i10;
                    }
                    if (++curLine == lastLine) {
                        return input;
                    }
                    haveTokenList = false;
                    line = map.getElement(curLine);
                    start = line.getStartOffset();
                    end = line.getEndOffset();
                }
            }
            end = caretPosition;
            int numEmbedded = 0;
            boolean haveTokenList = false;
            while (true) {
                int iStart;
                doc.getText(start, end - start, charSegment);
                int segOffset = RSyntaxUtilities.charSegment.offset;
                int i11 = iStart = segOffset + RSyntaxUtilities.charSegment.count - 1;
                while (i11 >= segOffset) {
                    int offset;
                    Token t22;
                    char ch3 = RSyntaxUtilities.charSegment.array[i11];
                    if (ch3 == bracket) {
                        if (!haveTokenList) {
                            token = doc.getTokenListForLine(curLine);
                            haveTokenList = true;
                        }
                        if ((t22 = RSyntaxUtilities.getTokenAtOffset(token, offset = start + (i11 - segOffset))).getType() == 22 && token.getLanguageIndex() == languageIndex) {
                            ++numEmbedded;
                        }
                    } else if (ch3 == bracketMatch) {
                        if (!haveTokenList) {
                            token = doc.getTokenListForLine(curLine);
                            haveTokenList = true;
                        }
                        if ((t22 = RSyntaxUtilities.getTokenAtOffset(token, offset = start + (i11 - segOffset))).getType() == 22 && token.getLanguageIndex() == languageIndex) {
                            if (numEmbedded == 0) {
                                input.setLocation(caretPosition, offset);
                                return input;
                            }
                            --numEmbedded;
                        }
                    }
                    --i11;
                }
                if (--curLine == -1) {
                    return input;
                }
                haveTokenList = false;
                line = map.getElement(curLine);
                start = line.getStartOffset();
                end = line.getEndOffset();
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return input;
        }
    }

    public static Token getNextImportantToken(Token t10, RSyntaxTextArea textArea, int line) {
        while (t10 != null && t10.isPaintable() && t10.isCommentOrWhitespace()) {
            t10 = t10.getNextToken();
        }
        if (!(t10 != null && t10.isPaintable() || line >= textArea.getLineCount() - 1)) {
            t10 = textArea.getTokenListForLine(++line);
            return RSyntaxUtilities.getNextImportantToken(t10, textArea, line);
        }
        return t10;
    }

    public static int getNextVisualPositionFrom(int pos, Position.Bias b10, Shape a10, int direction, Position.Bias[] biasRet, View view) throws BadLocationException {
        RSyntaxTextArea target = (RSyntaxTextArea)view.getContainer();
        biasRet[0] = Position.Bias.Forward;
        switch (direction) {
            case 1: 
            case 5: {
                Rectangle loc;
                if (pos == -1) {
                    pos = direction == 1 ? Math.max(0, view.getEndOffset() - 1) : view.getStartOffset();
                    break;
                }
                Caret c10 = target != null ? target.getCaret() : null;
                Point mcp = c10 != null ? c10.getMagicCaretPosition() : null;
                int x10 = mcp == null ? ((loc = target.modelToView(pos)) == null ? 0 : loc.x) : mcp.x;
                if (direction == 1) {
                    pos = RSyntaxUtilities.getPositionAbove(target, pos, x10, (TabExpander)((Object)view));
                    break;
                }
                pos = RSyntaxUtilities.getPositionBelow(target, pos, x10, (TabExpander)((Object)view));
                break;
            }
            case 7: {
                FoldManager fm2;
                int current;
                int last;
                int endOffs = view.getEndOffset();
                if (pos == -1) {
                    pos = Math.max(0, endOffs - 1);
                    break;
                }
                pos = Math.max(0, pos - 1);
                if (!target.isCodeFoldingEnabled() || (last = pos == endOffs - 1 ? target.getLineCount() - 1 : target.getLineOfOffset(pos + 1)) == (current = target.getLineOfOffset(pos)) || !(fm2 = target.getFoldManager()).isLineHidden(current)) break;
                while (--current > 0 && fm2.isLineHidden(current)) {
                }
                pos = target.getLineEndOffset(current) - 1;
                break;
            }
            case 3: {
                FoldManager fm3;
                int current;
                int last;
                if (pos == -1) {
                    pos = view.getStartOffset();
                    break;
                }
                pos = Math.min(pos + 1, view.getDocument().getLength());
                if (!target.isCodeFoldingEnabled() || (last = pos == 0 ? 0 : target.getLineOfOffset(pos - 1)) == (current = target.getLineOfOffset(pos)) || !(fm3 = target.getFoldManager()).isLineHidden(current)) break;
                int lineCount = target.getLineCount();
                while (++current < lineCount && fm3.isLineHidden(current)) {
                }
                pos = current == lineCount ? target.getLineEndOffset(last) - 1 : target.getLineStartOffset(current);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return pos;
    }

    public static int getOS() {
        return OS;
    }

    private static int getOSImpl() {
        int os2 = 8;
        String osName = System.getProperty("os.name");
        if (osName != null) {
            os2 = (osName = osName.toLowerCase()).contains("windows") ? 1 : (osName.contains("mac os x") ? 2 : (osName.contains("linux") ? 4 : 8));
        }
        return os2;
    }

    public static int getPatternFlags(boolean matchCase, int others) {
        if (!matchCase) {
            others |= 0x42;
        }
        return others;
    }

    public static int getPositionAbove(RSyntaxTextArea c10, int offs, float x10, TabExpander e10) throws BadLocationException {
        TokenOrientedView tov = (TokenOrientedView)((Object)e10);
        Token token = tov.getTokenListForPhysicalLineAbove(offs);
        if (token == null) {
            return -1;
        }
        if (token.getType() == 0) {
            int line = c10.getLineOfOffset(offs);
            return c10.getLineStartOffset(line - 1);
        }
        return token.getListOffset(c10, e10, c10.getMargin().left, x10);
    }

    public static int getPositionBelow(RSyntaxTextArea c10, int offs, float x10, TabExpander e10) throws BadLocationException {
        TokenOrientedView tov = (TokenOrientedView)((Object)e10);
        Token token = tov.getTokenListForPhysicalLineBelow(offs);
        if (token == null) {
            return -1;
        }
        if (token.getType() == 0) {
            int line = c10.getLineOfOffset(offs);
            FoldManager fm2 = c10.getFoldManager();
            line = fm2.getVisibleLineBelow(line);
            return c10.getLineStartOffset(line);
        }
        return token.getListOffset(c10, e10, c10.getMargin().left, x10);
    }

    public static Token getPreviousImportantToken(RSyntaxDocument doc, int line) {
        if (line < 0) {
            return null;
        }
        Token t10 = doc.getTokenListForLine(line);
        if (t10 != null && (t10 = t10.getLastNonCommentNonWhitespaceToken()) != null) {
            return t10;
        }
        return RSyntaxUtilities.getPreviousImportantToken(doc, line - 1);
    }

    public static Token getPreviousImportantTokenFromOffs(RSyntaxDocument doc, int offs) {
        Element root = doc.getDefaultRootElement();
        int line = root.getElementIndex(offs);
        Token t10 = doc.getTokenListForLine(line);
        Token target = null;
        while (t10 != null && t10.isPaintable() && !t10.containsPosition(offs)) {
            if (!t10.isCommentOrWhitespace()) {
                target = t10;
            }
            t10 = t10.getNextToken();
        }
        if (target == null) {
            target = RSyntaxUtilities.getPreviousImportantToken(doc, line - 1);
        }
        return target;
    }

    public static Token getTokenAtOffset(RSyntaxTextArea textArea, int offset) {
        RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
        return RSyntaxUtilities.getTokenAtOffset(doc, offset);
    }

    public static Token getTokenAtOffset(RSyntaxDocument doc, int offset) {
        Element root = doc.getDefaultRootElement();
        int lineIndex = root.getElementIndex(offset);
        Token t10 = doc.getTokenListForLine(lineIndex);
        return RSyntaxUtilities.getTokenAtOffset(t10, offset);
    }

    public static Token getTokenAtOffset(Token tokenList, int offset) {
        Token t10 = tokenList;
        while (t10 != null && t10.isPaintable()) {
            if (t10.containsPosition(offset)) {
                return t10;
            }
            t10 = t10.getNextToken();
        }
        return null;
    }

    public static int getWordEnd(RSyntaxTextArea textArea, int offs) throws BadLocationException {
        Document doc = textArea.getDocument();
        int endOffs = textArea.getLineEndOffsetOfCurrentLine();
        int lineEnd = Math.min(endOffs, doc.getLength());
        if (offs == lineEnd) {
            return offs;
        }
        String s10 = doc.getText(offs, lineEnd - offs - 1);
        if (s10 != null && s10.length() > 0) {
            int i10 = 0;
            int count = s10.length();
            char ch2 = s10.charAt(i10);
            if (Character.isWhitespace(ch2)) {
                while (i10 < count && Character.isWhitespace(s10.charAt(i10++))) {
                }
            } else if (Character.isLetterOrDigit(ch2)) {
                while (i10 < count && Character.isLetterOrDigit(s10.charAt(i10++))) {
                }
            } else {
                i10 = 2;
            }
            offs += i10 - 1;
        }
        return offs;
    }

    public static int getWordStart(RSyntaxTextArea textArea, int offs) throws BadLocationException {
        Document doc = textArea.getDocument();
        Element line = RSyntaxUtilities.getLineElem(doc, offs);
        if (line == null) {
            throw new BadLocationException("No word at " + offs, offs);
        }
        int lineStart = line.getStartOffset();
        if (offs == lineStart) {
            return offs;
        }
        int endOffs = Math.min(offs + 1, doc.getLength());
        String s10 = doc.getText(lineStart, endOffs - lineStart);
        if (s10 != null && s10.length() > 0) {
            int i10 = s10.length() - 1;
            char ch2 = s10.charAt(i10);
            if (Character.isWhitespace(ch2)) {
                while (i10 > 0 && Character.isWhitespace(s10.charAt(i10 - 1))) {
                    --i10;
                }
                offs = lineStart + i10;
            } else if (Character.isLetterOrDigit(ch2)) {
                while (i10 > 0 && Character.isLetterOrDigit(s10.charAt(i10 - 1))) {
                    --i10;
                }
                offs = lineStart + i10;
            }
        }
        return offs;
    }

    public static float getTokenListWidth(Token tokenList, RSyntaxTextArea textArea, TabExpander e10) {
        return RSyntaxUtilities.getTokenListWidth(tokenList, textArea, e10, 0.0f);
    }

    public static float getTokenListWidth(Token tokenList, RSyntaxTextArea textArea, TabExpander e10, float x02) {
        float width = x02;
        Token t10 = tokenList;
        while (t10 != null && t10.isPaintable()) {
            width += t10.getWidth(textArea, e10, width);
            t10 = t10.getNextToken();
        }
        return width - x02;
    }

    public static float getTokenListWidthUpTo(Token tokenList, RSyntaxTextArea textArea, TabExpander e10, float x02, int upTo) {
        float width = 0.0f;
        Token t10 = tokenList;
        while (t10 != null && t10.isPaintable()) {
            if (t10.containsPosition(upTo)) {
                return width + t10.getWidthUpTo(upTo - t10.getOffset(), textArea, e10, x02 + width);
            }
            width += t10.getWidth(textArea, e10, x02 + width);
            t10 = t10.getNextToken();
        }
        return width;
    }

    public static boolean isBracket(char ch2) {
        return ch2 <= '}' && (DATA_TABLE[ch2] & 0x40) > 0;
    }

    public static boolean isDigit(char ch2) {
        return ch2 >= '0' && ch2 <= '9';
    }

    public static boolean isHexCharacter(char ch2) {
        return ch2 <= 'f' && (DATA_TABLE[ch2] & 0x10) > 0;
    }

    public static boolean isJavaOperator(char ch2) {
        return ch2 <= '~' && (DATA_TABLE[ch2] & 0x80) > 0;
    }

    public static boolean isLetter(char ch2) {
        return ch2 <= 'z' && (DATA_TABLE[ch2] & 2) > 0;
    }

    public static boolean isLetterOrDigit(char ch2) {
        return ch2 <= 'z' && (DATA_TABLE[ch2] & 0x20) > 0;
    }

    public static boolean isLightForeground(Color fg2) {
        return fg2.getRed() > 160 && fg2.getGreen() > 160 && fg2.getBlue() > 160;
    }

    public static boolean isNonWordChar(Token t10) {
        return t10.length() == 1 && !RSyntaxUtilities.isLetter(t10.charAt(0));
    }

    public static boolean isWhitespace(char ch2) {
        return ch2 == ' ' || ch2 == '\t';
    }

    public static void possiblyRepaintGutter(RTextArea textArea) {
        Gutter gutter = RSyntaxUtilities.getGutter(textArea);
        if (gutter != null) {
            gutter.repaint();
        }
    }

    public static boolean regexCanFollowInJavaScript(Token t10) {
        char ch2;
        return t10 == null || t10.length() == 1 && ((ch2 = t10.charAt(0)) == '=' || ch2 == '(' || ch2 == ',' || ch2 == '?' || ch2 == ':' || ch2 == '[' || ch2 == '!' || ch2 == '&') || t10.getType() == 23 && (t10.charAt(t10.length() - 1) == '=' || t10.is(JS_AND) || t10.is(JS_OR)) || t10.is(7, JS_KEYWORD_RETURN);
    }

    public static void selectAndPossiblyCenter(JTextArea textArea, DocumentRange range, boolean select) {
        Rectangle r10;
        RSyntaxTextArea rsta;
        FoldManager fm2;
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        boolean foldsExpanded = false;
        if (textArea instanceof RSyntaxTextArea && (fm2 = (rsta = (RSyntaxTextArea)textArea).getFoldManager()).isCodeFoldingSupportedAndEnabled()) {
            foldsExpanded = fm2.ensureOffsetNotInClosedFold(start);
            foldsExpanded |= fm2.ensureOffsetNotInClosedFold(end);
        }
        if (select) {
            textArea.setSelectionStart(start);
            textArea.setSelectionEnd(end);
        }
        try {
            r10 = textArea.modelToView(start);
            if (r10 == null) {
                return;
            }
            if (end != start) {
                r10 = r10.union(textArea.modelToView(end));
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            if (select) {
                textArea.setSelectionStart(start);
                textArea.setSelectionEnd(end);
            }
            return;
        }
        Rectangle visible = textArea.getVisibleRect();
        if (!foldsExpanded && visible.contains(r10)) {
            if (select) {
                textArea.setSelectionStart(start);
                textArea.setSelectionEnd(end);
            }
            return;
        }
        visible.x = r10.x - (visible.width - r10.width) / 2;
        visible.y = r10.y - (visible.height - r10.height) / 2;
        Rectangle bounds = textArea.getBounds();
        Insets i10 = textArea.getInsets();
        bounds.x = i10.left;
        bounds.y = i10.top;
        bounds.width -= i10.left + i10.right;
        bounds.height -= i10.top + i10.bottom;
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        textArea.scrollRectToVisible(visible);
    }

    public static char toLowerCase(char ch2) {
        if (ch2 >= 'A' && ch2 <= 'Z') {
            return (char)(ch2 | 0x20);
        }
        return ch2;
    }

    public static Pattern wildcardToPattern(String wildcard, boolean matchCase, boolean escapeStartChar) {
        Pattern p10;
        int flags = RSyntaxUtilities.getPatternFlags(matchCase, 0);
        StringBuilder sb2 = new StringBuilder();
        int i10 = 0;
        while (i10 < wildcard.length()) {
            char ch2 = wildcard.charAt(i10);
            switch (ch2) {
                case '*': {
                    sb2.append(".*");
                    break;
                }
                case '?': {
                    sb2.append('.');
                    break;
                }
                case '^': {
                    if (i10 > 0 || escapeStartChar) {
                        sb2.append('\\');
                    }
                    sb2.append('^');
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '-': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    sb2.append('\\').append(ch2);
                    break;
                }
                default: {
                    sb2.append(ch2);
                }
            }
            ++i10;
        }
        try {
            p10 = Pattern.compile(sb2.toString(), flags);
        }
        catch (PatternSyntaxException pse) {
            pse.printStackTrace();
            p10 = Pattern.compile(".+");
        }
        return p10;
    }
}

