/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import org.fife.ui.rtextarea.RTextArea;

public class RtfGenerator {
    private Color mainBG;
    private List<Font> fontList;
    private List<Color> colorList;
    private StringBuilder document;
    private boolean lastWasControlWord;
    private int lastFontIndex;
    private int lastFGIndex;
    private boolean lastBold;
    private boolean lastItalic;
    private int lastFontSize;
    private int screenRes;
    private static final int DEFAULT_FONT_SIZE = 12;

    public RtfGenerator(Color mainBG) {
        this.mainBG = mainBG;
        this.fontList = new ArrayList<Font>(1);
        this.colorList = new ArrayList<Color>(1);
        this.document = new StringBuilder();
        this.reset();
    }

    public void appendNewline() {
        this.document.append("\\line");
        this.document.append('\n');
        this.lastWasControlWord = false;
    }

    public void appendToDoc(String text, Font f10, Color fg2, Color bg2) {
        this.appendToDoc(text, f10, fg2, bg2, false);
    }

    public void appendToDocNoFG(String text, Font f10, Color bg2, boolean underline) {
        this.appendToDoc(text, f10, null, bg2, underline, false);
    }

    public void appendToDoc(String text, Font f10, Color fg2, Color bg2, boolean underline) {
        this.appendToDoc(text, f10, fg2, bg2, underline, true);
    }

    public void appendToDoc(String text, Font f10, Color fg2, Color bg2, boolean underline, boolean setFG) {
        if (text != null) {
            int fontIndex;
            int n10 = fontIndex = f10 == null ? 0 : RtfGenerator.getFontIndex(this.fontList, f10) + 1;
            if (fontIndex != this.lastFontIndex) {
                this.document.append("\\f").append(fontIndex);
                this.lastFontIndex = fontIndex;
                this.lastWasControlWord = true;
            }
            if (f10 != null) {
                int fontSize = this.fixFontSize(f10.getSize2D() * 2.0f);
                if (fontSize != this.lastFontSize) {
                    this.document.append("\\fs").append(fontSize);
                    this.lastFontSize = fontSize;
                    this.lastWasControlWord = true;
                }
                if (f10.isBold() != this.lastBold) {
                    this.document.append(this.lastBold ? "\\b0" : "\\b");
                    this.lastBold = !this.lastBold;
                    this.lastWasControlWord = true;
                }
                if (f10.isItalic() != this.lastItalic) {
                    this.document.append(this.lastItalic ? "\\i0" : "\\i");
                    this.lastItalic = !this.lastItalic;
                    this.lastWasControlWord = true;
                }
            } else {
                if (this.lastFontSize != 12) {
                    this.document.append("\\fs").append(12);
                    this.lastFontSize = 12;
                    this.lastWasControlWord = true;
                }
                if (this.lastBold) {
                    this.document.append("\\b0");
                    this.lastBold = false;
                    this.lastWasControlWord = true;
                }
                if (this.lastItalic) {
                    this.document.append("\\i0");
                    this.lastItalic = false;
                    this.lastWasControlWord = true;
                }
            }
            if (underline) {
                this.document.append("\\ul");
                this.lastWasControlWord = true;
            }
            if (setFG) {
                int fgIndex = 0;
                if (fg2 != null) {
                    fgIndex = RtfGenerator.getColorIndex(this.colorList, fg2) + 1;
                }
                if (fgIndex != this.lastFGIndex) {
                    this.document.append("\\cf").append(fgIndex);
                    this.lastFGIndex = fgIndex;
                    this.lastWasControlWord = true;
                }
            }
            if (bg2 != null) {
                int pos = RtfGenerator.getColorIndex(this.colorList, bg2);
                this.document.append("\\highlight").append(pos + 1);
                this.lastWasControlWord = true;
            }
            if (this.lastWasControlWord) {
                this.document.append(' ');
                this.lastWasControlWord = false;
            }
            this.escapeAndAdd(this.document, text);
            if (bg2 != null) {
                this.document.append("\\highlight0");
                this.lastWasControlWord = true;
            }
            if (underline) {
                this.document.append("\\ul0");
                this.lastWasControlWord = true;
            }
        }
    }

    private void escapeAndAdd(StringBuilder sb2, String text) {
        int count = text.length();
        int i10 = 0;
        while (i10 < count) {
            char ch2 = text.charAt(i10);
            switch (ch2) {
                case '\t': {
                    sb2.append("\\tab");
                    while (++i10 < count && text.charAt(i10) == '\t') {
                        sb2.append("\\tab");
                    }
                    sb2.append(' ');
                    --i10;
                    break;
                }
                case '\\': 
                case '{': 
                case '}': {
                    sb2.append('\\').append(ch2);
                    break;
                }
                default: {
                    if (ch2 <= '\u007f') {
                        sb2.append(ch2);
                        break;
                    }
                    sb2.append("\\u").append((int)ch2).append(' ');
                }
            }
            ++i10;
        }
    }

    private int fixFontSize(float pointSize) {
        if (this.screenRes != 72) {
            pointSize = Math.round(pointSize * 72.0f / (float)this.screenRes);
        }
        return (int)pointSize;
    }

    private static int getColorIndex(List<Color> list, Color item) {
        int pos = list.indexOf(item);
        if (pos == -1) {
            list.add(item);
            pos = list.size() - 1;
        }
        return pos;
    }

    private String getColorTableRtf() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("{\\colortbl ;");
        for (Color c10 : this.colorList) {
            sb2.append("\\red").append(c10.getRed());
            sb2.append("\\green").append(c10.getGreen());
            sb2.append("\\blue").append(c10.getBlue());
            sb2.append(';');
        }
        sb2.append("}");
        return sb2.toString();
    }

    private static int getFontIndex(List<Font> list, Font font) {
        String fontName = font.getFamily();
        int i10 = 0;
        while (i10 < list.size()) {
            Font font2 = list.get(i10);
            if (font2.getFamily().equals(fontName)) {
                return i10;
            }
            ++i10;
        }
        list.add(font);
        return list.size() - 1;
    }

    private String getFontTableRtf() {
        StringBuilder sb2 = new StringBuilder();
        String monoFamilyName = RtfGenerator.getMonospacedFontFamily();
        sb2.append("{\\fonttbl{\\f0\\fnil\\fcharset0 ").append(monoFamilyName).append(";}");
        int i10 = 0;
        while (i10 < this.fontList.size()) {
            Font f10 = this.fontList.get(i10);
            String familyName = f10.getFamily();
            if (familyName.equals("Monospaced")) {
                familyName = monoFamilyName;
            }
            sb2.append("{\\f").append(i10 + 1).append("\\fnil\\fcharset0 ");
            sb2.append(familyName).append(";}");
            ++i10;
        }
        sb2.append('}');
        return sb2.toString();
    }

    private static String getMonospacedFontFamily() {
        String family = RTextArea.getDefaultFont().getFamily();
        if ("Monospaced".equals(family)) {
            family = "Courier";
        }
        return family;
    }

    public String getRtf() {
        int mainBGIndex = RtfGenerator.getColorIndex(this.colorList, this.mainBG);
        StringBuilder sb2 = new StringBuilder();
        sb2.append("{");
        sb2.append("\\rtf1\\ansi\\ansicpg1252");
        sb2.append("\\deff0");
        sb2.append("\\deflang1033");
        sb2.append("\\viewkind4");
        sb2.append("\\uc\\pard\\f0");
        sb2.append("\\fs20");
        sb2.append(this.getFontTableRtf()).append('\n');
        sb2.append(this.getColorTableRtf()).append('\n');
        int bgIndex = mainBGIndex + 1;
        sb2.append("\\cb").append(bgIndex).append(' ');
        this.lastWasControlWord = true;
        if (this.document.length() > 0) {
            this.document.append("\\line");
        }
        sb2.append((CharSequence)this.document);
        sb2.append("}");
        return sb2.toString();
    }

    public void reset() {
        this.fontList.clear();
        this.colorList.clear();
        this.document.setLength(0);
        this.lastWasControlWord = false;
        this.lastFontIndex = 0;
        this.lastFGIndex = 0;
        this.lastBold = false;
        this.lastItalic = false;
        this.lastFontSize = 12;
        this.screenRes = Toolkit.getDefaultToolkit().getScreenResolution();
    }
}

