/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;

final class RtfToText {
    private Reader r;
    private StringBuilder sb;
    private StringBuilder controlWord;
    private int blockCount;
    private boolean inControlWord;

    private RtfToText(Reader r10) {
        this.r = r10;
        this.sb = new StringBuilder();
        this.controlWord = new StringBuilder();
        this.blockCount = 0;
        this.inControlWord = false;
    }

    /*
     * Unable to fully structure code
     */
    private String convert() throws IOException {
        i = this.r.read();
        if (i == 123) ** GOTO lbl58
        throw new IOException("Invalid RTF file");
lbl-1000:
        // 1 sources

        {
            ch = (char)i;
            switch (ch) {
                case '{': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('{');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        break;
                    }
                    ++this.blockCount;
                    break;
                }
                case '}': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('}');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        break;
                    }
                    --this.blockCount;
                    break;
                }
                case '\\': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        if (this.controlWord.length() == 0) {
                            this.sb.append('\\');
                            this.controlWord.setLength(0);
                            this.inControlWord = false;
                            break;
                        }
                        this.endControlWord();
                        this.inControlWord = true;
                        break;
                    }
                    this.inControlWord = true;
                    break;
                }
                case ' ': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        this.endControlWord();
                        break;
                    }
                    this.sb.append(' ');
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.blockCount != 0 || !this.inControlWord) continue block7;
                    this.endControlWord();
                    break;
                }
                default: {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        this.controlWord.append(ch);
                        break;
                    }
                    this.sb.append(ch);
                }
            }
lbl58:
            // 17 sources

            ** while ((i = this.r.read()) != -1)
        }
lbl59:
        // 1 sources

        return this.sb.toString();
    }

    private void endControlWord() {
        String word = this.controlWord.toString();
        if ("par".equals(word) || "line".equals(word)) {
            this.sb.append('\n');
        } else if ("tab".equals(word)) {
            this.sb.append('\t');
        } else if (RtfToText.isUnicodeEscape(word)) {
            this.sb.append((char)Integer.valueOf(word.substring(1)).intValue());
        }
        this.controlWord.setLength(0);
        this.inControlWord = false;
    }

    private static boolean isUnicodeEscape(String controlWord) {
        if (controlWord.startsWith("u") && controlWord.length() > 1) {
            int i10 = 1;
            while (i10 < controlWord.length()) {
                char ch2 = controlWord.charAt(i10);
                if (ch2 < '0' || ch2 > '9') {
                    return false;
                }
                ++i10;
            }
            return true;
        }
        return false;
    }

    public static String getPlainText(byte[] rtf) throws IOException {
        return RtfToText.getPlainText(new ByteArrayInputStream(rtf));
    }

    public static String getPlainText(File file) throws IOException {
        return RtfToText.getPlainText(new BufferedReader(new FileReader(file)));
    }

    public static String getPlainText(InputStream in2) throws IOException {
        return RtfToText.getPlainText(new InputStreamReader(in2, StandardCharsets.US_ASCII));
    }

    private static String getPlainText(Reader r10) throws IOException {
        try {
            RtfToText converter = new RtfToText(r10);
            String string = converter.convert();
            return string;
        }
        finally {
            r10.close();
        }
    }

    public static String getPlainText(String rtf) throws IOException {
        return RtfToText.getPlainText(new StringReader(rtf));
    }
}

