/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;

public class SquiggleUnderlineHighlightPainter
extends ChangeableHighlightPainter {
    private static final int AMT = 2;

    public SquiggleUnderlineHighlightPainter(Color color) {
        super(color);
        this.setPaint(color);
    }

    @Override
    public Shape paintLayer(Graphics g10, int offs0, int offs1, Shape bounds, JTextComponent c10, View view) {
        g10.setColor((Color)this.getPaint());
        if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
            Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            this.paintSquiggle(g10, alloc);
            return alloc;
        }
        try {
            Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
            Rectangle r10 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.paintSquiggle(g10, r10);
            return r10;
        }
        catch (BadLocationException e10) {
            e10.printStackTrace();
            return null;
        }
    }

    protected void paintSquiggle(Graphics g10, Rectangle r10) {
        int x10 = r10.x;
        int y10 = r10.y + r10.height - 2;
        int delta = -2;
        while (x10 < r10.x + r10.width) {
            g10.drawLine(x10, y10, x10 + 2, y10 + delta);
            y10 += delta;
            delta = -delta;
            x10 += 2;
        }
    }
}

