/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenOrientedView;
import org.fife.ui.rsyntaxtextarea.TokenPainter;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;

public class SyntaxView
extends View
implements TabExpander,
TokenOrientedView,
RSTAView {
    private Font font;
    private FontMetrics metrics;
    private Element longLine;
    private float longLineWidth;
    private int tabSize;
    private int tabBase;
    private RSyntaxTextArea host;
    private int lineHeight = 0;
    private int ascent;
    private int clipStart;
    private int clipEnd;
    private TokenImpl tempToken = new TokenImpl();

    public SyntaxView(Element elem) {
        super(elem);
    }

    void calculateLongestLine() {
        Container c10 = this.getContainer();
        this.font = c10.getFont();
        this.metrics = c10.getFontMetrics(this.font);
        this.tabSize = this.getTabSize() * this.metrics.charWidth(' ');
        Element lines = this.getElement();
        int n10 = lines.getElementCount();
        int i10 = 0;
        while (i10 < n10) {
            Element line = lines.getElement(i10);
            float w10 = this.getLineWidth(i10);
            if (w10 > this.longLineWidth) {
                this.longLineWidth = w10;
                this.longLine = line;
            }
            ++i10;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent changes, Shape a10, ViewFactory f10) {
        this.updateDamage(changes, a10, f10);
    }

    protected void damageLineRange(int line0, int line1, Shape a10, Component host) {
        if (a10 != null) {
            Rectangle area0 = this.lineToRect(a10, line0);
            Rectangle area1 = this.lineToRect(a10, line1);
            if (area0 != null && area1 != null) {
                Rectangle dmg = area0.union(area1);
                host.repaint(dmg.x, dmg.y, dmg.width, dmg.height);
            } else {
                host.repaint();
            }
        }
    }

    private float drawLine(TokenPainter painter, Token token, Graphics2D g10, float x10, float y10, int line) {
        float nextX = x10;
        boolean paintBG = this.host.getPaintTokenBackgrounds(line, y10);
        while (token != null && token.isPaintable() && nextX < (float)this.clipEnd) {
            nextX = painter.paint(token, g10, nextX, y10, this.host, this, this.clipStart, paintBG);
            token = token.getNextToken();
        }
        if (this.host.getEOLMarkersVisible()) {
            g10.setColor(this.host.getForegroundForTokenType(21));
            g10.setFont(this.host.getFontForTokenType(21));
            g10.drawString("\u00b6", nextX, y10);
        }
        return nextX;
    }

    private float drawLineWithSelection(TokenPainter painter, Token token, Graphics2D g10, float x10, float y10, int selStart, int selEnd) {
        float nextX = x10;
        boolean useSTC = this.host.getUseSelectedTextColor();
        while (token != null && token.isPaintable() && nextX < (float)this.clipEnd) {
            if (token.containsPosition(selStart)) {
                int tokenLen;
                int selCount;
                if (selStart > token.getOffset()) {
                    this.tempToken.copyFrom(token);
                    this.tempToken.textCount = selStart - this.tempToken.getOffset();
                    nextX = painter.paint(this.tempToken, g10, nextX, y10, this.host, this, this.clipStart);
                    this.tempToken.textCount = token.length();
                    this.tempToken.makeStartAt(selStart);
                    token = new TokenImpl(this.tempToken);
                }
                if ((selCount = Math.min(tokenLen = token.length(), selEnd - token.getOffset())) == tokenLen) {
                    nextX = painter.paintSelected(token, g10, nextX, y10, this.host, this, this.clipStart, useSTC);
                } else {
                    this.tempToken.copyFrom(token);
                    this.tempToken.textCount = selCount;
                    nextX = painter.paintSelected(this.tempToken, g10, nextX, y10, this.host, this, this.clipStart, useSTC);
                    this.tempToken.textCount = token.length();
                    this.tempToken.makeStartAt(token.getOffset() + selCount);
                    token = this.tempToken;
                    nextX = painter.paint(token, g10, nextX, y10, this.host, this, this.clipStart);
                }
            } else if (token.containsPosition(selEnd)) {
                this.tempToken.copyFrom(token);
                this.tempToken.textCount = selEnd - this.tempToken.getOffset();
                nextX = painter.paintSelected(this.tempToken, g10, nextX, y10, this.host, this, this.clipStart, useSTC);
                this.tempToken.textCount = token.length();
                this.tempToken.makeStartAt(selEnd);
                token = this.tempToken;
                nextX = painter.paint(token, g10, nextX, y10, this.host, this, this.clipStart);
            } else {
                nextX = token.getOffset() >= selStart && token.getEndOffset() <= selEnd ? painter.paintSelected(token, g10, nextX, y10, this.host, this, this.clipStart, useSTC) : painter.paint(token, g10, nextX, y10, this.host, this, this.clipStart);
            }
            token = token.getNextToken();
        }
        if (this.host.getEOLMarkersVisible()) {
            g10.setColor(this.host.getForegroundForTokenType(21));
            g10.setFont(this.host.getFontForTokenType(21));
            g10.drawString("\u00b6", nextX, y10);
        }
        return nextX;
    }

    private float getLineWidth(int lineNumber) {
        Token tokenList = ((RSyntaxDocument)this.getDocument()).getTokenListForLine(lineNumber);
        return RSyntaxUtilities.getTokenListWidth(tokenList, (RSyntaxTextArea)this.getContainer(), this);
    }

    @Override
    public int getNextVisualPositionFrom(int pos, Position.Bias b10, Shape a10, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return RSyntaxUtilities.getNextVisualPositionFrom(pos, b10, a10, direction, biasRet, this);
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        switch (axis) {
            case 0: {
                float span = this.longLineWidth + (float)this.getRhsCorrection();
                if (this.host.getEOLMarkersVisible()) {
                    span += (float)this.metrics.charWidth('\u00b6');
                }
                return span;
            }
            case 1: {
                this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
                int visibleLineCount = this.getElement().getElementCount();
                if (this.host.isCodeFoldingEnabled()) {
                    visibleLineCount -= this.host.getFoldManager().getHiddenLineCount();
                }
                return (float)visibleLineCount * (float)this.lineHeight;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    private int getRhsCorrection() {
        int rhsCorrection = 10;
        if (this.host != null) {
            rhsCorrection = this.host.getRightHandSideCorrection();
        }
        return rhsCorrection;
    }

    private int getTabSize() {
        Integer i10 = (Integer)this.getDocument().getProperty("tabSize");
        int size = i10 != null ? i10 : 5;
        return size;
    }

    @Override
    public Token getTokenListForPhysicalLineAbove(int offset) {
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = document.getDefaultRootElement();
        int line = map.getElementIndex(offset);
        FoldManager fm2 = this.host.getFoldManager();
        if (fm2 == null ? --line >= 0 : (line = fm2.getVisibleLineAbove(line)) >= 0) {
            return document.getTokenListForLine(line);
        }
        return null;
    }

    @Override
    public Token getTokenListForPhysicalLineBelow(int offset) {
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = document.getDefaultRootElement();
        int lineCount = map.getElementCount();
        int line = map.getElementIndex(offset);
        if (!this.host.isCodeFoldingEnabled()) {
            if (line < lineCount - 1) {
                return document.getTokenListForLine(line + 1);
            }
        } else {
            FoldManager fm2 = this.host.getFoldManager();
            line = fm2.getVisibleLineBelow(line);
            if (line >= 0 && line < lineCount) {
                return document.getTokenListForLine(line);
            }
        }
        return null;
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a10, ViewFactory f10) {
        this.updateDamage(changes, a10, f10);
    }

    protected Rectangle lineToRect(Shape a10, int line) {
        Rectangle r10 = null;
        this.updateMetrics();
        if (this.metrics != null) {
            Rectangle alloc = a10.getBounds();
            int n10 = this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
            if (this.host != null && this.host.isCodeFoldingEnabled()) {
                FoldManager fm2 = this.host.getFoldManager();
                int hiddenCount = fm2.getHiddenLineCountAbove(line);
                line -= hiddenCount;
            }
            r10 = new Rectangle(alloc.x, alloc.y + line * this.lineHeight, alloc.width, this.lineHeight);
        }
        return r10;
    }

    @Override
    public Shape modelToView(int pos, Shape a10, Position.Bias b10) throws BadLocationException {
        Element map = this.getElement();
        RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
        int lineIndex = map.getElementIndex(pos);
        Token tokenList = doc.getTokenListForLine(lineIndex);
        Rectangle lineArea = this.lineToRect(a10, lineIndex);
        this.tabBase = lineArea.x;
        lineArea = tokenList.listOffsetToView((RSyntaxTextArea)this.getContainer(), this, pos, this.tabBase, lineArea);
        return lineArea;
    }

    @Override
    public Shape modelToView(int p02, Position.Bias b02, int p12, Position.Bias b12, Shape a10) throws BadLocationException {
        Rectangle r12;
        Shape s12;
        Shape s02 = this.modelToView(p02, a10, b02);
        if (p12 == this.getEndOffset()) {
            try {
                s12 = this.modelToView(p12, a10, b12);
            }
            catch (BadLocationException ble) {
                s12 = null;
            }
            if (s12 == null) {
                Rectangle alloc = a10 instanceof Rectangle ? (Rectangle)a10 : a10.getBounds();
                s12 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s12 = this.modelToView(p12, a10, b12);
        }
        Rectangle r02 = s02 instanceof Rectangle ? (Rectangle)s02 : s02.getBounds();
        Rectangle rectangle = r12 = s12 instanceof Rectangle ? (Rectangle)s12 : s12.getBounds();
        if (r02.y != r12.y) {
            Rectangle alloc = a10 instanceof Rectangle ? (Rectangle)a10 : a10.getBounds();
            r02.x = alloc.x;
            r02.width = alloc.width;
        }
        r02.add(r12);
        if (p12 > p02) {
            r02.width -= r12.width;
        }
        return r02;
    }

    @Override
    public float nextTabStop(float x10, int tabOffset) {
        if (this.tabSize == 0) {
            return x10;
        }
        int ntabs = ((int)x10 - this.tabBase) / this.tabSize;
        return (float)this.tabBase + ((float)ntabs + 1.0f) * (float)this.tabSize;
    }

    @Override
    public void paint(Graphics g10, Shape a10) {
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Rectangle alloc = a10.getBounds();
        this.tabBase = alloc.x;
        this.host = (RSyntaxTextArea)this.getContainer();
        Rectangle clip = g10.getClipBounds();
        this.clipStart = clip.x;
        this.clipEnd = this.clipStart + clip.width;
        this.lineHeight = this.host.getLineHeight();
        this.ascent = this.host.getMaxAscent();
        int heightAbove = clip.y - alloc.y;
        int linesAbove = Math.max(0, heightAbove / this.lineHeight);
        FoldManager fm2 = this.host.getFoldManager();
        linesAbove += fm2.getHiddenLineCountAbove(linesAbove, true);
        Rectangle lineArea = this.lineToRect(a10, linesAbove);
        int y10 = lineArea.y + this.ascent;
        int x10 = lineArea.x;
        Element map = this.getElement();
        int lineCount = map.getElementCount();
        int selStart = this.host.getSelectionStart();
        int selEnd = this.host.getSelectionEnd();
        RSyntaxTextAreaHighlighter h10 = (RSyntaxTextAreaHighlighter)this.host.getHighlighter();
        Graphics2D g2d = (Graphics2D)g10;
        TokenPainter painter = this.host.getTokenPainter();
        int line = linesAbove;
        while (y10 < clip.y + clip.height + this.ascent && line < lineCount) {
            Fold fold = fm2.getFoldForLine(line);
            Element lineElement = map.getElement(line);
            int startOffset = lineElement.getStartOffset();
            int endOffset = lineElement.getEndOffset() - 1;
            h10.paintLayeredHighlights(g2d, startOffset, endOffset, a10, this.host, this);
            Token token = document.getTokenListForLine(line);
            if (selStart == selEnd || startOffset >= selEnd || endOffset < selStart) {
                this.drawLine(painter, token, g2d, x10, y10, line);
            } else {
                this.drawLineWithSelection(painter, token, g2d, x10, y10, selStart, selEnd);
            }
            h10.paintParserHighlights(g2d, startOffset, endOffset, a10, this.host, this);
            if (fold != null && fold.isCollapsed()) {
                int hiddenLineCount;
                Color c10 = RSyntaxUtilities.getFoldedLineBottomColor(this.host);
                if (c10 != null) {
                    g10.setColor(c10);
                    g10.drawLine(x10, y10 + this.lineHeight - this.ascent - 1, this.host.getWidth(), y10 + this.lineHeight - this.ascent - 1);
                }
                while ((hiddenLineCount = fold.getLineCount()) != 0 && (fold = fm2.getFoldForLine(line += hiddenLineCount)) != null && fold.isCollapsed()) {
                }
            }
            y10 += this.lineHeight;
            ++line;
        }
    }

    private boolean possiblyUpdateLongLine(Element line, int lineNumber) {
        float w10 = this.getLineWidth(lineNumber);
        if (w10 > this.longLineWidth) {
            this.longLineWidth = w10;
            this.longLine = line;
            return true;
        }
        return false;
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a10, ViewFactory f10) {
        this.updateDamage(changes, a10, f10);
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.updateMetrics();
    }

    protected void updateDamage(DocumentEvent changes, Shape a10, ViewFactory f10) {
        Element[] removed;
        Container host = this.getContainer();
        this.updateMetrics();
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec2 = changes.getChange(elem);
        Element[] added = ec2 != null ? ec2.getChildrenAdded() : null;
        Element[] elementArray = removed = ec2 != null ? ec2.getChildrenRemoved() : null;
        if (added != null && added.length > 0 || removed != null && removed.length > 0) {
            int i10;
            if (added != null) {
                int addedAt = ec2.getIndex();
                i10 = 0;
                while (i10 < added.length) {
                    this.possiblyUpdateLongLine(added[i10], addedAt + i10);
                    ++i10;
                }
            }
            if (removed != null) {
                Element[] elementArray2 = removed;
                int n10 = removed.length;
                i10 = 0;
                while (i10 < n10) {
                    Element element = elementArray2[i10];
                    if (element == this.longLine) {
                        this.longLineWidth = -1.0f;
                        this.calculateLongestLine();
                        break;
                    }
                    ++i10;
                }
            }
            this.preferenceChanged(null, true, true);
            host.repaint();
        } else if (changes.getType() == DocumentEvent.EventType.CHANGE) {
            int startLine = changes.getOffset();
            int endLine = changes.getLength();
            this.damageLineRange(startLine, endLine, a10, host);
        } else {
            Element map = this.getElement();
            int line = map.getElementIndex(changes.getOffset());
            this.damageLineRange(line, line, a10, host);
            if (changes.getType() == DocumentEvent.EventType.INSERT) {
                Element e10 = map.getElement(line);
                if (e10 == this.longLine) {
                    this.longLineWidth = this.getLineWidth(line);
                    this.preferenceChanged(null, true, false);
                } else if (this.possiblyUpdateLongLine(e10, line)) {
                    this.preferenceChanged(null, true, false);
                }
            } else if (changes.getType() == DocumentEvent.EventType.REMOVE && map.getElement(line) == this.longLine) {
                this.longLineWidth = -1.0f;
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    private void updateMetrics() {
        this.host = (RSyntaxTextArea)this.getContainer();
        Font f10 = this.host.getFont();
        if (this.font != f10) {
            this.calculateLongestLine();
        }
    }

    @Override
    public int viewToModel(float fx2, float fy2, Shape a10, Position.Bias[] bias) {
        bias[0] = Position.Bias.Forward;
        Rectangle alloc = a10.getBounds();
        RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
        int x10 = (int)fx2;
        int y10 = (int)fy2;
        if (y10 < alloc.y) {
            return this.getStartOffset();
        }
        if (y10 > alloc.y + alloc.height) {
            return this.host.getLastVisibleOffset();
        }
        Element map = doc.getDefaultRootElement();
        this.lineHeight = this.host.getLineHeight();
        int lineIndex = Math.abs((y10 - alloc.y) / this.lineHeight);
        FoldManager fm2 = this.host.getFoldManager();
        if ((lineIndex += fm2.getHiddenLineCountAbove(lineIndex, true)) >= map.getElementCount()) {
            return this.host.getLastVisibleOffset();
        }
        Element line = map.getElement(lineIndex);
        if (x10 < alloc.x) {
            return line.getStartOffset();
        }
        if (x10 > alloc.x + alloc.width) {
            return line.getEndOffset() - 1;
        }
        int p02 = line.getStartOffset();
        Token tokenList = doc.getTokenListForLine(lineIndex);
        this.tabBase = alloc.x;
        int offs = tokenList.getListOffset((RSyntaxTextArea)this.getContainer(), this, this.tabBase, x10);
        return offs != -1 ? offs : p02;
    }

    @Override
    public int yForLine(Rectangle alloc, int line) throws BadLocationException {
        this.updateMetrics();
        if (this.metrics != null) {
            FoldManager fm2;
            int n10 = this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
            if (this.host != null && !(fm2 = this.host.getFoldManager()).isLineHidden(line)) {
                line -= fm2.getHiddenLineCountAbove(line);
                return alloc.y + line * this.lineHeight;
            }
        }
        return -1;
    }

    @Override
    public int yForLineContaining(Rectangle alloc, int offs) throws BadLocationException {
        Element map = this.getElement();
        int line = map.getElementIndex(offs);
        return this.yForLine(alloc, line);
    }
}

