/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Token;

public class TokenImpl
implements Token {
    public char[] text = null;
    public int textOffset = -1;
    public int textCount = -1;
    private int offset;
    private int type;
    private boolean hyperlink;
    private Token nextToken;
    private int languageIndex;

    public TokenImpl() {
        this.setType(0);
        this.setOffset(-1);
        this.hyperlink = false;
        this.nextToken = null;
    }

    public TokenImpl(Segment line, int beg, int end, int startOffset, int type, int languageIndex) {
        this(line.array, beg, end, startOffset, type, languageIndex);
    }

    public TokenImpl(char[] line, int beg, int end, int startOffset, int type, int languageIndex) {
        this();
        this.set(line, beg, end, startOffset, type);
        this.setLanguageIndex(languageIndex);
    }

    public TokenImpl(Token t22) {
        this();
        this.copyFrom(t22);
    }

    @Override
    public StringBuilder appendHTMLRepresentation(StringBuilder sb2, RSyntaxTextArea textArea, boolean fontFamily) {
        return this.appendHTMLRepresentation(sb2, textArea, fontFamily, false);
    }

    @Override
    public StringBuilder appendHTMLRepresentation(StringBuilder sb2, RSyntaxTextArea textArea, boolean fontFamily, boolean tabsToSpaces) {
        boolean needsFontTag;
        SyntaxScheme colorScheme = textArea.getSyntaxScheme();
        Style scheme = colorScheme.getStyle(this.getType());
        Font font = textArea.getFontForTokenType(this.getType());
        if (font.isBold()) {
            sb2.append("<b>");
        }
        if (font.isItalic()) {
            sb2.append("<em>");
        }
        if (scheme.underline || this.isHyperlink()) {
            sb2.append("<u>");
        }
        boolean bl2 = needsFontTag = fontFamily || !this.isWhitespace();
        if (needsFontTag) {
            sb2.append("<font");
            if (fontFamily) {
                sb2.append(" face=\"").append(font.getFamily()).append('\"');
            }
            if (!this.isWhitespace()) {
                sb2.append(" color=\"").append(TokenImpl.getHTMLFormatForColor(scheme.foreground)).append('\"');
            }
            sb2.append('>');
        }
        this.appendHtmlLexeme(textArea, sb2, tabsToSpaces);
        if (needsFontTag) {
            sb2.append("</font>");
        }
        if (scheme.underline || this.isHyperlink()) {
            sb2.append("</u>");
        }
        if (font.isItalic()) {
            sb2.append("</em>");
        }
        if (font.isBold()) {
            sb2.append("</b>");
        }
        return sb2;
    }

    private StringBuilder appendHtmlLexeme(RSyntaxTextArea textArea, StringBuilder sb2, boolean tabsToSpaces) {
        int i10;
        boolean lastWasSpace = false;
        int lastI = i10 = this.textOffset;
        String tabStr = null;
        while (i10 < this.textOffset + this.textCount) {
            char ch2 = this.text[i10];
            switch (ch2) {
                case ' ': {
                    sb2.append(this.text, lastI, i10 - lastI);
                    lastI = i10 + 1;
                    sb2.append(lastWasSpace ? "&nbsp;" : " ");
                    lastWasSpace = true;
                    break;
                }
                case '\t': {
                    sb2.append(this.text, lastI, i10 - lastI);
                    lastI = i10 + 1;
                    if (tabsToSpaces && tabStr == null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int j10 = 0;
                        while (j10 < textArea.getTabSize()) {
                            stringBuilder.append("&nbsp;");
                            ++j10;
                        }
                        tabStr = stringBuilder.toString();
                    }
                    sb2.append(tabsToSpaces ? tabStr : "&#09;");
                    lastWasSpace = false;
                    break;
                }
                case '&': {
                    sb2.append(this.text, lastI, i10 - lastI);
                    lastI = i10 + 1;
                    sb2.append("&amp;");
                    lastWasSpace = false;
                    break;
                }
                case '<': {
                    sb2.append(this.text, lastI, i10 - lastI);
                    lastI = i10 + 1;
                    sb2.append("&lt;");
                    lastWasSpace = false;
                    break;
                }
                case '>': {
                    sb2.append(this.text, lastI, i10 - lastI);
                    lastI = i10 + 1;
                    sb2.append("&gt;");
                    lastWasSpace = false;
                    break;
                }
                case '\'': {
                    sb2.append(this.text, lastI, i10 - lastI);
                    lastI = i10 + 1;
                    sb2.append("&#39;");
                    lastWasSpace = false;
                    break;
                }
                case '\"': {
                    sb2.append(this.text, lastI, i10 - lastI);
                    lastI = i10 + 1;
                    sb2.append("&#34;");
                    lastWasSpace = false;
                    break;
                }
                case '/': {
                    sb2.append(this.text, lastI, i10 - lastI);
                    lastI = i10 + 1;
                    sb2.append("&#47;");
                    lastWasSpace = false;
                    break;
                }
                default: {
                    lastWasSpace = false;
                }
            }
            ++i10;
        }
        if (lastI < this.textOffset + this.textCount) {
            sb2.append(this.text, lastI, this.textOffset + this.textCount - lastI);
        }
        return sb2;
    }

    @Override
    public char charAt(int index) {
        return this.text[this.textOffset + index];
    }

    @Override
    public boolean containsPosition(int pos) {
        return pos >= this.getOffset() && pos < this.getOffset() + this.textCount;
    }

    public void copyFrom(Token t22) {
        this.text = t22.getTextArray();
        this.textOffset = t22.getTextOffset();
        this.textCount = t22.length();
        this.setOffset(t22.getOffset());
        this.setType(t22.getType());
        this.hyperlink = t22.isHyperlink();
        this.languageIndex = t22.getLanguageIndex();
        this.nextToken = t22.getNextToken();
    }

    @Override
    public int documentToToken(int pos) {
        return pos + (this.textOffset - this.getOffset());
    }

    @Override
    public boolean endsWith(char[] ch2) {
        if (ch2 == null || ch2.length > this.textCount) {
            return false;
        }
        int start = this.textOffset + this.textCount - ch2.length;
        int i10 = 0;
        while (i10 < ch2.length) {
            if (this.text[start + i10] != ch2[i10]) {
                return false;
            }
            ++i10;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Token)) {
            return false;
        }
        Token t22 = (Token)obj;
        return this.offset == t22.getOffset() && this.type == t22.getType() && this.languageIndex == t22.getLanguageIndex() && this.hyperlink == t22.isHyperlink() && (this.getLexeme() == null && t22.getLexeme() == null || this.getLexeme() != null && this.getLexeme().equals(t22.getLexeme()));
    }

    @Override
    public int getEndOffset() {
        return this.offset + this.textCount;
    }

    private static String getHTMLFormatForColor(Color color) {
        String hexBlue;
        String hexGreen;
        if (color == null) {
            return "black";
        }
        String hexRed = Integer.toHexString(color.getRed());
        if (hexRed.length() == 1) {
            hexRed = "0" + hexRed;
        }
        if ((hexGreen = Integer.toHexString(color.getGreen())).length() == 1) {
            hexGreen = "0" + hexGreen;
        }
        if ((hexBlue = Integer.toHexString(color.getBlue())).length() == 1) {
            hexBlue = "0" + hexBlue;
        }
        return "#" + hexRed + hexGreen + hexBlue;
    }

    @Override
    public String getHTMLRepresentation(RSyntaxTextArea textArea) {
        StringBuilder buf = new StringBuilder();
        this.appendHTMLRepresentation(buf, textArea, true);
        return buf.toString();
    }

    @Override
    public int getLanguageIndex() {
        return this.languageIndex;
    }

    @Override
    public Token getLastNonCommentNonWhitespaceToken() {
        TokenImpl last = null;
        Token t10 = this;
        while (t10 != null && t10.isPaintable()) {
            switch (t10.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 21: {
                    break;
                }
                default: {
                    last = t10;
                }
            }
            t10 = t10.getNextToken();
        }
        return last;
    }

    @Override
    public Token getLastPaintableToken() {
        Token t10 = this;
        while (t10.isPaintable()) {
            Token next = t10.getNextToken();
            if (next == null || !next.isPaintable()) {
                return t10;
            }
            t10 = next;
        }
        return null;
    }

    @Override
    public String getLexeme() {
        if (this.text == null) {
            return null;
        }
        return this.isPaintable() ? new String(this.text, this.textOffset, this.textCount) : null;
    }

    @Override
    public int getListOffset(RSyntaxTextArea textArea, TabExpander e10, float x02, float x10) {
        if (x02 >= x10) {
            return this.getOffset();
        }
        float currX = x02;
        float nextX = x02;
        float stableX = x02;
        TokenImpl token = this;
        int last = this.getOffset();
        FontMetrics fm2 = null;
        while (token != null && token.isPaintable()) {
            fm2 = textArea.getFontMetricsForTokenType(token.getType());
            char[] text = token.text;
            int start = token.textOffset;
            int end = start + token.textCount;
            int i10 = start;
            while (i10 < end) {
                currX = nextX;
                if (text[i10] == '\t') {
                    stableX = nextX = e10.nextTabStop(nextX, 0);
                    start = i10 + 1;
                } else {
                    nextX = stableX + (float)fm2.charsWidth(text, start, i10 - start + 1);
                }
                if (x10 >= currX && x10 < nextX) {
                    if (x10 - currX < nextX - x10) {
                        return last + i10 - token.textOffset;
                    }
                    return last + i10 + 1 - token.textOffset;
                }
                ++i10;
            }
            stableX = nextX;
            last += token.textCount;
            token = (TokenImpl)token.getNextToken();
        }
        return last;
    }

    @Override
    public Token getNextToken() {
        return this.nextToken;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetBeforeX(RSyntaxTextArea textArea, TabExpander e10, float startX, float endBeforeX) {
        FontMetrics fm2 = textArea.getFontMetricsForTokenType(this.getType());
        int i10 = this.textOffset;
        int stop = i10 + this.textCount;
        float x10 = startX;
        while (i10 < stop) {
            x10 = this.text[i10] == '\t' ? e10.nextTabStop(x10, 0) : (x10 += (float)fm2.charWidth(this.text[i10]));
            if (x10 > endBeforeX) {
                int intoToken = Math.max(i10 - this.textOffset, 1);
                return this.getOffset() + intoToken;
            }
            ++i10;
        }
        return this.getOffset() + this.textCount - 1;
    }

    @Override
    public char[] getTextArray() {
        return this.text;
    }

    @Override
    public int getTextOffset() {
        return this.textOffset;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public float getWidth(RSyntaxTextArea textArea, TabExpander e10, float x02) {
        return this.getWidthUpTo(this.textCount, textArea, e10, x02);
    }

    @Override
    public float getWidthUpTo(int numChars, RSyntaxTextArea textArea, TabExpander e10, float x02) {
        float width = x02;
        FontMetrics fm2 = textArea.getFontMetricsForTokenType(this.getType());
        if (fm2 != null) {
            int w10;
            int currentStart = this.textOffset;
            int endBefore = this.textOffset + numChars;
            int i10 = currentStart;
            while (i10 < endBefore) {
                if (this.text[i10] == '\t') {
                    w10 = i10 - currentStart;
                    if (w10 > 0) {
                        width += (float)fm2.charsWidth(this.text, currentStart, w10);
                    }
                    currentStart = i10 + 1;
                    width = e10.nextTabStop(width, 0);
                }
                ++i10;
            }
            w10 = endBefore - currentStart;
            width += (float)fm2.charsWidth(this.text, currentStart, w10);
        }
        return width - x02;
    }

    public int hashCode() {
        return this.offset + (this.getLexeme() == null ? 0 : this.getLexeme().hashCode());
    }

    @Override
    public boolean is(char[] lexeme) {
        if (this.textCount == lexeme.length) {
            int i10 = 0;
            while (i10 < this.textCount) {
                if (this.text[this.textOffset + i10] != lexeme[i10]) {
                    return false;
                }
                ++i10;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean is(int type, char[] lexeme) {
        if (this.getType() == type && this.textCount == lexeme.length) {
            int i10 = 0;
            while (i10 < this.textCount) {
                if (this.text[this.textOffset + i10] != lexeme[i10]) {
                    return false;
                }
                ++i10;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean is(int type, String lexeme) {
        return this.getType() == type && this.textCount == lexeme.length() && lexeme.equals(this.getLexeme());
    }

    @Override
    public boolean isComment() {
        return this.getType() >= 1 && this.getType() <= 5;
    }

    @Override
    public boolean isCommentOrWhitespace() {
        return this.isComment() || this.isWhitespace();
    }

    @Override
    public boolean isHyperlink() {
        return this.hyperlink;
    }

    @Override
    public boolean isIdentifier() {
        return this.getType() == 20;
    }

    @Override
    public boolean isLeftCurly() {
        return this.getType() == 22 && this.isSingleChar('{');
    }

    @Override
    public boolean isRightCurly() {
        return this.getType() == 22 && this.isSingleChar('}');
    }

    @Override
    public boolean isPaintable() {
        return this.getType() > 0;
    }

    @Override
    public boolean isSingleChar(char ch2) {
        return this.textCount == 1 && this.text[this.textOffset] == ch2;
    }

    @Override
    public boolean isSingleChar(int type, char ch2) {
        return this.getType() == type && this.isSingleChar(ch2);
    }

    @Override
    public boolean isWhitespace() {
        return this.getType() == 21;
    }

    @Override
    public int length() {
        return this.textCount;
    }

    @Override
    public Rectangle listOffsetToView(RSyntaxTextArea textArea, TabExpander e10, int pos, int x02, Rectangle rect) {
        int stableX = x02;
        TokenImpl token = this;
        FontMetrics fm2 = null;
        Segment s10 = new Segment();
        while (token != null && token.isPaintable()) {
            fm2 = textArea.getFontMetricsForTokenType(token.getType());
            if (fm2 == null) {
                return rect;
            }
            char[] text = token.text;
            int start = token.textOffset;
            int end = start + token.textCount;
            if (token.containsPosition(pos)) {
                s10.array = token.text;
                s10.offset = token.textOffset;
                s10.count = pos - token.getOffset();
                int w10 = Utilities.getTabbedTextWidth(s10, fm2, stableX, e10, token.getOffset());
                rect.x = stableX + w10;
                end = token.documentToToken(pos);
                rect.width = text[end] == '\t' ? fm2.charWidth(' ') : fm2.charWidth(text[end]);
                return rect;
            }
            s10.array = token.text;
            s10.offset = token.textOffset;
            s10.count = token.textCount;
            stableX += Utilities.getTabbedTextWidth(s10, fm2, stableX, e10, token.getOffset());
            token = (TokenImpl)token.getNextToken();
        }
        rect.x = stableX;
        rect.width = 1;
        return rect;
    }

    public void makeStartAt(int pos) {
        if (pos < this.getOffset() || pos >= this.getOffset() + this.textCount) {
            throw new IllegalArgumentException("pos " + pos + " is not in range " + this.getOffset() + "-" + (this.getOffset() + this.textCount - 1));
        }
        int shift = pos - this.getOffset();
        this.setOffset(pos);
        this.textOffset += shift;
        this.textCount -= shift;
    }

    public void moveOffset(int amt2) {
        if (amt2 < 0 || amt2 > this.textCount) {
            throw new IllegalArgumentException("amt " + amt2 + " is not in range 0-" + this.textCount);
        }
        this.setOffset(this.getOffset() + amt2);
        this.textOffset += amt2;
        this.textCount -= amt2;
    }

    public void set(char[] line, int beg, int end, int offset, int type) {
        this.text = line;
        this.textOffset = beg;
        this.textCount = end - beg + 1;
        this.setType(type);
        this.setOffset(offset);
        this.nextToken = null;
    }

    @Override
    public void setHyperlink(boolean hyperlink) {
        this.hyperlink = hyperlink;
    }

    @Override
    public void setLanguageIndex(int languageIndex) {
        this.languageIndex = languageIndex;
    }

    public void setNextToken(Token nextToken) {
        this.nextToken = nextToken;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public boolean startsWith(char[] chars) {
        if (chars.length <= this.textCount) {
            int i10 = 0;
            while (i10 < chars.length) {
                if (this.text[this.textOffset + i10] != chars[i10]) {
                    return false;
                }
                ++i10;
            }
            return true;
        }
        return false;
    }

    @Override
    public int tokenToDocument(int pos) {
        return pos + (this.getOffset() - this.textOffset);
    }

    public String toString() {
        return "[Token: " + (this.getType() == 0 ? "<null token>" : "text: '" + (this.text == null ? "<null>" : String.valueOf(this.getLexeme()) + "'; " + "offset: " + this.getOffset() + "; type: " + this.getType() + "; " + "isPaintable: " + this.isPaintable() + "; nextToken==null: " + (this.nextToken == null))) + "]";
    }
}

