/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;

public final class TokenUtils {
    private TokenUtils() {
    }

    public static TokenSubList getSubTokenList(Token tokenList, int pos, TabExpander e10, RSyntaxTextArea textArea, float x02) {
        return TokenUtils.getSubTokenList(tokenList, pos, e10, textArea, x02, null);
    }

    public static TokenSubList getSubTokenList(Token tokenList, int pos, TabExpander e10, RSyntaxTextArea textArea, float x02, TokenImpl tempToken) {
        if (tempToken == null) {
            tempToken = new TokenImpl();
        }
        Token t10 = tokenList;
        while (t10 != null && t10.isPaintable() && !t10.containsPosition(pos)) {
            x02 += t10.getWidth(textArea, e10, x02);
            t10 = t10.getNextToken();
        }
        if (t10 != null && t10.isPaintable()) {
            if (t10.getOffset() != pos) {
                int difference = pos - t10.getOffset();
                x02 += t10.getWidthUpTo(t10.length() - difference + 1, textArea, e10, x02);
                tempToken.copyFrom(t10);
                tempToken.makeStartAt(pos);
                return new TokenSubList(tempToken, x02);
            }
            return new TokenSubList(t10, x02);
        }
        return new TokenSubList(tokenList, x02);
    }

    public static int getWhiteSpaceTokenLength(Token t10, int tabSize, int curOffs) {
        int length = 0;
        int i10 = 0;
        while (i10 < t10.length()) {
            char ch2 = t10.charAt(i10);
            if (ch2 == '\t') {
                int newCurOffs = (curOffs + tabSize) / tabSize * tabSize;
                length += newCurOffs - curOffs;
                curOffs = newCurOffs;
            } else {
                ++length;
                ++curOffs;
            }
            ++i10;
        }
        return length;
    }

    public static boolean isBlankOrAllWhiteSpace(Token t10) {
        while (t10 != null && t10.isPaintable()) {
            if (!t10.isCommentOrWhitespace()) {
                return false;
            }
            t10 = t10.getNextToken();
        }
        return true;
    }

    public static boolean isBlankOrAllWhiteSpaceWithoutComments(Token t10) {
        while (t10 != null && t10.isPaintable()) {
            if (!t10.isWhitespace()) {
                return false;
            }
            t10 = t10.getNextToken();
        }
        return true;
    }

    public static String tokenToHtml(RSyntaxTextArea textArea, Token token) {
        StringBuilder style = new StringBuilder();
        Font font = textArea.getFontForTokenType(token.getType());
        if (font.isBold()) {
            style.append("font-weight: bold;");
        }
        if (font.isItalic()) {
            style.append("font-style: italic;");
        }
        Color c10 = textArea.getForegroundForToken(token);
        style.append("color: ").append(HtmlUtil.getHexString(c10)).append(";");
        return "<span style=\"" + style + "\">" + HtmlUtil.escapeForHtml(token.getLexeme(), "\n", true) + "</span>";
    }

    public static class TokenSubList {
        public Token tokenList;
        public float x;

        public TokenSubList(Token tokenList, float x10) {
            this.tokenList = tokenList;
            this.x = x10;
        }
    }
}

