/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.DefaultTokenPainter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;

class VisibleWhitespaceTokenPainter
extends DefaultTokenPainter {
    VisibleWhitespaceTokenPainter() {
    }

    @Override
    protected float paintImpl(Token token, Graphics2D g10, float x10, float y10, RSyntaxTextArea host, TabExpander e10, float clipStart, boolean selected, boolean useSTC) {
        int origX = (int)x10;
        int textOffs = token.getTextOffset();
        char[] text = token.getTextArray();
        int end = textOffs + token.length();
        float nextX = x10;
        int flushLen = 0;
        int flushIndex = textOffs;
        Color fg2 = useSTC ? host.getSelectedTextColor() : host.getForegroundForToken(token);
        Color bg2 = selected ? null : host.getBackgroundForToken(token);
        g10.setFont(host.getFontForTokenType(token.getType()));
        FontMetrics fm2 = host.getFontMetricsForTokenType(token.getType());
        int ascent = fm2.getAscent();
        int height = fm2.getHeight();
        int i10 = textOffs;
        while (i10 < end) {
            switch (text[i10]) {
                case '\t': {
                    nextX = x10 + (float)fm2.charsWidth(text, flushIndex, flushLen);
                    float nextNextX = e10.nextTabStop(nextX, 0);
                    if (bg2 != null) {
                        this.paintBackground(x10, y10, nextNextX - x10, height, g10, ascent, host, bg2);
                    }
                    g10.setColor(fg2);
                    if (flushLen > 0) {
                        g10.drawChars(text, flushIndex, flushLen, (int)x10, (int)y10);
                        flushLen = 0;
                    }
                    flushIndex = i10 + 1;
                    int halfHeight = height / 2;
                    int quarterHeight = halfHeight / 2;
                    int ymid = (int)y10 - ascent + halfHeight;
                    g10.drawLine((int)nextX, ymid, (int)nextNextX, ymid);
                    g10.drawLine((int)nextNextX, ymid, (int)nextNextX - 4, ymid - quarterHeight);
                    g10.drawLine((int)nextNextX, ymid, (int)nextNextX - 4, ymid + quarterHeight);
                    x10 = nextNextX;
                    break;
                }
                case ' ': {
                    nextX = x10 + (float)fm2.charsWidth(text, flushIndex, flushLen + 1);
                    int width = fm2.charWidth(' ');
                    if (bg2 != null) {
                        this.paintBackground(x10, y10, nextX - x10, height, g10, ascent, host, bg2);
                    }
                    g10.setColor(fg2);
                    if (flushLen > 0) {
                        g10.drawChars(text, flushIndex, flushLen, (int)x10, (int)y10);
                        flushLen = 0;
                    }
                    int dotX = (int)(nextX - (float)width / 2.0f);
                    int dotY = (int)(y10 - (float)ascent + (float)height / 2.0f);
                    g10.drawLine(dotX, dotY, dotX, dotY);
                    flushIndex = i10 + 1;
                    x10 = nextX;
                    break;
                }
                default: {
                    ++flushLen;
                }
            }
            ++i10;
        }
        nextX = x10 + (float)fm2.charsWidth(text, flushIndex, flushLen);
        if (flushLen > 0 && nextX >= clipStart) {
            if (bg2 != null) {
                this.paintBackground(x10, y10, nextX - x10, height, g10, ascent, host, bg2);
            }
            g10.setColor(fg2);
            g10.drawChars(text, flushIndex, flushLen, (int)x10, (int)y10);
        }
        if (host.getUnderlineForToken(token)) {
            g10.setColor(fg2);
            int y22 = (int)(y10 + 1.0f);
            g10.drawLine(origX, y22, (int)nextX, y22);
        }
        if (host.getPaintTabLines() && origX == host.getMargin().left) {
            this.paintTabLines(token, origX, (int)y10, (int)nextX, g10, e10, host);
        }
        return nextX;
    }
}

