/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenPainter;
import org.fife.ui.rsyntaxtextarea.TokenUtils;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.Gutter;

public class WrappedSyntaxView
extends BoxView
implements TabExpander,
RSTAView {
    private int tabBase;
    private int tabSize;
    private Segment s;
    private Segment drawSeg;
    private Rectangle tempRect;
    private RSyntaxTextArea host;
    private FontMetrics metrics;
    private TokenImpl tempToken = new TokenImpl();
    private TokenImpl lineCountTempToken;
    private static final int MIN_WIDTH = 20;

    public WrappedSyntaxView(Element elem) {
        super(elem, 1);
        this.s = new Segment();
        this.drawSeg = new Segment();
        this.tempRect = new Rectangle();
        this.lineCountTempToken = new TokenImpl();
    }

    protected int calculateBreakPosition(int p02, Token tokenList, float x02) {
        int p10 = p02;
        RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
        float currentWidth = this.getWidth();
        if (currentWidth == 2.1474836E9f) {
            currentWidth = this.getPreferredSpan(0);
        }
        currentWidth = Math.max(currentWidth, 20.0f);
        Token t10 = tokenList;
        while (t10 != null && t10.isPaintable()) {
            float tokenWidth = t10.getWidth(textArea, this, x02);
            if (tokenWidth > currentWidth) {
                if (p10 == p02) {
                    return t10.getOffsetBeforeX(textArea, this, 0.0f, currentWidth);
                }
                return t10.isWhitespace() ? p10 + t10.length() : p10;
            }
            currentWidth -= tokenWidth;
            x02 += tokenWidth;
            p10 += t10.length();
            t10 = t10.getNextToken();
        }
        return p10 + 1;
    }

    @Override
    public void changedUpdate(DocumentEvent e10, Shape a10, ViewFactory f10) {
        this.updateChildren(e10, a10);
    }

    private void childAllocation2(int line, int y10, Rectangle alloc) {
        alloc.x += this.getOffset(0, line);
        alloc.y += y10;
        alloc.width = this.getSpan(0, line);
        alloc.height = this.getSpan(1, line);
        Insets margin = this.host.getMargin();
        if (margin != null) {
            alloc.y -= margin.top;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void drawView(TokenPainter painter, Graphics2D g, Rectangle r, View view, int fontHeight, int y, int line) {
        x = r.x;
        h = (RSyntaxTextAreaHighlighter)this.host.getHighlighter();
        document = (RSyntaxDocument)this.getDocument();
        map = this.getElement();
        p0 = view.getStartOffset();
        lineNumber = map.getElementIndex(p0);
        p1 = view.getEndOffset();
        this.setSegment(p0, p1 - 1, document, this.drawSeg);
        start = p0 - this.drawSeg.offset;
        token = document.getTokenListForLine(lineNumber);
        if (token == null || token.getType() != 0) ** GOTO lbl35
        h.paintLayeredHighlights(g, p0, p1, r, this.host, this);
        return;
lbl-1000:
        // 1 sources

        {
            p = this.calculateBreakPosition(p0, token, x);
            x = r.x;
            h.paintLayeredHighlights(g, p0, p, r, this.host, this);
            while (token != null && token.isPaintable() && token.getEndOffset() - 1 < p) {
                paintBG = this.host.getPaintTokenBackgrounds(line, y);
                x = painter.paint(token, g, x, y, this.host, this, 0.0f, paintBG);
                token = token.getNextToken();
            }
            if (token != null && token.isPaintable() && token.getOffset() < p) {
                tokenOffset = token.getOffset();
                this.tempToken.set(this.drawSeg.array, tokenOffset - start, p - 1 - start, tokenOffset, token.getType());
                this.tempToken.setLanguageIndex(token.getLanguageIndex());
                paintBG = this.host.getPaintTokenBackgrounds(line, y);
                painter.paint(this.tempToken, g, x, y, this.host, this, 0.0f, paintBG);
                this.tempToken.copyFrom(token);
                this.tempToken.makeStartAt(p);
                token = new TokenImpl(this.tempToken);
            }
            h.paintParserHighlights(g, p0, p, r, this.host, this);
            p0 = p == p0 ? p1 : p;
            y += fontHeight;
lbl35:
            // 2 sources

            ** while (token != null && token.isPaintable())
        }
lbl36:
        // 1 sources

        if (this.host.getEOLMarkersVisible()) {
            g.setColor(this.host.getForegroundForTokenType(21));
            g.setFont(this.host.getFontForTokenType(21));
            g.drawString("\u00b6", x, (float)y - (float)fontHeight);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void drawViewWithSelection(TokenPainter painter, Graphics2D g, Rectangle r, View view, int fontHeight, int y, int selStart, int selEnd) {
        x = r.x;
        useSTC = this.host.getUseSelectedTextColor();
        h = (RSyntaxTextAreaHighlighter)this.host.getHighlighter();
        document = (RSyntaxDocument)this.getDocument();
        map = this.getElement();
        p0 = view.getStartOffset();
        lineNumber = map.getElementIndex(p0);
        p1 = view.getEndOffset();
        this.setSegment(p0, p1 - 1, document, this.drawSeg);
        start = p0 - this.drawSeg.offset;
        token = document.getTokenListForLine(lineNumber);
        if (token == null || token.getType() != 0) ** GOTO lbl89
        h.paintLayeredHighlights(g, p0, p1, r, this.host, this);
        return;
lbl-1000:
        // 1 sources

        {
            p = this.calculateBreakPosition(p0, token, x);
            x = r.x;
            h.paintLayeredHighlights(g, p0, p, r, this.host, this);
            while (token != null && token.isPaintable() && token.getEndOffset() - 1 < p) {
                if (token.containsPosition(selStart)) {
                    if (selStart > token.getOffset()) {
                        this.tempToken.copyFrom(token);
                        this.tempToken.textCount = selStart - this.tempToken.getOffset();
                        x = painter.paint(this.tempToken, g, x, y, this.host, this);
                        this.tempToken.textCount = token.length();
                        this.tempToken.makeStartAt(selStart);
                        token = new TokenImpl(this.tempToken);
                    }
                    if ((selCount = Math.min(token.length(), selEnd - token.getOffset())) == token.length()) {
                        x = painter.paintSelected(token, g, x, y, this.host, this, useSTC);
                    } else {
                        this.tempToken.copyFrom(token);
                        this.tempToken.textCount = selCount;
                        x = painter.paintSelected(this.tempToken, g, x, y, this.host, this, useSTC);
                        this.tempToken.textCount = token.length();
                        this.tempToken.makeStartAt(token.getOffset() + selCount);
                        token = this.tempToken;
                        x = painter.paint(token, g, x, y, this.host, this);
                    }
                } else if (token.containsPosition(selEnd)) {
                    this.tempToken.copyFrom(token);
                    this.tempToken.textCount = selEnd - this.tempToken.getOffset();
                    x = painter.paintSelected(this.tempToken, g, x, y, this.host, this, useSTC);
                    this.tempToken.textCount = token.length();
                    this.tempToken.makeStartAt(selEnd);
                    token = this.tempToken;
                    x = painter.paint(token, g, x, y, this.host, this);
                } else {
                    x = token.getOffset() >= selStart && token.getEndOffset() <= selEnd ? painter.paintSelected(token, g, x, y, this.host, this, useSTC) : painter.paint(token, g, x, y, this.host, this);
                }
                token = token.getNextToken();
            }
            if (token != null && token.isPaintable() && token.getOffset() < p) {
                tokenOffset = token.getOffset();
                orig = token;
                token = new TokenImpl(this.drawSeg, tokenOffset - start, p - 1 - start, tokenOffset, token.getType(), token.getLanguageIndex());
                token.setLanguageIndex(token.getLanguageIndex());
                if (token.containsPosition(selStart)) {
                    if (selStart > token.getOffset()) {
                        this.tempToken.copyFrom(token);
                        this.tempToken.textCount = selStart - this.tempToken.getOffset();
                        x = painter.paint(this.tempToken, g, x, y, this.host, this);
                        this.tempToken.textCount = token.length();
                        this.tempToken.makeStartAt(selStart);
                        token = new TokenImpl(this.tempToken);
                    }
                    if ((selCount = Math.min(token.length(), selEnd - token.getOffset())) == token.length()) {
                        x = painter.paintSelected(token, g, x, y, this.host, this, useSTC);
                    } else {
                        this.tempToken.copyFrom(token);
                        this.tempToken.textCount = selCount;
                        x = painter.paintSelected(this.tempToken, g, x, y, this.host, this, useSTC);
                        this.tempToken.textCount = token.length();
                        this.tempToken.makeStartAt(token.getOffset() + selCount);
                        token = this.tempToken;
                        x = painter.paint(token, g, x, y, this.host, this);
                    }
                } else if (token.containsPosition(selEnd)) {
                    this.tempToken.copyFrom(token);
                    this.tempToken.textCount = selEnd - this.tempToken.getOffset();
                    x = painter.paintSelected(this.tempToken, g, x, y, this.host, this, useSTC);
                    this.tempToken.textCount = token.length();
                    this.tempToken.makeStartAt(selEnd);
                    token = this.tempToken;
                    x = painter.paint(token, g, x, y, this.host, this);
                } else {
                    x = token.getOffset() >= selStart && token.getEndOffset() <= selEnd ? painter.paintSelected(token, g, x, y, this.host, this, useSTC) : painter.paint(token, g, x, y, this.host, this);
                }
                token = new TokenImpl(orig);
                ((TokenImpl)token).makeStartAt(p);
            }
            h.paintParserHighlights(g, p0, p, r, this.host, this);
            p0 = p == p0 ? p1 : p;
            y += fontHeight;
lbl89:
            // 2 sources

            ** while (token != null && token.isPaintable())
        }
lbl90:
        // 1 sources

        if (this.host.getEOLMarkersVisible()) {
            g.setColor(this.host.getForegroundForTokenType(21));
            g.setFont(this.host.getFontForTokenType(21));
            g.drawString("\u00b6", x, (float)y - (float)fontHeight);
        }
    }

    @Override
    public Shape getChildAllocation(int index, Shape a10) {
        if (a10 != null) {
            Shape ca2 = this.getChildAllocationImpl(index, a10);
            if (ca2 != null && !this.isAllocationValid()) {
                Rectangle r10;
                Rectangle rectangle = r10 = ca2 instanceof Rectangle ? (Rectangle)ca2 : ca2.getBounds();
                if (r10.width == 0 && r10.height == 0) {
                    return null;
                }
            }
            return ca2;
        }
        return null;
    }

    public Shape getChildAllocationImpl(int line, Shape a10) {
        Rectangle alloc = this.getInsideAllocation(a10);
        this.host = (RSyntaxTextArea)this.getContainer();
        FoldManager fm2 = this.host.getFoldManager();
        int y10 = alloc.y;
        int i10 = 0;
        while (i10 < line) {
            y10 += this.getSpan(1, i10);
            Fold fold = fm2.getFoldForLine(i10);
            if (fold != null && fold.isCollapsed()) {
                i10 += fold.getCollapsedLineCount();
            }
            ++i10;
        }
        this.childAllocation2(line, y10, alloc);
        return alloc;
    }

    @Override
    public float getMaximumSpan(int axis) {
        this.updateMetrics();
        float span = super.getPreferredSpan(axis);
        if (axis == 0) {
            span += (float)this.metrics.charWidth('\u00b6');
        }
        return span;
    }

    @Override
    public float getMinimumSpan(int axis) {
        this.updateMetrics();
        float span = super.getPreferredSpan(axis);
        if (axis == 0) {
            span += (float)this.metrics.charWidth('\u00b6');
        }
        return span;
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        float span = 0.0f;
        if (axis == 0) {
            span = super.getPreferredSpan(axis);
            span += (float)this.metrics.charWidth('\u00b6');
        } else {
            span = super.getPreferredSpan(axis);
            this.host = (RSyntaxTextArea)this.getContainer();
            if (this.host.isCodeFoldingEnabled()) {
                int lineCount = this.host.getLineCount();
                FoldManager fm2 = this.host.getFoldManager();
                int i10 = 0;
                while (i10 < lineCount) {
                    if (fm2.isLineHidden(i10)) {
                        span -= (float)this.getSpan(1, i10);
                    }
                    ++i10;
                }
            }
        }
        return span;
    }

    protected int getTabSize() {
        Integer i10 = (Integer)this.getDocument().getProperty("tabSize");
        int size = i10 != null ? i10 : 5;
        return size;
    }

    @Override
    protected View getViewAtPoint(int x10, int y10, Rectangle alloc) {
        int lineCount = this.getViewCount();
        int curY = alloc.y + this.getOffset(1, 0);
        this.host = (RSyntaxTextArea)this.getContainer();
        FoldManager fm2 = this.host.getFoldManager();
        int line = 1;
        while (line < lineCount) {
            int span = this.getSpan(1, line - 1);
            if (y10 < curY + span) {
                this.childAllocation2(line - 1, curY, alloc);
                return this.getView(line - 1);
            }
            curY += span;
            Fold fold = fm2.getFoldForLine(line - 1);
            if (fold != null && fold.isCollapsed()) {
                line += fold.getCollapsedLineCount();
            }
            ++line;
        }
        this.childAllocation2(lineCount - 1, curY, alloc);
        return this.getView(lineCount - 1);
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a10, ViewFactory f10) {
        this.updateChildren(changes, a10);
        Rectangle alloc = a10 != null && this.isAllocationValid() ? this.getInsideAllocation(a10) : null;
        int pos = changes.getOffset();
        View v10 = this.getViewAtPosition(pos, alloc);
        if (v10 != null) {
            v10.insertUpdate(changes, alloc, f10);
        }
    }

    @Override
    protected void loadChildren(ViewFactory f10) {
        Element e10 = this.getElement();
        int n10 = e10.getElementCount();
        if (n10 > 0) {
            View[] added = new View[n10];
            int i10 = 0;
            while (i10 < n10) {
                added[i10] = new WrappedLine(e10.getElement(i10));
                ++i10;
            }
            this.replace(0, 0, added);
        }
    }

    @Override
    public Shape modelToView(int pos, Shape a10, Position.Bias b10) throws BadLocationException {
        View v10;
        int testPos;
        if (!this.isAllocationValid()) {
            Rectangle alloc = a10.getBounds();
            this.setSize(alloc.width, alloc.height);
        }
        boolean isBackward = b10 == Position.Bias.Backward;
        int n10 = testPos = isBackward ? Math.max(0, pos - 1) : pos;
        if (isBackward && testPos < this.getStartOffset()) {
            return null;
        }
        int vIndex = this.getViewIndexAtPosition(testPos);
        if (vIndex != -1 && vIndex < this.getViewCount() && (v10 = this.getView(vIndex)) != null && testPos >= v10.getStartOffset() && testPos < v10.getEndOffset()) {
            Shape childShape = this.getChildAllocation(vIndex, a10);
            if (childShape == null) {
                return null;
            }
            Shape retShape = v10.modelToView(pos, childShape, b10);
            if (retShape == null && v10.getEndOffset() == pos && ++vIndex < this.getViewCount()) {
                v10 = this.getView(vIndex);
                retShape = v10.modelToView(pos, this.getChildAllocation(vIndex, a10), b10);
            }
            return retShape;
        }
        throw new BadLocationException("Position not represented by view", pos);
    }

    @Override
    public Shape modelToView(int p02, Position.Bias b02, int p12, Position.Bias b12, Shape a10) throws BadLocationException {
        Rectangle r12;
        Shape s12;
        Shape s02 = this.modelToView(p02, a10, b02);
        if (p12 == this.getEndOffset()) {
            try {
                s12 = this.modelToView(p12, a10, b12);
            }
            catch (BadLocationException ble) {
                s12 = null;
            }
            if (s12 == null) {
                Rectangle alloc = a10 instanceof Rectangle ? (Rectangle)a10 : a10.getBounds();
                s12 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s12 = this.modelToView(p12, a10, b12);
        }
        Rectangle r02 = s02.getBounds();
        Rectangle rectangle = r12 = s12 instanceof Rectangle ? (Rectangle)s12 : s12.getBounds();
        if (r02.y != r12.y) {
            Rectangle alloc = a10 instanceof Rectangle ? (Rectangle)a10 : a10.getBounds();
            r02.x = alloc.x;
            r02.width = alloc.width;
        }
        r02.add(r12);
        if (p12 > p02) {
            r02.width -= r12.width;
        }
        return r02;
    }

    @Override
    public float nextTabStop(float x10, int tabOffset) {
        if (this.tabSize == 0) {
            return x10;
        }
        int ntabs = ((int)x10 - this.tabBase) / this.tabSize;
        return (float)this.tabBase + ((float)ntabs + 1.0f) * (float)this.tabSize;
    }

    @Override
    public void paint(Graphics g10, Shape a10) {
        Rectangle alloc = a10 instanceof Rectangle ? (Rectangle)a10 : a10.getBounds();
        this.tabBase = alloc.x;
        Graphics2D g2d = (Graphics2D)g10;
        this.host = (RSyntaxTextArea)this.getContainer();
        int ascent = this.host.getMaxAscent();
        int fontHeight = this.host.getLineHeight();
        FoldManager fm2 = this.host.getFoldManager();
        TokenPainter painter = this.host.getTokenPainter();
        Element root = this.getElement();
        int selStart = this.host.getSelectionStart();
        int selEnd = this.host.getSelectionEnd();
        int n10 = this.getViewCount();
        int x10 = alloc.x + this.getLeftInset();
        this.tempRect.y = alloc.y + this.getTopInset();
        Rectangle clip = g10.getClipBounds();
        int i10 = 0;
        while (i10 < n10) {
            this.tempRect.x = x10 + this.getOffset(0, i10);
            this.tempRect.width = this.getSpan(0, i10);
            this.tempRect.height = this.getSpan(1, i10);
            if (this.tempRect.intersects(clip)) {
                Element lineElement = root.getElement(i10);
                int startOffset = lineElement.getStartOffset();
                int endOffset = lineElement.getEndOffset() - 1;
                View view = this.getView(i10);
                if (selStart == selEnd || startOffset >= selEnd || endOffset < selStart) {
                    this.drawView(painter, g2d, alloc, view, fontHeight, this.tempRect.y + ascent, i10);
                } else {
                    this.drawViewWithSelection(painter, g2d, alloc, view, fontHeight, this.tempRect.y + ascent, selStart, selEnd);
                }
            }
            this.tempRect.y += this.tempRect.height;
            Fold possibleFold = fm2.getFoldForLine(i10);
            if (possibleFold != null && possibleFold.isCollapsed()) {
                i10 += possibleFold.getCollapsedLineCount();
                Color c10 = RSyntaxUtilities.getFoldedLineBottomColor(this.host);
                if (c10 != null) {
                    g10.setColor(c10);
                    g10.drawLine(x10, this.tempRect.y - 1, this.host.getWidth(), this.tempRect.y - 1);
                }
            }
            ++i10;
        }
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a10, ViewFactory f10) {
        this.updateChildren(changes, a10);
        Rectangle alloc = a10 != null && this.isAllocationValid() ? this.getInsideAllocation(a10) : null;
        int pos = changes.getOffset();
        View v10 = this.getViewAtPosition(pos, alloc);
        if (v10 != null) {
            v10.removeUpdate(changes, alloc, f10);
        }
    }

    private void setSegment(int p02, int p12, Document document, Segment seg) {
        try {
            document.getText(p02, p12 - p02, seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    @Override
    public void setSize(float width, float height) {
        this.updateMetrics();
        if ((int)width != this.getWidth()) {
            this.preferenceChanged(null, true, true);
            this.setWidthChangePending(true);
        }
        super.setSize(width, height);
        this.setWidthChangePending(false);
    }

    private void setWidthChangePending(boolean widthChangePending) {
        int count = this.getViewCount();
        int i10 = 0;
        while (i10 < count) {
            View v10 = this.getView(i10);
            if (v10 instanceof WrappedLine) {
                ((WrappedLine)v10).widthChangePending = widthChangePending;
            }
            ++i10;
        }
    }

    void updateChildren(DocumentEvent e10, Shape a10) {
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec2 = e10.getChange(elem);
        if (e10.getType() == DocumentEvent.EventType.CHANGE) {
            this.getContainer().repaint();
        } else if (ec2 != null) {
            Element[] removedElems = ec2.getChildrenRemoved();
            Element[] addedElems = ec2.getChildrenAdded();
            View[] added = new View[addedElems.length];
            int i10 = 0;
            while (i10 < addedElems.length) {
                added[i10] = new WrappedLine(addedElems[i10]);
                ++i10;
            }
            this.replace(ec2.getIndex(), removedElems.length, added);
            if (a10 != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    final void updateMetrics() {
        Container host = this.getContainer();
        Font f10 = host.getFont();
        this.metrics = host.getFontMetrics(f10);
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    @Override
    public int viewToModel(float x10, float y10, Shape a10, Position.Bias[] bias) {
        View v10;
        Rectangle alloc;
        int offs = -1;
        if (!this.isAllocationValid()) {
            alloc = a10.getBounds();
            this.setSize(alloc.width, alloc.height);
        }
        if ((v10 = this.getViewAtPoint((int)x10, (int)y10, alloc = this.getInsideAllocation(a10))) != null) {
            offs = v10.viewToModel(x10, y10, alloc, bias);
            if (this.host.isCodeFoldingEnabled() && v10 == this.getView(this.getViewCount() - 1) && offs == v10.getEndOffset() - 1) {
                offs = this.host.getLastVisibleOffset();
            }
        }
        return offs;
    }

    @Override
    public int yForLine(Rectangle alloc, int line) throws BadLocationException {
        return this.yForLineContaining(alloc, this.getElement().getElement(line).getStartOffset());
    }

    @Override
    public int yForLineContaining(Rectangle alloc, int offs) throws BadLocationException {
        Rectangle r10;
        if (this.isAllocationValid() && (r10 = (Rectangle)this.modelToView(offs, alloc, Position.Bias.Forward)) != null) {
            if (this.host.isCodeFoldingEnabled()) {
                int line = this.host.getLineOfOffset(offs);
                FoldManager fm2 = this.host.getFoldManager();
                if (fm2.isLineHidden(line)) {
                    return -1;
                }
            }
            return r10.y;
        }
        return -1;
    }

    class WrappedLine
    extends View {
        private int nlines;
        private boolean widthChangePending;

        WrappedLine(Element elem) {
            super(elem);
        }

        final int calculateLineCount() {
            int nlines = 0;
            int startOffset = this.getStartOffset();
            int p12 = this.getEndOffset();
            RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            Element map = doc.getDefaultRootElement();
            int line = map.getElementIndex(startOffset);
            Token tokenList = doc.getTokenListForLine(line);
            float x02 = 0.0f;
            int p02 = startOffset;
            while (p02 < p12) {
                ++nlines;
                TokenUtils.TokenSubList subList = TokenUtils.getSubTokenList(tokenList, p02, WrappedSyntaxView.this, textArea, x02, WrappedSyntaxView.this.lineCountTempToken);
                x02 = subList != null ? subList.x : x02;
                tokenList = subList != null ? subList.tokenList : null;
                int p10 = WrappedSyntaxView.this.calculateBreakPosition(p02, tokenList, x02);
                int n10 = p02 = p10 == p02 ? ++p10 : p10;
            }
            return nlines;
        }

        @Override
        public float getPreferredSpan(int axis) {
            switch (axis) {
                case 0: {
                    float width = WrappedSyntaxView.this.getWidth();
                    if (width == 2.1474836E9f) {
                        return 100.0f;
                    }
                    return width;
                }
                case 1: {
                    if (this.nlines == 0 || this.widthChangePending) {
                        this.nlines = this.calculateLineCount();
                        this.widthChangePending = false;
                    }
                    return this.nlines * ((RSyntaxTextArea)this.getContainer()).getLineHeight();
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }

        @Override
        public void paint(Graphics g10, Shape a10) {
        }

        @Override
        public Shape modelToView(int pos, Shape a10, Position.Bias b10) throws BadLocationException {
            Rectangle alloc = a10.getBounds();
            RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
            alloc.height = textArea.getLineHeight();
            alloc.width = 1;
            int p02 = this.getStartOffset();
            int p12 = this.getEndOffset();
            int testP = b10 == Position.Bias.Forward ? pos : Math.max(p02, pos - 1);
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            Element map = doc.getDefaultRootElement();
            int line = map.getElementIndex(p02);
            Token tokenList = doc.getTokenListForLine(line);
            float x02 = alloc.x;
            while (p02 < p12) {
                TokenUtils.TokenSubList subList = TokenUtils.getSubTokenList(tokenList, p02, WrappedSyntaxView.this, textArea, x02, WrappedSyntaxView.this.lineCountTempToken);
                x02 = subList != null ? subList.x : x02;
                tokenList = subList != null ? subList.tokenList : null;
                int p10 = WrappedSyntaxView.this.calculateBreakPosition(p02, tokenList, x02);
                if (pos >= p02 && testP < p10) {
                    alloc = RSyntaxUtilities.getLineWidthUpTo(textArea, WrappedSyntaxView.this.s, p02, pos, WrappedSyntaxView.this, alloc, alloc.x);
                    return alloc;
                }
                if (p10 == p12 - 1 && pos == p12 - 1) {
                    if (pos > p02) {
                        alloc = RSyntaxUtilities.getLineWidthUpTo(textArea, WrappedSyntaxView.this.s, p02, pos, WrappedSyntaxView.this, alloc, alloc.x);
                    }
                    return alloc;
                }
                p02 = p10 == p02 ? p12 : p10;
                alloc.y += alloc.height;
            }
            throw new BadLocationException(null, pos);
        }

        @Override
        public int viewToModel(float fx2, float fy2, Shape a10, Position.Bias[] bias) {
            bias[0] = Position.Bias.Forward;
            Rectangle alloc = (Rectangle)a10;
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            int x10 = (int)fx2;
            int y10 = (int)fy2;
            if (y10 < alloc.y) {
                return this.getStartOffset();
            }
            if (y10 > alloc.y + alloc.height) {
                return this.getEndOffset() - 1;
            }
            RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
            alloc.height = textArea.getLineHeight();
            int p12 = this.getEndOffset();
            Element map = doc.getDefaultRootElement();
            int p02 = this.getStartOffset();
            int line = map.getElementIndex(p02);
            Token tlist = doc.getTokenListForLine(line);
            while (p02 < p12) {
                TokenUtils.TokenSubList subList = TokenUtils.getSubTokenList(tlist, p02, WrappedSyntaxView.this, textArea, alloc.x, WrappedSyntaxView.this.lineCountTempToken);
                tlist = subList != null ? subList.tokenList : null;
                int p10 = WrappedSyntaxView.this.calculateBreakPosition(p02, tlist, alloc.x);
                if (y10 >= alloc.y && y10 < alloc.y + alloc.height) {
                    if (x10 < alloc.x) {
                        return p02;
                    }
                    if (x10 > alloc.x + alloc.width) {
                        return p10 - 1;
                    }
                    if (tlist != null) {
                        int n10 = tlist.getListOffset(textArea, WrappedSyntaxView.this, alloc.x, x10);
                        return Math.max(Math.min(n10, p10 - 1), p02);
                    }
                }
                p02 = p10 == p02 ? p12 : p10;
                alloc.y += alloc.height;
            }
            return this.getEndOffset() - 1;
        }

        private void handleDocumentEvent(DocumentEvent e10, Shape a10, ViewFactory f10) {
            int n10 = this.calculateLineCount();
            if (this.nlines != n10) {
                this.nlines = n10;
                WrappedSyntaxView.this.preferenceChanged(this, false, true);
                RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
                textArea.repaint();
                Gutter gutter = RSyntaxUtilities.getGutter(textArea);
                if (gutter != null) {
                    gutter.revalidate();
                    gutter.repaint();
                }
            } else if (a10 != null) {
                Container c10 = this.getContainer();
                Rectangle alloc = (Rectangle)a10;
                c10.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e10, Shape a10, ViewFactory f10) {
            this.handleDocumentEvent(e10, a10, f10);
        }

        @Override
        public void removeUpdate(DocumentEvent e10, Shape a10, ViewFactory f10) {
            this.handleDocumentEvent(e10, a10, f10);
        }
    }
}

