/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipWindow;

public class FocusableTip {
    private JTextArea textArea;
    private TipWindow tipWindow;
    private URL imageBase;
    private TextAreaListener textAreaListener;
    private HyperlinkListener hyperlinkListener;
    private String lastText;
    private Dimension maxSize;
    private Rectangle tipVisibleBounds;
    private static final int X_MARGIN = 18;
    private static final int Y_MARGIN = 12;
    private static final ResourceBundle MSG = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.focusabletip.FocusableTip");

    public FocusableTip(JTextArea textArea, HyperlinkListener listener) {
        this.setTextArea(textArea);
        this.hyperlinkListener = listener;
        this.textAreaListener = new TextAreaListener();
        this.tipVisibleBounds = new Rectangle();
    }

    private void computeTipVisibleBounds() {
        Rectangle r10 = this.tipWindow.getBounds();
        Point p10 = r10.getLocation();
        SwingUtilities.convertPointFromScreen(p10, this.textArea);
        r10.setLocation(p10);
        this.tipVisibleBounds.setBounds(r10.x, r10.y - 15, r10.width, r10.height + 30);
    }

    private void createAndShowTipWindow(MouseEvent e10, String text) {
        Window owner = SwingUtilities.getWindowAncestor(this.textArea);
        this.tipWindow = new TipWindow(owner, this, text);
        this.tipWindow.setHyperlinkListener(this.hyperlinkListener);
        PopupWindowDecorator decorator = PopupWindowDecorator.get();
        if (decorator != null) {
            decorator.decorate(this.tipWindow);
        }
        this.invokeLater(() -> {
            if (this.tipWindow == null) {
                return;
            }
            this.tipWindow.fixSize();
            ComponentOrientation o10 = this.textArea.getComponentOrientation();
            Point p10 = e10.getPoint();
            SwingUtilities.convertPointToScreen(p10, this.textArea);
            Rectangle sb2 = TipUtil.getScreenBoundsForPoint(p10.x, p10.y);
            int y10 = p10.y + 12;
            if (y10 + this.tipWindow.getHeight() >= sb2.y + sb2.height && (y10 = p10.y - 12 - this.tipWindow.getHeight()) < sb2.y) {
                y10 = sb2.y + 12;
            }
            int x10 = p10.x - 18;
            if (!o10.isLeftToRight()) {
                x10 = p10.x - this.tipWindow.getWidth() + 18;
            }
            if (x10 < sb2.x) {
                x10 = sb2.x;
            } else if (x10 + this.tipWindow.getWidth() > sb2.x + sb2.width) {
                x10 = sb2.x + sb2.width - this.tipWindow.getWidth();
            }
            this.tipWindow.setLocation(x10, y10);
            this.tipWindow.setVisible(true);
            this.computeTipVisibleBounds();
            this.textAreaListener.install(this.textArea);
            this.lastText = text;
        });
    }

    public URL getImageBase() {
        return this.imageBase;
    }

    public Dimension getMaxSize() {
        return this.maxSize;
    }

    static String getString(String key) {
        return MSG.getString(key);
    }

    protected void invokeLater(Runnable r10) {
        SwingUtilities.invokeLater(r10);
    }

    public void possiblyDisposeOfTipWindow() {
        if (this.tipWindow != null) {
            this.tipWindow.dispose();
            this.tipWindow = null;
            this.textAreaListener.uninstall();
            this.tipVisibleBounds.setBounds(-1, -1, 0, 0);
            this.lastText = null;
            this.textArea.requestFocus();
        }
    }

    void removeListeners() {
        this.textAreaListener.uninstall();
    }

    public void setImageBase(URL url) {
        this.imageBase = url;
    }

    public void setMaxSize(Dimension maxSize) {
        this.maxSize = maxSize;
    }

    private void setTextArea(JTextArea textArea) {
        this.textArea = textArea;
        ToolTipManager.sharedInstance().registerComponent(textArea);
    }

    public void toolTipRequested(MouseEvent e10, String text) {
        if (text == null || text.length() == 0) {
            this.possiblyDisposeOfTipWindow();
            this.lastText = text;
            return;
        }
        if (this.lastText == null || text.length() != this.lastText.length() || !text.equals(this.lastText)) {
            this.possiblyDisposeOfTipWindow();
            this.createAndShowTipWindow(e10, text);
        }
    }

    private class TextAreaListener
    extends MouseInputAdapter
    implements CaretListener,
    ComponentListener,
    FocusListener,
    KeyListener {
        private TextAreaListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e10) {
            Object source = e10.getSource();
            if (source == FocusableTip.this.textArea) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e10) {
            this.handleComponentEvent(e10);
        }

        @Override
        public void componentMoved(ComponentEvent e10) {
            this.handleComponentEvent(e10);
        }

        @Override
        public void componentResized(ComponentEvent e10) {
            this.handleComponentEvent(e10);
        }

        @Override
        public void componentShown(ComponentEvent e10) {
            this.handleComponentEvent(e10);
        }

        @Override
        public void focusGained(FocusEvent e10) {
        }

        @Override
        public void focusLost(FocusEvent e10) {
            boolean tipClicked;
            Component c10 = e10.getOppositeComponent();
            boolean bl2 = tipClicked = c10 instanceof TipWindow || c10 != null && SwingUtilities.getWindowAncestor(c10) instanceof TipWindow;
            if (!tipClicked) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        private void handleComponentEvent(ComponentEvent e10) {
            FocusableTip.this.possiblyDisposeOfTipWindow();
        }

        public void install(JTextArea textArea) {
            textArea.addCaretListener(this);
            textArea.addComponentListener(this);
            textArea.addFocusListener(this);
            textArea.addKeyListener(this);
            textArea.addMouseListener(this);
            textArea.addMouseMotionListener(this);
        }

        @Override
        public void keyPressed(KeyEvent e10) {
            if (e10.getKeyCode() == 27) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            } else if (e10.getKeyCode() == 113 && FocusableTip.this.tipWindow != null && !FocusableTip.this.tipWindow.getFocusableWindowState()) {
                FocusableTip.this.tipWindow.actionPerformed(null);
                e10.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e10) {
        }

        @Override
        public void keyTyped(KeyEvent e10) {
        }

        @Override
        public void mouseExited(MouseEvent e10) {
        }

        @Override
        public void mouseMoved(MouseEvent e10) {
            if (FocusableTip.this.tipVisibleBounds == null || !FocusableTip.this.tipVisibleBounds.contains(e10.getPoint())) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        public void uninstall() {
            FocusableTip.this.textArea.removeCaretListener(this);
            FocusableTip.this.textArea.removeComponentListener(this);
            FocusableTip.this.textArea.removeFocusListener(this);
            FocusableTip.this.textArea.removeKeyListener(this);
            FocusableTip.this.textArea.removeMouseListener(this);
            FocusableTip.this.textArea.removeMouseMotionListener(this);
        }
    }
}

