/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

class SizeGrip
extends JPanel {
    SizeGrip() {
        MouseHandler adapter = new MouseHandler();
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
        this.setPreferredSize(new Dimension(16, 16));
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o10) {
        this.possiblyFixCursor(o10.isLeftToRight());
        super.applyComponentOrientation(o10);
    }

    @Override
    protected void paintComponent(Graphics g10) {
        super.paintComponent(g10);
        Dimension dim = this.getSize();
        Color c12 = UIManager.getColor("Label.disabledShadow");
        Color c22 = UIManager.getColor("Label.disabledForeground");
        ComponentOrientation orientation = this.getComponentOrientation();
        if (orientation.isLeftToRight()) {
            int width = dim.width -= 3;
            int height = dim.height -= 3;
            g10.setColor(c12);
            g10.fillRect(width - 9, height - 1, 3, 3);
            g10.fillRect(width - 5, height - 1, 3, 3);
            g10.fillRect(width - 1, height - 1, 3, 3);
            g10.fillRect(width - 5, height - 5, 3, 3);
            g10.fillRect(width - 1, height - 5, 3, 3);
            g10.fillRect(width - 1, height - 9, 3, 3);
            g10.setColor(c22);
            g10.fillRect(width - 9, height - 1, 2, 2);
            g10.fillRect(width - 5, height - 1, 2, 2);
            g10.fillRect(width - 1, height - 1, 2, 2);
            g10.fillRect(width - 5, height - 5, 2, 2);
            g10.fillRect(width - 1, height - 5, 2, 2);
            g10.fillRect(width - 1, height - 9, 2, 2);
        } else {
            int height = dim.height -= 3;
            g10.setColor(c12);
            g10.fillRect(10, height - 1, 3, 3);
            g10.fillRect(6, height - 1, 3, 3);
            g10.fillRect(2, height - 1, 3, 3);
            g10.fillRect(6, height - 5, 3, 3);
            g10.fillRect(2, height - 5, 3, 3);
            g10.fillRect(2, height - 9, 3, 3);
            g10.setColor(c22);
            g10.fillRect(10, height - 1, 2, 2);
            g10.fillRect(6, height - 1, 2, 2);
            g10.fillRect(2, height - 1, 2, 2);
            g10.fillRect(6, height - 5, 2, 2);
            g10.fillRect(2, height - 5, 2, 2);
            g10.fillRect(2, height - 9, 2, 2);
        }
    }

    protected void possiblyFixCursor(boolean ltr) {
        int cursor = 7;
        if (ltr) {
            cursor = 6;
        }
        if (cursor != this.getCursor().getType()) {
            this.setCursor(Cursor.getPredefinedCursor(cursor));
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private Point origPos;

        private MouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e10) {
            Point newPos = e10.getPoint();
            SwingUtilities.convertPointToScreen(newPos, SizeGrip.this);
            int xDelta = newPos.x - this.origPos.x;
            int yDelta = newPos.y - this.origPos.y;
            Window wind = SwingUtilities.getWindowAncestor(SizeGrip.this);
            if (wind != null) {
                if (SizeGrip.this.getComponentOrientation().isLeftToRight()) {
                    int w10 = wind.getWidth();
                    if (newPos.x >= wind.getX()) {
                        w10 += xDelta;
                    }
                    int h10 = wind.getHeight();
                    if (newPos.y >= wind.getY()) {
                        h10 += yDelta;
                    }
                    wind.setSize(w10, h10);
                } else {
                    int newW = Math.max(1, wind.getWidth() - xDelta);
                    int newH = Math.max(1, wind.getHeight() + yDelta);
                    wind.setBounds(newPos.x, wind.getY(), newW, newH);
                }
                wind.invalidate();
                wind.validate();
            }
            this.origPos.setLocation(newPos);
        }

        @Override
        public void mousePressed(MouseEvent e10) {
            this.origPos = e10.getPoint();
            SwingUtilities.convertPointToScreen(this.origPos, SizeGrip.this);
        }

        @Override
        public void mouseReleased(MouseEvent e10) {
            this.origPos = null;
        }
    }
}

