/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.html.HTMLDocument;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rtextarea.RTextArea;

public final class TipUtil {
    private TipUtil() {
    }

    public static Rectangle getScreenBoundsForPoint(int x10, int y10) {
        GraphicsDevice[] devices;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = devices = env.getScreenDevices();
        int n10 = devices.length;
        int n11 = 0;
        while (n11 < n10) {
            GraphicsConfiguration[] configs;
            GraphicsDevice device = graphicsDeviceArray[n11];
            GraphicsConfiguration[] graphicsConfigurationArray = configs = device.getConfigurations();
            int n12 = configs.length;
            int n13 = 0;
            while (n13 < n12) {
                GraphicsConfiguration config = graphicsConfigurationArray[n13];
                Rectangle gcBounds = config.getBounds();
                if (gcBounds.contains(x10, y10)) {
                    return gcBounds;
                }
                ++n13;
            }
            ++n11;
        }
        return env.getMaximumWindowBounds();
    }

    public static Color getToolTipBackground() {
        return TipUtil.getToolTipBackground(null);
    }

    public static Color getToolTipBackground(RTextArea textArea) {
        if (textArea != null && !Color.WHITE.equals(textArea.getBackground())) {
            return textArea.getBackground();
        }
        Color c10 = UIManager.getColor("ToolTip.background");
        boolean isNimbus = TipUtil.isNimbusLookAndFeel();
        if ((c10 == null || isNimbus) && ((c10 = UIManager.getColor("info")) == null || isNimbus && TipUtil.isDerivedColor(c10))) {
            c10 = SystemColor.info;
        }
        if (c10 instanceof ColorUIResource) {
            c10 = new Color(c10.getRGB());
        }
        return c10;
    }

    public static Border getToolTipBorder() {
        return TipUtil.getToolTipBorder(null);
    }

    public static Border getToolTipBorder(RTextArea textArea) {
        Color color;
        if (textArea != null && !Color.WHITE.equals(textArea.getBackground()) && (color = textArea.getBackground()) != null) {
            return BorderFactory.createLineBorder(color.brighter());
        }
        Border border = UIManager.getBorder("ToolTip.border");
        if ((border == null || TipUtil.isNimbusLookAndFeel()) && (border = UIManager.getBorder("nimbusBorder")) == null) {
            border = BorderFactory.createLineBorder(SystemColor.controlDkShadow);
        }
        return border;
    }

    private static boolean isDerivedColor(Color c10) {
        return c10 != null && c10.getClass().getName().endsWith(".DerivedColor");
    }

    private static boolean isNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getName().equals("Nimbus");
    }

    public static void tweakTipEditorPane(JEditorPane textArea) {
        boolean isNimbus = TipUtil.isNimbusLookAndFeel();
        if (isNimbus) {
            Color selBG = textArea.getSelectionColor();
            Color selFG = textArea.getSelectedTextColor();
            textArea.setUI(new BasicEditorPaneUI());
            textArea.setSelectedTextColor(selFG);
            textArea.setSelectionColor(selBG);
        }
        textArea.setEditable(false);
        textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textArea.getCaret().setSelectionVisible(true);
        Color fg2 = UIManager.getColor("Label.foreground");
        if (fg2 == null || isNimbus && TipUtil.isDerivedColor(fg2)) {
            fg2 = SystemColor.textText;
        }
        textArea.setForeground(fg2);
        textArea.setBackground(TipUtil.getToolTipBackground());
        Font font = UIManager.getFont("Label.font");
        if (font == null) {
            font = new Font("SansSerif", 0, 12);
        }
        HTMLDocument doc = (HTMLDocument)textArea.getDocument();
        TipUtil.setFont(doc, font, fg2);
        Color linkFG = RSyntaxUtilities.getHyperlinkForeground();
        doc.getStyleSheet().addRule("a { color: " + HtmlUtil.getHexString(linkFG) + "; }");
    }

    public static void setFont(HTMLDocument doc, Font font, Color fg2) {
        doc.getStyleSheet().addRule("body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt" + "; color: " + HtmlUtil.getHexString(fg2) + "; }");
    }
}

