/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class JsonFoldParser
implements FoldParser {
    private static final Object OBJECT_BLOCK = new Object();
    private static final Object ARRAY_BLOCK = new Object();

    @Override
    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        Stack<Object> blocks = new Stack<Object>();
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Fold currentFold = null;
        int lineCount = textArea.getLineCount();
        try {
            int line = 0;
            while (line < lineCount) {
                Token t10 = textArea.getTokenListForLine(line);
                while (t10 != null && t10.isPaintable()) {
                    Fold parentFold;
                    if (t10.isLeftCurly()) {
                        if (currentFold == null) {
                            currentFold = new Fold(0, textArea, t10.getOffset());
                            folds.add(currentFold);
                        } else {
                            currentFold = currentFold.createChild(0, t10.getOffset());
                        }
                        blocks.push(OBJECT_BLOCK);
                    } else if (t10.isRightCurly() && JsonFoldParser.popOffTop(blocks, OBJECT_BLOCK)) {
                        if (currentFold != null) {
                            currentFold.setEndOffset(t10.getOffset());
                            parentFold = currentFold.getParent();
                            if (currentFold.isOnSingleLine() && !currentFold.removeFromParent()) {
                                folds.remove(folds.size() - 1);
                            }
                            currentFold = parentFold;
                        }
                    } else if (JsonFoldParser.isLeftBracket(t10)) {
                        if (currentFold == null) {
                            currentFold = new Fold(0, textArea, t10.getOffset());
                            folds.add(currentFold);
                        } else {
                            currentFold = currentFold.createChild(0, t10.getOffset());
                        }
                        blocks.push(ARRAY_BLOCK);
                    } else if (JsonFoldParser.isRightBracket(t10) && JsonFoldParser.popOffTop(blocks, ARRAY_BLOCK) && currentFold != null) {
                        currentFold.setEndOffset(t10.getOffset());
                        parentFold = currentFold.getParent();
                        if (currentFold.isOnSingleLine() && !currentFold.removeFromParent()) {
                            folds.remove(folds.size() - 1);
                        }
                        currentFold = parentFold;
                    }
                    t10 = t10.getNextToken();
                }
                ++line;
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }

    private static boolean isLeftBracket(Token t10) {
        return t10.getType() == 22 && t10.isSingleChar('[');
    }

    private static boolean isRightBracket(Token t10) {
        return t10.getType() == 22 && t10.isSingleChar(']');
    }

    private static boolean popOffTop(Stack<Object> stack, Object value) {
        if (stack.size() > 0 && stack.peek() == value) {
            stack.pop();
            return true;
        }
        return false;
    }
}

