/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class LatexFoldParser
implements FoldParser {
    private static final char[] BEGIN = "\\begin".toCharArray();
    private static final char[] END = "\\end".toCharArray();

    @Override
    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Stack<String> expectedStack = new Stack<String>();
        Fold currentFold = null;
        int lineCount = textArea.getLineCount();
        try {
            int line = 0;
            while (line < lineCount) {
                Token t10 = textArea.getTokenListForLine(line);
                while (t10 != null && t10.isPaintable()) {
                    Token temp;
                    if (t10.is(6, BEGIN)) {
                        temp = t10.getNextToken();
                        if (temp != null && temp.isLeftCurly() && (temp = temp.getNextToken()) != null && temp.getType() == 6) {
                            if (currentFold == null) {
                                currentFold = new Fold(0, textArea, t10.getOffset());
                                folds.add(currentFold);
                            } else {
                                currentFold = currentFold.createChild(0, t10.getOffset());
                            }
                            expectedStack.push(temp.getLexeme());
                            t10 = temp;
                        }
                    } else if (t10.is(6, END) && currentFold != null && !expectedStack.isEmpty() && (temp = t10.getNextToken()) != null && temp.isLeftCurly() && (temp = temp.getNextToken()) != null && temp.getType() == 6) {
                        String value = temp.getLexeme();
                        if (((String)expectedStack.peek()).equals(value)) {
                            expectedStack.pop();
                            currentFold.setEndOffset(t10.getOffset());
                            Fold parentFold = currentFold.getParent();
                            if (currentFold.isOnSingleLine() && !currentFold.removeFromParent()) {
                                folds.remove(folds.size() - 1);
                            }
                            t10 = temp;
                            currentFold = parentFold;
                        }
                    }
                    t10 = t10.getNextToken();
                }
                ++line;
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }
}

