/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenUtils;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class LinesWithContentFoldParser
implements FoldParser {
    @Override
    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Fold fold = null;
        int lineCount = textArea.getLineCount();
        try {
            int line = 0;
            while (line < lineCount) {
                Token t10 = textArea.getTokenListForLine(line);
                if (!TokenUtils.isBlankOrAllWhiteSpaceWithoutComments(t10)) {
                    if (fold == null) {
                        fold = new Fold(0, textArea, t10.getOffset());
                        folds.add(fold);
                    }
                } else if (fold != null) {
                    fold.setEndOffset(textArea.getLineStartOffset(line) - 1);
                    if (fold.isOnSingleLine()) {
                        folds.remove(folds.size() - 1);
                    }
                    fold = null;
                }
                ++line;
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }
}

