/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class NsisFoldParser
implements FoldParser {
    private static final char[] KEYWORD_FUNCTION = "Function".toCharArray();
    private static final char[] KEYWORD_FUNCTION_END = "FunctionEnd".toCharArray();
    private static final char[] KEYWORD_SECTION = "Section".toCharArray();
    private static final char[] KEYWORD_SECTION_END = "SectionEnd".toCharArray();
    protected static final char[] C_MLC_END = "*/".toCharArray();

    private static boolean foundEndKeyword(char[] keyword, Token t10, Stack<char[]> endWordStack) {
        return t10.is(6, keyword) && !endWordStack.isEmpty() && keyword == endWordStack.peek();
    }

    @Override
    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Fold currentFold = null;
        int lineCount = textArea.getLineCount();
        boolean inMLC = false;
        int mlcStart = 0;
        Stack<char[]> endWordStack = new Stack<char[]>();
        try {
            int line = 0;
            while (line < lineCount) {
                Token t10 = textArea.getTokenListForLine(line);
                while (t10 != null && t10.isPaintable()) {
                    if (t10.isComment()) {
                        if (inMLC) {
                            if (t10.endsWith(C_MLC_END)) {
                                int mlcEnd = t10.getEndOffset() - 1;
                                if (currentFold == null) {
                                    currentFold = new Fold(1, textArea, mlcStart);
                                    currentFold.setEndOffset(mlcEnd);
                                    folds.add(currentFold);
                                    currentFold = null;
                                } else {
                                    currentFold = currentFold.createChild(1, mlcStart);
                                    currentFold.setEndOffset(mlcEnd);
                                    currentFold = currentFold.getParent();
                                }
                                inMLC = false;
                                mlcStart = 0;
                            }
                        } else if (t10.getType() != 1 && !t10.endsWith(C_MLC_END)) {
                            inMLC = true;
                            mlcStart = t10.getOffset();
                        }
                    } else if (t10.is(6, KEYWORD_SECTION)) {
                        if (currentFold == null) {
                            currentFold = new Fold(0, textArea, t10.getOffset());
                            folds.add(currentFold);
                        } else {
                            currentFold = currentFold.createChild(0, t10.getOffset());
                        }
                        endWordStack.push(KEYWORD_SECTION_END);
                    } else if (t10.is(6, KEYWORD_FUNCTION)) {
                        if (currentFold == null) {
                            currentFold = new Fold(0, textArea, t10.getOffset());
                            folds.add(currentFold);
                        } else {
                            currentFold = currentFold.createChild(0, t10.getOffset());
                        }
                        endWordStack.push(KEYWORD_FUNCTION_END);
                    } else if ((NsisFoldParser.foundEndKeyword(KEYWORD_SECTION_END, t10, endWordStack) || NsisFoldParser.foundEndKeyword(KEYWORD_FUNCTION_END, t10, endWordStack)) && currentFold != null) {
                        currentFold.setEndOffset(t10.getOffset());
                        Fold parentFold = currentFold.getParent();
                        endWordStack.pop();
                        if (currentFold.isOnSingleLine() && !currentFold.removeFromParent()) {
                            folds.remove(folds.size() - 1);
                        }
                        currentFold = parentFold;
                    }
                    t10 = t10.getNextToken();
                }
                ++line;
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }
}

