/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class YamlFoldParser
implements FoldParser {
    private static boolean isSpaces(Token t10) {
        String lexeme = t10.getLexeme();
        return lexeme.trim().isEmpty();
    }

    @Override
    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Stack<Integer> indentStack = new Stack<Integer>();
        Fold currentFold = null;
        int lineCount = textArea.getLineCount();
        int lastOffset = 0;
        try {
            int line = 0;
            while (line < lineCount) {
                Token t10 = textArea.getTokenListForLine(line);
                if (t10.isPaintable()) {
                    Token startLine = t10;
                    int offset = t10.getOffset();
                    int indent = 0;
                    while (t10 != null && t10.isPaintable() && YamlFoldParser.isSpaces(t10)) {
                        indent += t10.length();
                        t10 = t10.getNextToken();
                    }
                    if (t10 != null && t10.isPaintable() && t10.isSingleChar('-')) {
                        ++indent;
                        t10 = t10.getNextToken();
                    }
                    while (!indentStack.empty()) {
                        int outer = (Integer)indentStack.peek();
                        if (outer < indent || currentFold == null) break;
                        currentFold.setEndOffset(lastOffset);
                        Fold parentFold = currentFold.getParent();
                        if (currentFold.isOnSingleLine()) {
                            YamlFoldParser.removeFold(currentFold, folds);
                        }
                        currentFold = parentFold;
                        indentStack.pop();
                    }
                    while (t10 != null && t10.isPaintable()) {
                        offset = t10.getOffset();
                        t10 = t10.getNextToken();
                    }
                    lastOffset = offset;
                    if (currentFold == null) {
                        currentFold = new Fold(0, textArea, startLine.getOffset());
                        folds.add(currentFold);
                    } else {
                        currentFold = currentFold.createChild(0, startLine.getOffset());
                    }
                    indentStack.push(indent);
                }
                ++line;
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }

    private static void removeFold(Fold fold, List<Fold> folds) {
        if (!fold.removeFromParent()) {
            folds.remove(folds.size() - 1);
        }
    }
}

