/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class ChangeableHighlightPainter
extends LayeredHighlighter.LayerPainter
implements Serializable {
    private Paint paint;
    private boolean roundedEdges;
    private transient AlphaComposite alphaComposite;
    private float alpha;
    private static final int ARCWIDTH = 8;
    private static final int ARCHEIGHT = 8;

    public ChangeableHighlightPainter() {
        this(null);
    }

    public ChangeableHighlightPainter(Paint paint) {
        this(paint, false);
    }

    public ChangeableHighlightPainter(Paint paint, boolean rounded) {
        this(paint, rounded, 1.0f);
    }

    public ChangeableHighlightPainter(Paint paint, boolean rounded, float alpha) {
        this.setPaint(paint);
        this.setRoundedEdges(rounded);
        this.setAlpha(alpha);
    }

    public float getAlpha() {
        return this.alpha;
    }

    private AlphaComposite getAlphaComposite() {
        if (this.alphaComposite == null) {
            this.alphaComposite = AlphaComposite.getInstance(3, this.alpha);
        }
        return this.alphaComposite;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public boolean getRoundedEdges() {
        return this.roundedEdges;
    }

    @Override
    public void paint(Graphics g10, int offs0, int offs1, Shape bounds, JTextComponent c10) {
        block12: {
            Rectangle alloc = bounds.getBounds();
            Graphics2D g2d = (Graphics2D)g10;
            Composite originalComposite = null;
            if (this.getAlpha() < 1.0f) {
                originalComposite = g2d.getComposite();
                g2d.setComposite(this.getAlphaComposite());
            }
            try {
                try {
                    TextUI mapper = c10.getUI();
                    Rectangle p02 = mapper.modelToView(c10, offs0);
                    Rectangle p12 = mapper.modelToView(c10, offs1);
                    Paint paint = this.getPaint();
                    if (paint == null) {
                        g2d.setColor(c10.getSelectionColor());
                    } else {
                        g2d.setPaint(paint);
                    }
                    if (p02.y == p12.y) {
                        p12.width = 0;
                        Rectangle r10 = p02.union(p12);
                        g2d.fillRect(r10.x, r10.y, r10.width, r10.height);
                        break block12;
                    }
                    int p0ToMarginWidth = alloc.x + alloc.width - p02.x;
                    g2d.fillRect(p02.x, p02.y, p0ToMarginWidth, p02.height);
                    if (p02.y + p02.height != p12.y) {
                        g2d.fillRect(alloc.x, p02.y + p02.height, alloc.width, p12.y - (p02.y + p02.height));
                    }
                    g2d.fillRect(alloc.x, p12.y, p12.x - alloc.x, p12.height);
                }
                catch (BadLocationException e10) {
                    e10.printStackTrace();
                    if (this.getAlpha() < 1.0f) {
                        g2d.setComposite(originalComposite);
                    }
                }
            }
            finally {
                if (this.getAlpha() < 1.0f) {
                    g2d.setComposite(originalComposite);
                }
            }
        }
    }

    @Override
    public Shape paintLayer(Graphics g10, int offs0, int offs1, Shape bounds, JTextComponent c10, View view) {
        Paint paint;
        Graphics2D g2d = (Graphics2D)g10;
        Composite originalComposite = null;
        if (this.getAlpha() < 1.0f) {
            originalComposite = g2d.getComposite();
            g2d.setComposite(this.getAlphaComposite());
        }
        if ((paint = this.getPaint()) == null) {
            g2d.setColor(c10.getSelectionColor());
        } else {
            g2d.setPaint(paint);
        }
        if (offs0 == offs1) {
            try {
                Shape s10 = view.modelToView(offs0, bounds, Position.Bias.Forward);
                Rectangle r10 = s10.getBounds();
                g10.drawLine(r10.x, r10.y, r10.x, r10.y + r10.height);
                return r10;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return null;
            }
        }
        if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
            Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            g2d.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
            if (this.getAlpha() < 1.0f) {
                g2d.setComposite(originalComposite);
            }
            return alloc;
        }
        try {
            Rectangle r11;
            Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
            Rectangle rectangle = r11 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (this.roundedEdges) {
                g2d.fillRoundRect(r11.x, r11.y, r11.width, r11.height, 8, 8);
            } else {
                g2d.fillRect(r11.x, r11.y, r11.width, r11.height);
            }
            if (this.getAlpha() < 1.0f) {
                g2d.setComposite(originalComposite);
            }
            Rectangle rectangle2 = r11;
            return rectangle2;
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        finally {
            if (this.getAlpha() < 1.0f) {
                g2d.setComposite(originalComposite);
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream s10) throws ClassNotFoundException, IOException {
        s10.defaultReadObject();
        int rgb = s10.readInt();
        this.paint = rgb == -1 ? null : new Color(rgb);
        this.alphaComposite = null;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        this.alpha = Math.max(alpha, 0.0f);
        this.alpha = Math.min(1.0f, alpha);
        this.alphaComposite = null;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setRoundedEdges(boolean rounded) {
        this.roundedEdges = rounded;
    }

    private void writeObject(ObjectOutputStream s10) throws IOException {
        s10.defaultWriteObject();
        int rgb = -1;
        if (this.paint != null) {
            SystemColor c10 = this.paint instanceof Color ? (Color)this.paint : SystemColor.textHighlight;
            rgb = c10.getRGB();
        }
        s10.writeInt(rgb);
    }
}

